/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.report.form;

import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.enums.ServiceCategoryEnum;
import kd.tmc.ifm.helper.DepositHelper;

public class RevEstimateReportFormPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener,
HyperLinkClickListener {
    public void registerListener(EventObject e) {
        BasedataEdit product = (BasedataEdit)this.getControl("filter_product");
        product.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        reportList.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldName;
        switch (fieldName = e.getProperty().getName()) {
            case "filter_busitype": {
                this.getModel().setValue("filter_product", null);
                break;
            }
            case "filter_statdim": {
                ReportFilter rptFilter = (ReportFilter)this.getControl("reportfilterap");
                if (EmptyUtil.isEmpty((Object)rptFilter)) break;
                rptFilter.search();
                break;
            }
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        String fieldName;
        switch (fieldName = e.getKey()) {
            case "filter_revstartdate": {
                this.validateStartEndDate(e, (String)e.getValue(), (Date)this.getModel().getValue("filter_revenddate"));
                break;
            }
            case "filter_revenddate": {
                this.validateStartEndDate(e, (Date)this.getModel().getValue("filter_revstartdate"), (String)e.getValue());
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String fieldName = event.getProperty().getName();
        List qFilters = ((ListShowParameter)event.getFormShowParameter()).getListFilterParameter().getQFilters();
        switch (fieldName) {
            case "filter_product": {
                this.addProductFilter(qFilters);
                break;
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        String fieldName = event.getFieldName();
        ReportList reportList = (ReportList)event.getSource();
        IReportListModel reportModel = reportList.getReportModel();
        int rowIndex = event.getRowIndex();
        switch (fieldName) {
            case "billno": {
                this.showDepositBill(reportModel, rowIndex);
                break;
            }
            case "oriestimateint": {
                this.showIntCalDetail(reportModel, rowIndex);
                break;
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filter = queryParam.getFilter();
        Date filterEndDate = filter.getDate("filter_revenddate");
        if (EmptyUtil.isEmpty((Object)filterEndDate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6536\u76ca\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RevEstimateReportFormPlugin_2", (String)"tmc-ifm-report", (Object[])new Object[0]));
            return false;
        }
        Date filterstartDate = filter.getDate("filter_revstartdate");
        if (EmptyUtil.isNoEmpty((Object)filterstartDate) && !filterEndDate.after(filterstartDate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6536\u76ca\u7ed3\u675f\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u6536\u76ca\u5f00\u59cb\u65e5\u671f\u3002", (String)"RevEstimateReportFormPlugin_1", (String)"tmc-ifm-report", (Object[])new Object[0]));
            return false;
        }
        DynamicObject statCurrency = (DynamicObject)this.getModel().getValue("filter_statcurrency");
        if (EmptyUtil.isEmpty((DynamicObject)statCurrency)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7edf\u8ba1\u5e01\u79cd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RevEstimateReportFormPlugin_3", (String)"tmc-ifm-report", (Object[])new Object[0]));
            return false;
        }
        return super.verifyQuery(queryParam);
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        queryParam.getFilter().addFilterItem("filter_statdim", this.getModel().getValue("filter_statdim"));
        String statDim = (String)this.getModel().getValue("filter_statdim");
        ReportList listTable = (ReportList)this.getControl("reportlistap");
        List columns = listTable.getColumns();
        ReportColumn tmpColumn = null;
        for (AbstractReportColumn perColumn : columns) {
            ReportColumn column = (ReportColumn)perColumn;
            if (!(statDim + "name").equals(column.getFieldKey())) continue;
            tmpColumn = column;
            columns.remove(column);
            break;
        }
        if (null != tmpColumn) {
            columns.add(0, tmpColumn);
        }
    }

    private void addProductFilter(List<QFilter> qFilters) {
        String busiType = (String)this.getModel().getValue("filter_busitype");
        if (EmptyUtil.isEmpty((String)busiType)) {
            return;
        }
        List busiTypeList = Arrays.stream(busiType.split(",")).filter(r -> EmptyUtil.isNoEmpty((String)r)).collect(Collectors.toList());
        if (busiTypeList.size() == 1) {
            QFilter qFilter = new QFilter("servicecategory", "in", busiTypeList);
            qFilters.add(qFilter);
        }
    }

    private void validateStartEndDate(BeforeFieldPostBackEvent e, String startDate, Date endDate) {
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{startDate, endDate})) {
            return;
        }
        Date beginDate = DateUtils.stringToDate((String)startDate, (String)"yyyy-MM-dd");
        if (!endDate.after(beginDate)) {
            e.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6536\u76ca\u7ed3\u675f\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u6536\u76ca\u5f00\u59cb\u65e5\u671f\u3002", (String)"RevEstimateReportFormPlugin_1", (String)"tmc-ifm-report", (Object[])new Object[0]));
            this.getView().updateView(e.getKey());
        }
    }

    private void validateStartEndDate(BeforeFieldPostBackEvent e, Date startDate, String endDate) {
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{startDate, endDate})) {
            return;
        }
        Date toDate = DateUtils.stringToDate((String)endDate, (String)"yyyy-MM-dd");
        if (!toDate.after(startDate)) {
            e.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6536\u76ca\u7ed3\u675f\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u6536\u76ca\u5f00\u59cb\u65e5\u671f\u3002", (String)"RevEstimateReportFormPlugin_1", (String)"tmc-ifm-report", (Object[])new Object[0]));
            this.getView().updateView(e.getKey());
        }
    }

    private void showDepositBill(IReportListModel reportModel, int rowIndex) {
        DynamicObject selectData = reportModel.getRowData(rowIndex);
        String busiType = selectData.getString("busitype");
        BillShowParameter parameter = new BillShowParameter();
        parameter.setStatus(OperationStatus.VIEW);
        String formId = ServiceCategoryEnum.NOTICE.getValue().equals(busiType) ? "ifm_notice_deposit" : "ifm_deposit";
        parameter.setFormId(formId);
        parameter.setPkId((Object)selectData.getLong("id"));
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void showIntCalDetail(IReportListModel reportModel, int rowIndex) {
        DynamicObject selectData = reportModel.getRowData(rowIndex);
        DynamicObject depositBill = TmcDataServiceHelper.loadSingle((Object)selectData.getLong("id"), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"ifm_deposit"));
        IntBillInfo intBillInfo = DepositHelper.calcDepositBillIntForReport((DynamicObject)depositBill, (Date)selectData.getDate("revstartdate"), (Date)selectData.getDate("revenddate"));
        HashMap<String, Object> param = new HashMap<String, Object>(8);
        param.put("formId", "ifm_revestcaldetailca");
        param.put("RevEstimateReport", SerializationUtils.toJsonString((Object)intBillInfo));
        param.put("currency", selectData.getDynamicObject("oricurrency").getPkValue());
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(param);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }
}

