/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.report.form;

import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.enums.AcctClassifyEnum;
import kd.tmc.ifm.helper.IfmSettleCenterHelper;

public class StatementDataListFormPlugin
extends AbstractReportFormPlugin {
    private static boolean initFlag = Boolean.FALSE;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.setFinAccF7Filter();
        this.setFinOrgF7Filter();
    }

    public void initDefaultQueryParam(ReportQueryParam queryParam) {
        DynamicObject selectedDynamicObject;
        super.initDefaultQueryParam(queryParam);
        Object selectedId = this.getView().getFormShowParameter().getCustomParam("selectedId");
        initFlag = Boolean.FALSE;
        if (selectedId != null && !Objects.isNull(selectedDynamicObject = BusinessDataServiceHelper.loadSingle((Object)selectedId, (String)"ifm_transdetail", (String)"accountbank,company"))) {
            this.getModel().setValue("filter_accountbank", selectedDynamicObject.get("accountbank"));
            this.getModel().setValue("filter_company", selectedDynamicObject.get("company"));
            ReportFilter rptFilter = (ReportFilter)this.getControl("reportfilterap");
            if (!EmptyUtil.isEmpty((Object)rptFilter)) {
                rptFilter.search();
            }
        }
        initFlag = Boolean.TRUE;
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        if ("bar_print".equals(itemKey)) {
            ReportList list = (ReportList)this.getView().getControl("reportlistap");
            int[] selectedRows = list.getEntryState().getSelectedRows();
            if (selectedRows.length < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\uff01", (String)"StatementDataListFormPlugin_0", (String)"tmc-ifm-report", (Object[])new Object[0]), Integer.valueOf(3000));
                evt.setCancel(true);
            }
            if (selectedRows.length > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u6253\u5370\u3002", (String)"StatementDataListFormPlugin_1", (String)"tmc-ifm-report", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        if (fieldKey.equals("filter_company")) {
            long newId;
            DynamicObject oldValue = (DynamicObject)changeData[0].getOldValue();
            DynamicObject newValue = (DynamicObject)changeData[0].getNewValue();
            long oldId = oldValue == null ? 0L : (Long)oldValue.getPkValue();
            long l = newId = newValue == null ? 0L : (Long)newValue.getPkValue();
            if (oldId != newId && initFlag == Boolean.TRUE) {
                this.getModel().setValue("filter_accountbank", null);
            }
        }
    }

    private void setFinAccF7Filter() {
        BasedataEdit finAcc = (BasedataEdit)this.getControl("filter_accountbank");
        finAcc.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            QFilter innerAccQFilter = new QFilter("acctclassify", "=", (Object)AcctClassifyEnum.INNER_ACCOUNT.getValue());
            innerAccQFilter.and(new QFilter("acctstatus", "!=", (Object)BankAcctStatusEnum.CLOSED.getValue()));
            DynamicObject company = (DynamicObject)this.getModel().getValue("filter_company");
            if (company != null) {
                innerAccQFilter.and(new QFilter("company.id", "=", company.get("id")));
            }
            List finorgIdList = IfmSettleCenterHelper.getAuthorizedRegisteredSettleCenterIds((Long)Long.valueOf(RequestContext.get().getUserId()), (String)TmcAppEnum.IFM.getValue(), (String)"ifm_statementrpt", (String)"47150e89000000ac");
            innerAccQFilter.and(new QFilter("bank.id", "in", (Object)finorgIdList));
            ListShowParameter showPara = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showPara.getListFilterParameter().setFilter(innerAccQFilter);
        });
    }

    private void setFinOrgF7Filter() {
        BasedataEdit finAcc = (BasedataEdit)this.getControl("filter_settcenter");
        finAcc.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            String appId = this.getView().getFormShowParameter().getAppId();
            List finorgIdList = IfmSettleCenterHelper.getAuthorizedRegisteredSettleCenterIds((Long)Long.valueOf(RequestContext.get().getUserId()), (String)TmcAppEnum.IFM.getValue(), (String)"ifm_statementrpt", (String)"47150e89000000ac");
            QFilter finOrgIdFilter = new QFilter("id", "in", (Object)finorgIdList);
            ListShowParameter showPara = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showPara.getListFilterParameter().setFilter(finOrgIdFilter);
        });
    }
}

