/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.report.form;

import com.alibaba.fastjson.JSONArray;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.helper.IfmSettleCenterHelper;

public class SubsidiaryLedgerListPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener,
BeforeF7SelectListener {
    private static Log logger = LogFactory.getLog(SubsidiaryLedgerListPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList reportlist = (ReportList)this.getView().getControl("reportlistap");
        reportlist.addHyperClickListener((HyperLinkClickListener)this);
        BasedataEdit settleCenter = (BasedataEdit)this.getControl("filter_settlecenter");
        settleCenter.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit org = (BasedataEdit)this.getControl("filter_org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit inneraccount = (BasedataEdit)this.getControl("filter_inneraccount");
        inneraccount.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit beginPeriod = (BasedataEdit)this.getControl("filter_beginperiod");
        beginPeriod.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit endPeriod = (BasedataEdit)this.getControl("filter_endperiod");
        endPeriod.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    private boolean isSettleCenterSubsidiaryLedger() {
        String appId = this.getView().getFormShowParameter().getAppId();
        return TmcAppEnum.IFM.getValue().equals(appId);
    }

    public void afterCreateNewData(EventObject e) {
        if (this.setQueryFilterVal()) {
            return;
        }
        if (this.isSettleCenterSubsidiaryLedger()) {
            this.getModel().setValue("filter_settlecenter", (Object)this.getDefaultSettleCenter());
        } else {
            String appId = this.getView().getFormShowParameter().getAppId();
            DynamicObject permOrg = TmcOrgDataHelper.getCurrentPermOrg((String)appId, (String)"ifm_subsidiaryledger", (String)"47150e89000000ac");
            DynamicObjectCollection orgs = new DynamicObjectCollection(permOrg.getDynamicObjectType(), null);
            orgs.add((Object)permOrg);
            this.getModel().setValue("filter_org", (Object)orgs);
        }
        this.setDefaultCcy();
        this.setDefaultDateFilter();
    }

    public void afterBindData(EventObject e) {
        if (!this.isSettleCenterSubsidiaryLedger()) {
            TmcViewInputHelper.registerVisibleStatus((IFormView)this.getView(), (String[])new String[]{"filter_settlecenter", "printlist"}, (boolean)false);
        }
        this.registerMustInput();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        switch (propName = e.getProperty().getName()) {
            case "filter_settlecenter": {
                this.setDefaultCcy();
                this.getModel().setValue("filter_inneraccount", null);
                break;
            }
            case "filter_org": {
                this.setDefaultCcy();
                this.setDefaultDateFilter();
                this.getModel().setValue("filter_inneraccount", null);
                break;
            }
            case "filter_querytype": {
                this.registerMustInput();
                this.setDefaultDateFilter();
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String prop;
        switch (prop = evt.getProperty().getName()) {
            case "filter_settlecenter": {
                this.settlecenterF7(evt);
                break;
            }
            case "filter_org": {
                this.orgF7(evt);
                break;
            }
            case "filter_inneraccount": {
                this.accountF7(evt);
                break;
            }
            case "filter_beginperiod": 
            case "filter_endperiod": {
                DynamicObject periodType = (DynamicObject)this.getModel().getValue("filter_periodtype");
                ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
                if (periodType == null) break;
                QFilter qFilter = new QFilter("periodtype", "=", (Object)periodType.getLong("id"));
                qFilter.and("isadjustperiod", "=", (Object)"0");
                showParameter.getListFilterParameter().setFilter(qFilter);
            }
        }
    }

    private void settlecenterF7(BeforeF7SelectEvent evt) {
        String appid = evt.getFormShowParameter().getAppId();
        if (EmptyUtil.isEmpty((String)appid)) {
            appid = TmcAppEnum.IFM.getValue();
        }
        List scIds = IfmSettleCenterHelper.getAuthorizedRegisteredSettleCenterIds((Long)RequestContext.get().getCurrUserId(), (String)appid, (String)"ifm_subsidiaryledger", (String)"47150e89000000ac");
        QFilter filter = new QFilter("id", "in", (Object)scIds);
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        showParameter.getListFilterParameter().getQFilters().add(filter);
    }

    private void orgF7(BeforeF7SelectEvent evt) {
        if (!this.isSettleCenterSubsidiaryLedger()) {
            List<Long> orgIds = this.getAuthorizedOrgIds();
            QFilter filter = new QFilter("id", "in", orgIds);
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            showParameter.getListFilterParameter().getQFilters().add(filter);
        }
    }

    private void accountF7(BeforeF7SelectEvent evt) {
        QFilter acctQF = new QFilter("inneracct", "!=", (Object)0);
        if (this.isSettleCenterSubsidiaryLedger()) {
            DynamicObject settleCenter = (DynamicObject)this.getModel().getValue("filter_settlecenter");
            if (settleCenter == null) {
                evt.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u7ed3\u7b97\u4e2d\u5fc3", (String)"AvgBalanceReportFormListPlugin_15", (String)"tmc-ifm-report", (Object[])new Object[0]));
                return;
            }
            acctQF.and(new QFilter("bank", "=", settleCenter.getPkValue()));
        } else {
            acctQF.and(new QFilter("company", "in", this.getAuthorizedOrgIds()));
        }
        DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue("filter_org");
        List orgIds = orgs.stream().map(v -> v.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList());
        if (EmptyUtil.isNoEmpty(orgIds)) {
            acctQF.and(new QFilter("company", "in", orgIds));
        }
        if (!((Boolean)this.getModel().getValue("filter_isincludeclose")).booleanValue()) {
            acctQF.and(new QFilter("acctstatus", "!=", (Object)BankAcctStatusEnum.CLOSED.getValue()));
        }
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        showParameter.setCaption(ResManager.loadKDString((String)"\u5185\u90e8\u8d26\u6237", (String)"SubsidiaryLedgerListPlugin_2", (String)"tmc-ifm-report", (Object[])new Object[0]));
        showParameter.getListFilterParameter().getQFilters().add(acctQF);
    }

    private List<Long> getAuthorizedOrgIds() {
        String appId = this.getView().getFormShowParameter().getAppId();
        if (EmptyUtil.isEmpty((String)appId)) {
            appId = TmcAppEnum.IFM.getValue();
        }
        return TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"ifm_subsidiaryledger", (String)"47150e89000000ac");
    }

    private DynamicObject getDefaultSettleCenter() {
        long orgId = RequestContext.get().getOrgId();
        QFilter qFilter = new QFilter("scorg.id", "=", (Object)orgId);
        DynamicObject[] settleCenters = TmcDataServiceHelper.load((String)"ifm_settcentersetting", (String)"settlecenter", (QFilter[])qFilter.toArray());
        if (settleCenters != null && settleCenters.length > 0) {
            return settleCenters[0].getDynamicObject("settlecenter");
        }
        List scIds = IfmSettleCenterHelper.getAuthorizedRegisteredSettleCenterIds((Long)RequestContext.get().getCurrUserId(), (String)"ifm", (String)"ifm_subsidiaryledger", (String)"47150e89000000ac");
        if (scIds.size() > 0) {
            return TmcDataServiceHelper.loadSingleFromCache(scIds.get(0), (String)"bd_finorginfo");
        }
        return null;
    }

    private void setDefaultCcy() {
        DynamicObject baseCcy = null;
        if (this.isSettleCenterSubsidiaryLedger()) {
            DynamicObject settleCenter = (DynamicObject)this.getModel().getValue("filter_settlecenter");
            if (settleCenter != null) {
                settleCenter = TmcDataServiceHelper.loadSingleFromCache((Object)settleCenter.getPkValue(), (String)"bd_finorginfo");
                DynamicObject scorg = settleCenter.getDynamicObject("org");
                Long orgId = scorg.getLong("id");
                baseCcy = this.getBaseCurrency(orgId);
            }
        } else {
            DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue("filter_org");
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)orgs)) {
                DynamicObject org;
                Iterator iterator = orgs.iterator();
                while (iterator.hasNext() && (baseCcy = this.getBaseCurrency((org = (DynamicObject)iterator.next()).getDynamicObject("fbasedataid").getLong("id"))) == null) {
                }
            }
        }
        this.getModel().setValue("filter_currency", baseCcy);
    }

    private DynamicObject getBaseCurrency(Long orgId) {
        DynamicObject baseCcy = TmcBusinessBaseHelper.getCasBaseCurrency((long)orgId);
        if (baseCcy == null) {
            baseCcy = TmcBusinessBaseHelper.getBaseCurrency((long)orgId);
        }
        return baseCcy;
    }

    private void setDefaultDateFilter() {
        if (this.isSettleCenterSubsidiaryLedger()) {
            DynamicObject settleCenter = (DynamicObject)this.getModel().getValue("filter_settlecenter");
            if (settleCenter != null) {
                DynamicObject casInit;
                DynamicObject scOrg;
                Long finorgId = settleCenter.getLong("id");
                Object[] scSettings = TmcDataServiceHelper.load((String)"ifm_settcentersetting", (String)"acceptdate", (QFilter[])new QFilter[]{new QFilter("settlecenter", "=", (Object)finorgId)});
                if (EmptyUtil.isNoEmpty((Object[])scSettings)) {
                    Date acceptDate = scSettings[0].getDate("acceptdate");
                    this.getModel().setValue("filter_begindate", (Object)acceptDate);
                    this.getModel().setValue("filter_enddate", (Object)acceptDate);
                }
                if ((scOrg = settleCenter.getDynamicObject("org")) != null && (casInit = TmcBusinessBaseHelper.getSystemStatusCtrol((long)scOrg.getLong("id"))) != null && casInit.getDynamicObject("periodtype") != null) {
                    DynamicObject periodType = casInit.getDynamicObject("periodtype");
                    this.getModel().setValue("filter_periodtype", (Object)periodType.getLong("id"));
                }
            }
        } else {
            DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue("filter_org");
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)orgs)) {
                for (DynamicObject org : orgs) {
                    DynamicObject casInit = TmcBusinessBaseHelper.getSystemStatusCtrol((long)org.getDynamicObject("fbasedataid").getLong("id"));
                    if (casInit == null || casInit.getDynamicObject("periodtype") == null) continue;
                    DynamicObject periodType = casInit.getDynamicObject("periodtype");
                    this.getModel().setValue("filter_periodtype", (Object)periodType.getLong("id"));
                }
            }
            Date curDate = DateUtils.getCurrentDate();
            this.getModel().setValue("filter_begindate", (Object)curDate);
            this.getModel().setValue("filter_enddate", (Object)curDate);
        }
        DynamicObject period = this.getPeriodByDate(DateUtils.getCurrentDate());
        this.getModel().setValue("filter_beginperiod", (Object)period);
        this.getModel().setValue("filter_endperiod", (Object)period);
    }

    private DynamicObject getPeriodByDate(Date date) {
        DynamicObject periodType = (DynamicObject)this.getModel().getValue("filter_periodtype");
        Long periodTypeId = 0L;
        if (periodType != null) {
            periodTypeId = periodType.getLong("id");
        }
        QFilter[] filters = new QFilter[]{new QFilter("begindate", "<=", (Object)date), new QFilter("enddate", ">=", (Object)date), new QFilter("periodtype", "=", (Object)periodTypeId), new QFilter("isadjustperiod", "=", (Object)"0")};
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (QFilter[])filters);
    }

    private void registerMustInput() {
        if (this.isSettleCenterSubsidiaryLedger()) {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"filter_settlecenter"});
        } else {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"filter_org"});
        }
        String queryType = (String)this.getModel().getValue("filter_querytype");
        if ("period".equals(queryType)) {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"filter_beginperiod", "filter_endperiod"});
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"filter_begindate", "filter_enddate"});
        } else {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"filter_beginperiod", "filter_endperiod"});
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"filter_begindate", "filter_enddate"});
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        boolean verifyResult = true;
        String appId = this.getView().getFormShowParameter().getAppId();
        verifyResult = TmcAppEnum.IFM.getValue().equals(appId) ? TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)true, (String)"filter_settlecenter") : TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)true, (String)"filter_org");
        String queryType = (String)this.getModel().getValue("filter_querytype");
        if ("period".equals(queryType)) {
            boolean hasInput = TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)true, (String[])new String[]{"filter_beginperiod", "filter_endperiod"});
            if (!hasInput) {
                verifyResult = false;
            } else {
                DynamicObject beginPeriod = (DynamicObject)this.getModel().getValue("filter_beginperiod");
                DynamicObject endPeriod = (DynamicObject)this.getModel().getValue("filter_endperiod");
                if (beginPeriod.getDate("begindate").after(endPeriod.getDate("enddate"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u671f\u95f4\u4e0d\u80fd\u665a\u4e8e\u7ed3\u675f\u671f\u95f4", (String)"SubsidiaryLedgerListPlugin_0", (String)"tmc-ifm-report", (Object[])new Object[0]), Integer.valueOf(3000));
                    verifyResult = false;
                }
            }
        } else {
            boolean hasInput = TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)true, (String[])new String[]{"filter_begindate", "filter_enddate"});
            if (!hasInput) {
                verifyResult = false;
            } else {
                Date endDate;
                Date beginDate = (Date)this.getModel().getValue("filter_begindate");
                if (beginDate.after(endDate = (Date)this.getModel().getValue("filter_enddate"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u7ed3\u675f\u65e5\u671f", (String)"SubsidiaryLedgerListPlugin_1", (String)"tmc-ifm-report", (Object[])new Object[0]), Integer.valueOf(3000));
                    verifyResult = false;
                }
            }
        }
        if (!TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)true, (String)"filter_currency")) {
            verifyResult = false;
        }
        return verifyResult;
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        String pageId = this.getView().getPageId();
        String appId = this.getView().getFormShowParameter().getAppId();
        queryParam.getCustomParam().putIfAbsent("pageid", pageId);
        queryParam.getCustomParam().putIfAbsent("appid", appId);
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        TreeView tree = (TreeView)this.getControl("reporttreeap");
        DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue("filter_org");
        DynamicObjectCollection accounts = (DynamicObjectCollection)this.getModel().getValue("filter_inneraccount");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)orgs) && orgs.size() == 1 && (EmptyUtil.isEmpty((DynamicObjectCollection)accounts) || accounts.size() > 1)) {
            String selectId = ((DynamicObject)orgs.get(0)).getDynamicObject("fbasedataid").getString("id");
            List selectedNodeIds = tree.getTreeState().getSelectedNodeId();
            selectedNodeIds.remove("0");
            if (EmptyUtil.isEmpty((Collection)selectedNodeIds) || EmptyUtil.isNoEmpty((Object)selectedNodeIds) && ((String)selectedNodeIds.get(0)).equals(selectId)) {
                return;
            }
            TreeNode node = new TreeNode();
            node.setId(selectId);
            tree.focusNode(node);
            tree.treeNodeClick("", selectId);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        int rowIdx = evt.getRowIndex();
        ReportList reportList = (ReportList)evt.getSource();
        IReportListModel reportModel = reportList.getReportModel();
        DynamicObject rowData = reportModel.getRowData(rowIdx);
        Long pkId = 0L;
        String formId = "";
        if ("sourcebillno".equals(evt.getFieldName())) {
            Long sourceBillId = rowData.getLong("sourcebillid");
            String sourceBillType = rowData.getString("sourcebilltype");
            if (EmptyUtil.isNoEmpty((Long)sourceBillId)) {
                pkId = sourceBillId;
                formId = "ifm_transhandlebill".equals(sourceBillType) ? "ifm_transhandle_ps_l" : sourceBillType;
            }
        } else if ("transdetailbillno".equals(evt.getFieldName())) {
            String transDetailNo = rowData.getString("transdetailbillno");
            DynamicObject detail = TmcDataServiceHelper.loadSingle((String)"ifm_transdetail", (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)transDetailNo)});
            pkId = detail.getLong("id");
            formId = "ifm_transdetail";
        }
        BillShowParameter sp = new BillShowParameter();
        sp.setPkId((Object)pkId);
        sp.setStatus(OperationStatus.VIEW);
        sp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        sp.setFormId(formId);
        this.getView().showForm((FormShowParameter)sp);
    }

    private boolean setQueryFilterVal() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (!customParams.containsKey("filter_querytype")) {
            return false;
        }
        this.getModel().setValue("filter_settlecenter", customParams.get("filter_settlementcenter"));
        this.getModel().setValue("filter_org", (Object)((JSONArray)customParams.get("filter_company")).toArray());
        this.getModel().setValue("filter_currency", customParams.get("filter_orgcurrency"));
        this.getModel().setValue("filter_isincludeclose", customParams.get("filter_close"));
        this.getModel().setValue("filter_inneraccount", (Object)((JSONArray)customParams.get("filter_bankaccount")).toArray());
        this.getModel().setValue("filter_querytype", customParams.get("filter_querytype"));
        this.getModel().setValue("filter_beginperiod", customParams.get("filter_beginperiod"));
        this.getModel().setValue("filter_endperiod", customParams.get("filter_endperiod"));
        this.getModel().setValue("filter_begindate", customParams.get("filter_begindate"));
        this.getModel().setValue("filter_enddate", customParams.get("filter_enddate"));
        ReportFilter rptFilter = (ReportFilter)this.getControl("reportfilterap");
        rptFilter.search();
        return true;
    }
}

