/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.report.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.enums.AcctClassifyEnum;

public class BalanceReportFilterParamHelper {
    public static QFilter initOrgFilter(Map<String, Object> paramMap) {
        ArrayList<Long> comList = new ArrayList<Long>();
        if (EmptyUtil.isNoEmpty((Object)paramMap.get("filter_company"))) {
            DynamicObjectCollection companys = (DynamicObjectCollection)paramMap.get("filter_company");
            for (DynamicObject company : companys) {
                comList.add(company.getLong("id"));
            }
        }
        QFilter ofilter = null;
        if (comList.size() > 0) {
            ofilter = new QFilter("company.id", "in", comList);
        }
        return ofilter;
    }

    public static QFilter[] buildAccountFilter(Map<String, Object> paramMap) {
        Object acctType;
        DynamicObjectCollection acctUseAge;
        Object acctProp;
        DynamicObjectCollection currencys;
        DynamicObjectCollection bankAccount;
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        filterList.add(BalanceReportFilterParamHelper.initOrgFilter(paramMap));
        boolean isClose = (Boolean)paramMap.get("filter_close");
        if (!isClose) {
            filterList.add(new QFilter("acctstatus", "not in", (Object)BankAcctStatusEnum.CLOSED.getValue()));
        }
        filterList.add(new QFilter("acctclassify", "=", (Object)AcctClassifyEnum.INNER_ACCOUNT.getValue()));
        DynamicObject settlementCenter = (DynamicObject)paramMap.get("filter_settlementcenter");
        if (!Objects.isNull(settlementCenter)) {
            filterList.add(new QFilter("bank", "=", settlementCenter.getPkValue()));
        }
        if (!CollectionUtils.isEmpty((Collection)(bankAccount = (DynamicObjectCollection)paramMap.get("filter_bankaccount")))) {
            filterList.add(new QFilter("id", "in", (Object)bankAccount.stream().map(DataEntityBase::getPkValue).toArray()));
        }
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)(currencys = (DynamicObjectCollection)paramMap.get("filter_orgcurrency")))) {
            filterList.add(new QFilter("currency.fbasedataid", "in", (Object)currencys.stream().map(DataEntityBase::getPkValue).toArray()));
        }
        if (!Objects.isNull(acctProp = paramMap.get("filter_acctprop"))) {
            String acctPropStrOrig = acctProp.toString();
            String acctPropStr = acctPropStrOrig.substring(acctPropStrOrig.indexOf(44) + 1, acctPropStrOrig.lastIndexOf(44));
            List acctPropList = Arrays.stream(acctPropStr.split(",")).collect(Collectors.toList());
            filterList.add(new QFilter("accttype", "in", acctPropList));
        }
        if (!Objects.isNull(acctUseAge = (DynamicObjectCollection)paramMap.get("filter_acctuseage"))) {
            filterList.add(new QFilter("acctproperty", "in", acctUseAge.stream().map(item -> (Long)item.getPkValue()).collect(Collectors.toList())));
        }
        if (!Objects.isNull(acctType = paramMap.get("filter_accttype"))) {
            String acctTypeStrOrig = acctType.toString();
            String acctTypeStr = acctTypeStrOrig.substring(acctType.toString().indexOf(44) + 1, acctTypeStrOrig.lastIndexOf(44));
            List acctTypeList = Arrays.stream(acctTypeStr.split(",")).collect(Collectors.toList());
            filterList.add(new QFilter("acctstyle", "in", acctTypeList));
        }
        return filterList.toArray(new QFilter[0]);
    }
}

