/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.report.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.org.model.OrgTreeParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.enums.ReportUnitEnum;

public class ReportHelper {
    public static DynamicObjectCollection getFinOrgDefaultValue(String appId, String entityName) {
        if (StringUtils.equals((CharSequence)"ifm", (CharSequence)appId)) {
            long currUserId = RequestContext.get().getCurrUserId();
            DynamicObjectCollection finOrgCols = new DynamicObjectCollection();
            long orgId = RequestContext.get().getOrgId();
            QFilter finOrgFilter = new QFilter("org", "=", (Object)orgId);
            List<Object> finOrgTypeIds = ReportHelper.getFinOrgIds();
            QFilter finTypeFilter = new QFilter("finorgtype", "in", finOrgTypeIds);
            DynamicObject finOrgDyn = TmcDataServiceHelper.loadSingleFromCache((String)"bd_finorginfo", (QFilter[])new QFilter[]{finOrgFilter, finTypeFilter});
            if (EmptyUtil.isNoEmpty((DynamicObject)finOrgDyn)) {
                finOrgCols.add((Object)finOrgDyn);
            } else {
                List<Long> orgIds = ReportHelper.getAuthOrgIds(currUserId, appId, entityName);
                QFilter allOrgFilter = new QFilter("org", "in", orgIds);
                List finOrgIds = QueryServiceHelper.queryPrimaryKeys((String)"bd_finorginfo", (QFilter[])new QFilter[]{allOrgFilter, finTypeFilter}, (String)"createtime", (int)1);
                if (EmptyUtil.isNoEmpty((Object)finOrgIds)) {
                    finOrgDyn = TmcDataServiceHelper.loadSingle(finOrgIds.get(0), (String)"bd_finorginfo");
                    finOrgCols.add((Object)finOrgDyn);
                }
            }
            if (finOrgCols.size() == 0) {
                return null;
            }
            return finOrgCols;
        }
        return null;
    }

    public static List<Object> getFinOrgIds() {
        QFilter finOrgFilter = new QFilter("type", "=", (Object)FinOrgTypeEnum.CLEARINGHOUSE.getValue());
        finOrgFilter.and("enable", "=", (Object)"1");
        List finOrgTypeIds = QueryServiceHelper.queryPrimaryKeys((String)"bd_finorgtype", (QFilter[])finOrgFilter.toArray(), (String)"", (int)-1);
        return finOrgTypeIds;
    }

    public static List<Long> getAuthOrgIds(long currUserId, String appId, String entityName) {
        return TmcOrgDataHelper.getAuthorizedBankOrgId((Long)currUserId, (String)appId, (String)entityName, (String)"47150e89000000ac");
    }

    public static DataSet changeUnit(DataSet origDS, String unit, List<String> changeFields) {
        DataSet ds = origDS.copy();
        String divisor = ReportUnitEnum.getValueByUnitKey((String)unit);
        for (String changeField : changeFields) {
            ds = ds.copy().updateField(changeField, String.format("%s/%s", changeField, divisor));
        }
        return ds;
    }

    public static String getOrgRootId(String orgViewNumber) {
        OrgTreeParam param = new OrgTreeParam();
        param.setOrgViewNumber(orgViewNumber);
        TreeNode rootNode = OrgUnitServiceHelper.getTreeRootNodeById((OrgTreeParam)param);
        return rootNode != null ? rootNode.getId() : null;
    }

    @Deprecated
    public static Long getExchageTableId(Long orgId) {
        return TmcBusinessBaseHelper.getExchageTableId((Long)orgId);
    }

    public static DynamicObject getBaseCurrency(Long orgId) {
        DynamicObject baseCcy = TmcBusinessBaseHelper.getCasBaseCurrency((long)orgId);
        if (baseCcy == null) {
            baseCcy = TmcBusinessBaseHelper.getBaseCurrency((long)orgId);
        }
        return baseCcy;
    }

    public static DataSet getExChangeDataSet(DataSet currencyDataSet, Long exChangetabelid, Long tarCurrencyId, Long orgId) {
        if (EmptyUtil.isEmpty((Long)exChangetabelid)) {
            exChangetabelid = TmcBusinessBaseHelper.getExchageTableId((Long)orgId);
        }
        ArrayList<Field> field = new ArrayList<Field>();
        field.add(new Field("currency", (DataType)DataType.LongType));
        field.add(new Field("tarcurrency", (DataType)DataType.LongType));
        field.add(new Field("rate", (DataType)DataType.BigDecimalType));
        RowMeta rowMeta = new RowMeta(field.toArray(new Field[0]));
        Algo algo = Algo.create((String)"");
        DataSetBuilder dsBuilder = algo.createDataSetBuilder(rowMeta);
        HashMap<Long, BigDecimal> rateMap = new HashMap<Long, BigDecimal>();
        for (Row row : currencyDataSet) {
            Long currencyId = row.getLong("currency");
            if (rateMap.containsKey(currencyId)) continue;
            if (currencyId.equals(tarCurrencyId)) {
                rateMap.put(currencyId, BigDecimal.ONE);
                continue;
            }
            BigDecimal exchangeRate = BaseDataServiceHelper.getExchangeRate((Long)exChangetabelid, (Long)currencyId, (Long)tarCurrencyId, (Date)DateUtils.getCurrentDate());
            if (exchangeRate == null) {
                DynamicObject fromCurrency = BusinessDataServiceHelper.loadSingleFromCache((Object)currencyId, (String)"bd_currency", (String)"name");
                DynamicObject toCurrency = BusinessDataServiceHelper.loadSingleFromCache((Object)tarCurrencyId, (String)"bd_currency", (String)"name");
                DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (String)"bos_org", (String)"name");
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u627e\u4e0d\u5230%2$s\u5151%3$s\u7684\u6c47\u7387", (String)"ReportHelper_0", (String)"tmc-ifm-report", (Object[])new Object[0]), org.getString("name"), fromCurrency.getString("name"), toCurrency.getString("name")));
            }
            rateMap.put(currencyId, exchangeRate);
        }
        for (Long currencyId : rateMap.keySet()) {
            Object[] obj = new Object[]{currencyId, tarCurrencyId, rateMap.get(currencyId)};
            dsBuilder.append(obj);
        }
        return dsBuilder.build();
    }

    public static DynamicObject getPeriodByDate(Date date, Long periodTypeId) {
        QFilter[] filters = new QFilter[]{new QFilter("begindate", "<=", (Object)date), new QFilter("enddate", ">=", (Object)date), new QFilter("periodtype", "=", (Object)periodTypeId), new QFilter("isadjustperiod", "=", (Object)"0")};
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (QFilter[])filters);
    }

    public static DataSet getEmptyDs() {
        RowMeta emptyRowMeta = new RowMeta(new String[]{"empty"}, new DataType[]{DataType.StringType});
        return Algo.create((String)"EmptyDataSet").createDataSetBuilder(emptyRowMeta).build();
    }

    public static String getUnit(String currencyUnit) {
        String divisor = "1";
        switch (currencyUnit) {
            case "Billion": {
                divisor = "100000000";
                break;
            }
            case "Million": {
                divisor = "1000000";
                break;
            }
            case "TenThousand": {
                divisor = "10000";
                break;
            }
            case "Thousand": {
                divisor = "1000";
                break;
            }
            case "Original": {
                divisor = "1";
            }
        }
        return divisor;
    }
}

