/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.opplugin.transhandlebill;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.ReturnOperationArgs;
import kd.bos.entity.plugin.args.RollbackOperationArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.log.PayLogger;
import kd.tmc.fbp.common.log.builder.PayTraceLogPayBillBuilder;
import kd.tmc.fbp.common.log.enums.PayLogLevelEnum;
import kd.tmc.fbp.common.log.enums.PayTraceLogStepEmum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.opplugin.TmcOperationServicePlugIn;
import kd.tmc.fbp.service.ebservice.bean.SyncStatusDetail;
import kd.tmc.fbp.service.ebservice.bean.SyncStatusInfo;
import kd.tmc.ifm.business.validator.transhandlebill.TransHandleBillPayValidator;
import kd.tmc.ifm.enums.TransBillPaidStatusEnum;
import kd.tmc.ifm.mservice.ebservice.PayInfoFactory;
import kd.tmc.ifm.mservice.ebservice.sync.BankBillSyncStatusHelper;

public class TransHandleBillCommitBeOp
extends TmcOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(TransHandleBillCommitBeOp.class);
    private static PayLogger traceLogger = PayLogger.create(TransHandleBillCommitBeOp.class);
    public Map<Long, Long> billIdsToPayBills = new HashMap<Long, Long>();
    public List<OperateErrorInfo> errorInfos = new ArrayList<OperateErrorInfo>();
    private Map<Long, Date> commitTimeMap = new HashMap<Long, Date>();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("paidstatus");
        fieldKeys.add("transtype");
        fieldKeys.add("bankreturnmsg");
        fieldKeys.add("isurgent");
        fieldKeys.add("sourcebillid");
        fieldKeys.add("sourcebilltype");
        fieldKeys.add("agentpayeraccount");
        fieldKeys.add("feepayer");
        fieldKeys.add("feeactbank");
        fieldKeys.add("feecurrency");
    }

    public AbstractTmcBizOppValidator getBizOppValidator() {
        return new TransHandleBillPayValidator();
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] bills = e.getDataEntities();
        List<Long> billIds = Arrays.stream(bills).map(o -> o.getLong("id")).collect(Collectors.toList());
        List<Long> canDoIds = this.beforeGeneratePayBill(billIds);
        bills = BusinessDataServiceHelper.load((Object[])canDoIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ifm_transhandlebill"));
        HashMap<Long, Long> bankBillIdsToBillIds = new HashMap<Long, Long>();
        List<DynamicObject> billList = Arrays.asList(bills);
        List bankBills = PayInfoFactory.transPayBillToBankBill(billList);
        bankBills.stream().forEach(o -> bankBillIdsToBillIds.put(o.getLong("id"), o.getLong("sourcebillid")));
        this.dealLog(billList, bankBills);
        OperationResult opResult = this.saveBankBill(bankBills);
        traceLogger.logBatch(new PayTraceLogPayBillBuilder(billList, PayLogLevelEnum.INFO.getValue(), PayTraceLogStepEmum.CREATE.getValue(), ResManager.loadKDString((String)"\u4fdd\u5b58\u94f6\u884c\u5355\u636e", (String)"TransHandleBillCommitBeOp_0", (String)"tmc-ifm-opplugin", (Object[])new Object[0]), SerializationUtils.toJsonString((Object)opResult), null).build());
        List successIdList = opResult.getSuccessPkIds();
        this.dealMsg_SaveBankBill(opResult, bankBillIdsToBillIds);
        bankBillIdsToBillIds.entrySet().stream().filter(o -> successIdList.contains(o.getKey())).forEach(o -> this.billIdsToPayBills.put((Long)o.getValue(), (Long)o.getKey()));
        this.updateBillStatus(bills);
    }

    private void dealMsg_SaveBankBill(OperationResult opResult, Map<Long, Long> bankBillIdsToBillIds) {
        for (OperateErrorInfo errorInfo : opResult.getAllErrorInfo()) {
            OperateErrorInfo temp = new OperateErrorInfo();
            Long billPk = bankBillIdsToBillIds.get(errorInfo.getPkValue());
            temp.setPkValue((Object)billPk);
            temp.setMessage((String)this.operationResult.getBillNos().get(billPk) + "\uff1a" + errorInfo.getMessage());
            temp.setLevel(ErrorLevel.FatalError);
            this.errorInfos.add(temp);
        }
        if (this.errorInfos.size() == 0 && this.operationResult.getMessage() == null && opResult.getMessage() != null) {
            this.operationResult.setMessage(this.extractResultErrorMessage(opResult));
            if (opResult.getSuccessPkIds().size() <= 0) {
                this.operationResult.setSuccess(false);
            }
        }
    }

    private String extractResultErrorMessage(OperationResult opResult) {
        List opInfoList = opResult.getAllErrorOrValidateInfo();
        StringBuilder stringBuilder = new StringBuilder();
        for (IOperateInfo info : opInfoList) {
            stringBuilder.append(info.getMessage());
        }
        if (EmptyUtil.isEmpty((String)stringBuilder.toString())) {
            stringBuilder.append(opResult.getMessage());
        }
        return stringBuilder.toString();
    }

    private void dealLog(List<DynamicObject> billList, List<DynamicObject> bankBillList) {
        PayTraceLogPayBillBuilder logBuilder = new PayTraceLogPayBillBuilder(billList.size());
        HashMap id_bankBill = new HashMap(bankBillList.size());
        bankBillList.forEach(o -> id_bankBill.put(o.getLong("sourcebillid"), o));
        billList.forEach(o -> logBuilder.addLog(o, SerializationUtils.toJsonString(id_bankBill.get(o.getLong("id"))), PayLogLevelEnum.INFO.getValue(), PayTraceLogStepEmum.CREATE.getValue(), ResManager.loadKDString((String)"\u751f\u6210\u94f6\u884c\u5355\u636e", (String)"TransHandleBillCommitBeOp_3", (String)"tmc-ifm-opplugin", (Object[])new Object[0]), null));
        traceLogger.logBatch(logBuilder.build());
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        Map<Long, Long> transAcceptMap = Arrays.stream(e.getDataEntities()).filter(o -> this.billIdsToPayBills.containsKey(o.getLong("id")) && "ifm_payacceptancebill".equals(o.getString("sourcebilltype"))).collect(Collectors.toMap(o -> o.getLong("id"), o -> o.getLong("sourcebillid")));
        if (EmptyUtil.isEmpty(transAcceptMap) || transAcceptMap.size() == 0) {
            return;
        }
        DynamicObjectCollection payAcceptColl = QueryServiceHelper.query((String)"ifm_payacceptancebill", (String)"id,sourcebillid,sourcebilltype", (QFilter[])new QFilter[]{new QFilter("id", "in", transAcceptMap.values())});
        Map<Long, Long> acceptCasMap = payAcceptColl.stream().filter(o -> "cas_paybill".equals(o.getString("sourcebilltype"))).collect(Collectors.toMap(o -> o.getLong("id"), o -> o.getLong("sourcebillid")));
        if (EmptyUtil.isEmpty(acceptCasMap) || acceptCasMap.size() == 0) {
            return;
        }
        for (DynamicObject dataEntity : e.getDataEntities()) {
            Long acceptId = transAcceptMap.get(dataEntity.getLong("id"));
            SyncStatusInfo syncStatusInfo = BankBillSyncStatusHelper.getSyncStatusInfo((Long)dataEntity.getLong("id"), (Long)acceptCasMap.get(acceptId), (String)"");
            List detailList = syncStatusInfo.getDetailList();
            for (SyncStatusDetail detail : detailList) {
                detail.setEbStatusMsg("");
            }
            syncStatusInfo.setBankPayStatus(BeBillStatusEnum.OP.getValue());
            syncStatusInfo.setCommitBe(true);
            syncStatusInfo.setCommitBeTime(this.commitTimeMap.get(dataEntity.getLong("id")));
            syncStatusInfo.setBitBack(false);
            syncStatusInfo.setBitBackOpinion("");
            BankBillSyncStatusHelper.syncPaymentBill((SyncStatusInfo)syncStatusInfo, null, null, (boolean)true);
        }
    }

    public void rollbackOperation(RollbackOperationArgs e) {
        super.rollbackOperation(e);
        if (this.billIdsToPayBills.size() > 0) {
            try (TXHandle handle = TX.requiresNew();){
                DeleteServiceHelper.delete((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)"bei_bankpaybill"), (Object[])this.billIdsToPayBills.values().toArray(new Long[0]));
            }
            catch (Exception exception) {
                logger.error("commitbe rollback:delete bankbill fail");
                logger.error((Throwable)exception);
            }
        }
    }

    public void onReturnOperation(ReturnOperationArgs e) {
        super.onReturnOperation(e);
        if (this.errorInfos.size() > 0) {
            ValidateResult vr = new ValidateResult();
            vr.setAllErrorInfo(this.errorInfos);
            if (this.operationResult.getValidateResult() != null && this.operationResult.getValidateResult().getValidateErrors() != null) {
                this.operationResult.getValidateResult().getValidateErrors().add(vr);
            }
        }
        List successPair = this.billIdsToPayBills.entrySet().stream().map(o -> {
            JSONObject result = new JSONObject();
            result.put("payBillId", o.getKey());
            result.put("bankBillId", o.getValue());
            return result;
        }).collect(Collectors.toList());
        e.getOperationResult().setSuccessPkIds(successPair);
    }

    public OperationResult saveBankBill(List<DynamicObject> bankBills) {
        OperationResult opResult;
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("srcEntityNumber", "ifm_transhandlebill");
        try (TXHandle handle = TX.requiresNew();){
            try {
                opResult = OperationServiceHelper.executeOperate((String)"save", (String)"bei_bankpaybill", (DynamicObject[])bankBills.toArray(new DynamicObject[0]), (OperateOption)option);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                handle.markRollback();
                throw e;
            }
        }
        return opResult;
    }

    protected List<Long> beforeGeneratePayBill(List<Long> idList) {
        String sql = "Update t_ifm_transhandle_e Set fpaidstatus = ? Where Fid in (" + TmcBusinessBaseHelper.idListToString(idList) + ") and fpaidstatus = ?";
        DB.executeBatch((DBRoute)new DBRoute("tmc"), (String)sql, Collections.singletonList(new Object[]{TransBillPaidStatusEnum.WAITING.getValue(), TransBillPaidStatusEnum.WAITING.getValue()}));
        QFilter[] filter = new QFilter[]{new QFilter("id", "in", idList)};
        DynamicObject[] bankpay = BusinessDataServiceHelper.load((String)"ifm_transhandlebill", (String)"id,paidstatus", (QFilter[])filter);
        ArrayList<Long> canDoIds = new ArrayList<Long>();
        for (DynamicObject info : bankpay) {
            if (info.getString("paidstatus").equals(TransBillPaidStatusEnum.WAITING.getValue())) {
                canDoIds.add(info.getLong("id"));
                continue;
            }
            OperateErrorInfo errorInfo = new OperateErrorInfo();
            errorInfo.setMessage(ResManager.loadKDString((String)"%s\uff1a\u5f85\u4ed8\u6b3e\u7684\u5355\u636e\u624d\u53ef\u4ee5\u63d0\u4ea4\u94f6\u4f01\u3002", (String)"TransHandleBillCommitBeOp_1", (String)"tmc-ifm-opplugin", (Object[])new Object[]{this.operationResult.getBillNos().get(info.getLong("id"))}));
            errorInfo.setPkValue((Object)info.getLong("id"));
            errorInfo.setLevel(ErrorLevel.FatalError);
            this.errorInfos.add(errorInfo);
        }
        return canDoIds;
    }

    public void updateBillStatus(DynamicObject[] bills) {
        ArrayList<DynamicObject> updateBills = new ArrayList<DynamicObject>();
        for (DynamicObject payBill : bills) {
            if (!this.billIdsToPayBills.containsKey(payBill.getLong("id"))) continue;
            Date currentDate = new Date();
            payBill.set("iscommitbe", (Object)true);
            payBill.set("paidstatus", (Object)TransBillPaidStatusEnum.PAYING.getValue());
            payBill.set("commitbetime", (Object)currentDate);
            payBill.set("bankpaystatus", (Object)BeBillStatusEnum.OP.getValue());
            payBill.set("bankreturnmsg", (Object)"");
            updateBills.add(payBill);
            this.commitTimeMap.put(payBill.getLong("id"), currentDate);
        }
        if (updateBills.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])updateBills.toArray(new DynamicObject[0]));
            traceLogger.logBatch(new PayTraceLogPayBillBuilder(updateBills, PayLogLevelEnum.INFO.getValue(), PayTraceLogStepEmum.CREATE.getValue(), ResManager.loadKDString((String)"\u66f4\u65b0\u4e1a\u52a1\u5355\u636e\u3002", (String)"TransHandleBillCommitBeOp_2", (String)"tmc-ifm-opplugin", (Object[])new Object[0]), null, null).build());
        }
    }
}

