/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.bean;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.tmc.fbp.common.model.interest.PlanCallResult;

public class AccountBalanceInfo
extends PlanCallResult
implements Serializable {
    public void subtractFreeBalance(BigDecimal freeBalance) {
        BigDecimal principle = this.getPrinciple().subtract(freeBalance);
        this.setPrinciple(AccountBalanceInfo.compareZero(principle) < 0 ? BigDecimal.ZERO : principle);
    }

    private static Integer compareZero(BigDecimal value) {
        return value.compareTo(BigDecimal.ZERO);
    }

    public static void subtractFreeBalance(BigDecimal freeBalance, List<AccountBalanceInfo> balanceList) {
        if (freeBalance == null || AccountBalanceInfo.compareZero(freeBalance) == 0) {
            return;
        }
        balanceList.stream().filter(b -> AccountBalanceInfo.compareZero(b.getPrinciple()) >= 0).forEach(balance -> balance.subtractFreeBalance(freeBalance));
    }

    public static AccountBalanceInfo build(boolean isPayInt, Date bizDate, BigDecimal principle, BigDecimal floatRate) {
        AccountBalanceInfo into = new AccountBalanceInfo();
        into.setPayInt(isPayInt);
        into.setFloatRate(floatRate);
        into.setBizDate(bizDate);
        into.setPrinciple(principle);
        return into;
    }
}

