/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.bean;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BasisEnum;
import kd.tmc.fbp.common.enums.InterTypeEnum;
import kd.tmc.fbp.common.enums.RateTypeEnum;
import kd.tmc.fbp.common.helper.MarketDataServiceHelper;
import kd.tmc.fbp.common.model.interest.RateInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.bean.PrincipleFloatRateInfo;
import kd.tmc.ifm.enums.IntObjInterestTypeEnum;
import kd.tmc.ifm.enums.InterestWayEnum;
import kd.tmc.ifm.enums.RateSignEnum;
import kd.tmc.ifm.helper.InterestCalcHelper;

public class IntObjectInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int INITIAL_CAPACITY = 16;
    private static final String RATEDAY = "365";
    private BigDecimal overPoints;
    private Date startIntDate;
    private Date lastIntDate;
    private Date lastPreIntDate;
    private BigDecimal freeBalance;
    private BigDecimal intThresholdBalance;
    private BigDecimal initIntBalance;
    private BasisEnum basis;
    private List<RateInfo> rateList;
    private boolean isCalOverInt;
    private IntObjInterestTypeEnum interestType;
    private List<PrincipleFloatRateInfo> principleFloatRateList;

    public static IntObjectInfo initInitObjectInfo(DynamicObject intObject) {
        IntObjectInfo initObjInfo = new IntObjectInfo();
        DynamicObject product = intObject.getDynamicObject("referrate");
        initObjInfo.setBasis(BasisEnum.valueOf((String)product.getString("interestratedays")));
        ArrayList<RateInfo> allRateList = new ArrayList<RateInfo>(IntObjectInfo.querySubsectionRateList(product));
        Collections.sort(allRateList, Comparator.comparing(RateInfo::getEffectiveDate));
        initObjInfo.setRateList(allRateList);
        IntObjectInfo.setInfoRate(intObject, initObjInfo);
        return initObjInfo;
    }

    public static IntObjectInfo initInitObjectInfo(DynamicObject intObject, Date endDate) {
        IntObjectInfo initObjInfo = new IntObjectInfo();
        DynamicObject referrate = intObject.getDynamicObject("referrate");
        Date startIntDate = intObject.getDate("startintdate");
        Date lastIntDate = intObject.getDate("lastintdate");
        Date beginDate = lastIntDate == null ? startIntDate : lastIntDate;
        Map rateDatas = MarketDataServiceHelper.referRate((String)referrate.getString("number"), (Date)beginDate, (Date)endDate);
        ArrayList<RateInfo> allRateList = new ArrayList<RateInfo>(rateDatas.size());
        for (Map.Entry entry : rateDatas.entrySet()) {
            allRateList.add(IntObjectInfo.createRateInfo((Date)entry.getKey(), (BigDecimal)entry.getValue()));
        }
        if (BasisEnum.Actual_365.getValue().equals(intObject.getString("interestratedays"))) {
            initObjInfo.setBasis(BasisEnum.Actual_365);
        } else {
            initObjInfo.setBasis(BasisEnum.Actual_360);
        }
        Collections.sort(allRateList, Comparator.comparing(RateInfo::getEffectiveDate));
        initObjInfo.setRateList(allRateList);
        IntObjectInfo.setInfoRate(intObject, initObjInfo);
        return initObjInfo;
    }

    private static void setInfoRate(DynamicObject intObject, IntObjectInfo initObjInfo) {
        initObjInfo.setCalOverInt(intObject.getBoolean("iscaloverint"));
        initObjInfo.setOverPoints(IntObjectInfo.getOverPoints(intObject));
        initObjInfo.setStartIntDate(intObject.getDate("startintdate"));
        initObjInfo.setLastIntDate(intObject.getDate("lastintdate"));
        Date intObjectStartPreIntDate = InterestCalcHelper.getIntObjectStartPreIntDate(intObject);
        if (EmptyUtil.isNoEmpty((Object)intObjectStartPreIntDate)) {
            intObjectStartPreIntDate = DateUtils.getLastDay((Date)intObjectStartPreIntDate, (int)1);
        }
        initObjInfo.setLastPreIntDate(intObjectStartPreIntDate);
        BigDecimal freeBalance = IntObjectInfo.getBigDecimalDefaultZero(intObject, "intfreeamt");
        initObjInfo.setFreeBalance(freeBalance);
        BigDecimal initIntBalance = IntObjectInfo.getBigDecimalDefaultZero(intObject, "initaccum");
        initObjInfo.setInitIntBalance(initIntBalance);
        BigDecimal intThresholdBalance = BigDecimal.ZERO;
        BigDecimal intThreshold = intObject.getBigDecimal("intthreshold");
        if (intThreshold != null) {
            intThresholdBalance = BigDecimal.valueOf(Math.pow(10.0, intThreshold.doubleValue()));
        }
        initObjInfo.setIntThresholdBalance(intThresholdBalance);
        IntObjInterestTypeEnum interestType = IntObjInterestTypeEnum.ofValue(intObject.getString("interesttype"));
        initObjInfo.setInterestType(interestType);
        List<PrincipleFloatRateInfo> floatRateList = IntObjectInfo.getPrincipleFloatRateInfoList(intObject);
        initObjInfo.setPrincipleFloatRateList(floatRateList);
    }

    private static RateInfo createRateInfo(Date effectiveDate, BigDecimal rate) {
        RateInfo rateInfo = new RateInfo();
        rateInfo.setEffectiveDate(effectiveDate);
        rateInfo.setRate(rate);
        rateInfo.setRateType(RateTypeEnum.YEAR);
        return rateInfo;
    }

    public static Set<RateInfo> querySubsectionRateList(DynamicObject product) {
        HashSet<RateInfo> rateList = new HashSet<RateInfo>(16);
        DynamicObjectCollection histEntry = product.getDynamicObjectCollection("hist_entry");
        if (!CollectionUtils.isEmpty((Collection)histEntry)) {
            histEntry.stream().forEach(v -> rateList.add(IntObjectInfo.createRateInfo(v.getDate("e_effectivedate"), v.getBigDecimal("e_price_num"))));
        }
        return rateList;
    }

    private static BigDecimal getOverPoints(DynamicObject intObject) {
        BigDecimal overPoints = BigDecimal.ZERO;
        if (intObject.getBoolean("iscaloverint")) {
            overPoints = intObject.getBigDecimal("overpoints");
            String overSign = intObject.getString("oversign");
            if (StringUtils.equals((CharSequence)overSign, (CharSequence)"subtract")) {
                overPoints = overPoints.multiply(Constants._ONE);
            }
        }
        return overPoints;
    }

    private static BigDecimal getBigDecimalDefaultZero(DynamicObject dynamicObj, String propName) {
        BigDecimal value = dynamicObj.getBigDecimal(propName);
        return value != null ? value : BigDecimal.ZERO;
    }

    private static List<PrincipleFloatRateInfo> getPrincipleFloatRateInfoList(DynamicObject intObject) {
        DynamicObjectCollection overint_entry;
        if (!InterestWayEnum.isProgression(intObject.getString("interestway"))) {
            return null;
        }
        ArrayList<PrincipleFloatRateInfo> floatRateList = new ArrayList<PrincipleFloatRateInfo>(16);
        DynamicObjectCollection depositint_entry = intObject.getDynamicObjectCollection("depositint_entry");
        if (!CollectionUtils.isEmpty((Collection)depositint_entry)) {
            for (DynamicObject entry : depositint_entry) {
                BigDecimal intFloatPoint = entry.getBigDecimal("intfloatpoint");
                PrincipleFloatRateInfo rateInfo = IntObjectInfo.buildPrincipleFloatRateInfo(entry.getBigDecimal("depositamtbegin"), entry.getBigDecimal("depositamtend"), IntObjectInfo.getIntFloatPoint(intFloatPoint, entry.getString("intfloatway")), InterTypeEnum.normal);
                floatRateList.add(rateInfo);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(overint_entry = intObject.getDynamicObjectCollection("overint_entry")))) {
            for (DynamicObject entry : overint_entry) {
                BigDecimal overIntFloatPoint = entry.getBigDecimal("overintfloatpoint");
                PrincipleFloatRateInfo rateInfo = IntObjectInfo.buildPrincipleFloatRateInfo(entry.getBigDecimal("depositbegin"), entry.getBigDecimal("depositend"), IntObjectInfo.getIntFloatPoint(overIntFloatPoint, entry.getString("overfloatway")), InterTypeEnum.overdue);
                floatRateList.add(rateInfo);
            }
        }
        return floatRateList;
    }

    private static BigDecimal getIntFloatPoint(BigDecimal intFloatPoint, String intFloatWay) {
        if (RateSignEnum.isSubtract(intFloatWay)) {
            intFloatPoint = intFloatPoint.negate();
        }
        return intFloatPoint;
    }

    private static PrincipleFloatRateInfo buildPrincipleFloatRateInfo(BigDecimal beginPrinciple, BigDecimal endPrinciple, BigDecimal floatRate, InterTypeEnum interTypeEnum) {
        PrincipleFloatRateInfo rateInfo = new PrincipleFloatRateInfo();
        rateInfo.setBeginPrinciple(beginPrinciple);
        rateInfo.setEndPrinciple(endPrinciple);
        rateInfo.setFloatRate(floatRate);
        rateInfo.setFloatRateType(interTypeEnum);
        return rateInfo;
    }

    public BigDecimal getOverPoints() {
        return this.overPoints;
    }

    public IntObjectInfo setOverPoints(BigDecimal overPoints) {
        this.overPoints = overPoints;
        return this;
    }

    public Date getStartIntDate() {
        return this.startIntDate;
    }

    public IntObjectInfo setStartIntDate(Date startIntDate) {
        this.startIntDate = startIntDate;
        return this;
    }

    public Date getLastIntDate() {
        return this.lastIntDate;
    }

    public IntObjectInfo setLastIntDate(Date lastIntDate) {
        this.lastIntDate = lastIntDate;
        return this;
    }

    public Date getLastPreIntDate() {
        return this.lastPreIntDate;
    }

    public IntObjectInfo setLastPreIntDate(Date lastPreIntDate) {
        this.lastPreIntDate = lastPreIntDate;
        return this;
    }

    public BigDecimal getFreeBalance() {
        return this.freeBalance;
    }

    public IntObjectInfo setFreeBalance(BigDecimal freeBalance) {
        this.freeBalance = freeBalance;
        return this;
    }

    public BigDecimal getIntThresholdBalance() {
        return this.intThresholdBalance;
    }

    public IntObjectInfo setIntThresholdBalance(BigDecimal intThresholdBalance) {
        this.intThresholdBalance = intThresholdBalance;
        return this;
    }

    public BigDecimal getInitIntBalance() {
        return this.initIntBalance;
    }

    public IntObjectInfo setInitIntBalance(BigDecimal initIntBalance) {
        this.initIntBalance = initIntBalance;
        return this;
    }

    public BasisEnum getBasis() {
        return this.basis;
    }

    public IntObjectInfo setBasis(BasisEnum basis) {
        this.basis = basis;
        return this;
    }

    public List<RateInfo> getRateList() {
        return this.rateList;
    }

    public IntObjectInfo setRateList(List<RateInfo> rateList) {
        this.rateList = rateList;
        return this;
    }

    public boolean isCalOverInt() {
        return this.isCalOverInt;
    }

    public IntObjectInfo setCalOverInt(boolean calOverInt) {
        this.isCalOverInt = calOverInt;
        return this;
    }

    public IntObjInterestTypeEnum getInterestType() {
        return this.interestType;
    }

    public IntObjectInfo setInterestType(IntObjInterestTypeEnum interestType) {
        this.interestType = interestType;
        return this;
    }

    public List<PrincipleFloatRateInfo> getPrincipleFloatRateList() {
        return this.principleFloatRateList;
    }

    public IntObjectInfo setPrincipleFloatRateList(List<PrincipleFloatRateInfo> principleFloatRateList) {
        this.principleFloatRateList = principleFloatRateList;
        return this;
    }
}

