/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.enums;

import java.util.Arrays;
import kd.tmc.fbp.common.enums.MultiLangEnumBridge;

public enum TransTypeEnum {
    INNER_AGENT_PAY("1", new MultiLangEnumBridge("\u5185\u90e8\u4ee3\u4ed8", "TransTypeEnum_0", "tmc-ifm-common")),
    INNER_TRANSFER("2", new MultiLangEnumBridge("\u5185\u90e8\u8f6c\u8d26", "TransTypeEnum_1", "tmc-ifm-common")),
    INNER_FUND_TRANSFER("3", new MultiLangEnumBridge("\u8d44\u91d1\u4e0b\u62e8", "TransTypeEnum_2", "tmc-ifm-common")),
    INNER_DEDUCTION("6", new MultiLangEnumBridge("\u5185\u90e8\u6263\u6b3e", "TransTypeEnum_15", "tmc-ifm-common")),
    LOAN_REGAIN("7", new MultiLangEnumBridge("\u8d37\u6b3e\u6536\u56de", "TransTypeEnum_7", "tmc-ifm-common")),
    LOAN_INTEREST("8", new MultiLangEnumBridge("\u8d37\u6b3e\u7ed3\u606f", "TransTypeEnum_8", "tmc-ifm-common")),
    CURRENT_INTEREST("9", new MultiLangEnumBridge("\u5b58\u6b3e\u7ed3\u606f", "TransTypeEnum_9", "tmc-ifm-common")),
    INNER_FUND_RECEIVE("4", new MultiLangEnumBridge("\u5185\u90e8\u6536\u6b3e", "TransTypeEnum_3", "tmc-ifm-common")),
    INNER_FUND_COLLECTION("5", new MultiLangEnumBridge("\u8d44\u91d1\u4e0a\u5212", "TransTypeEnum_5", "tmc-ifm-common")),
    BANK_DEDUCTION("10", new MultiLangEnumBridge("\u94f6\u884c\u6263\u6b3e", "TransTypeEnum_10", "tmc-ifm-common")),
    DEPOSIT("11", new MultiLangEnumBridge("\u6d3b\u8f6c\u5b9a", "TransTypeEnum_11", "tmc-ifm-common")),
    RELEASE("12", new MultiLangEnumBridge("\u5b9a\u8f6c\u6d3b", "TransTypeEnum_12", "tmc-ifm-common")),
    REVENUE("15", new MultiLangEnumBridge("\u5b9a\u671f\u6536\u76ca", "TransTypeEnum_16", "tmc-ifm-common")),
    LINKAGE_PAY("14", new MultiLangEnumBridge("\u8054\u52a8\u652f\u4ed8", "TransTypeEnum_14", "tmc-ifm-common"));

    private String value;
    private MultiLangEnumBridge bridge = null;

    private TransTypeEnum(String value, MultiLangEnumBridge bridge) {
        this.value = value;
        this.bridge = bridge;
    }

    public String getValue() {
        return this.value;
    }

    public static String getName(String value) {
        return Arrays.stream(TransTypeEnum.values()).filter(t -> t.value.equals(value)).map(TransTypeEnum::getName).findFirst().orElse(null);
    }

    public String getName() {
        return this.bridge.loadKDString();
    }

    public static boolean isAgentPay(Object value) {
        return INNER_AGENT_PAY.getValue().equals(value);
    }

    public static boolean isBankDeduction(Object value) {
        return BANK_DEDUCTION.getValue().equals(value);
    }

    public static boolean isLinkagePAY(Object value) {
        return LINKAGE_PAY.getValue().equals(value);
    }

    public static boolean isInnerTransfer(Object value) {
        return INNER_TRANSFER.getValue().equals(value);
    }

    public static boolean isInnerFundTransfer(Object value) {
        return INNER_FUND_TRANSFER.getValue().equals(value);
    }

    public static boolean isInnerFundCollection(Object value) {
        return INNER_FUND_COLLECTION.getValue().equals(value);
    }

    public static boolean isRelease(Object value) {
        return RELEASE.getValue().equals(value);
    }

    public static boolean isDeposit(Object value) {
        return DEPOSIT.getValue().equals(value);
    }

    public static boolean isInnerDeduction(Object value) {
        return INNER_DEDUCTION.getValue().equals(value);
    }

    public static boolean isLoanRegain(Object value) {
        return LOAN_REGAIN.getValue().equals(value);
    }

    public static boolean isLoanInterest(Object value) {
        return LOAN_INTEREST.getValue().equals(value);
    }

    public static boolean isAutoPayType(String transType) {
        return TransTypeEnum.isInnerFundTransfer(transType) || TransTypeEnum.isInnerTransfer(transType) || TransTypeEnum.isRelease(transType) || TransTypeEnum.isDeposit(transType) || TransTypeEnum.isInnerDeduction(transType) || TransTypeEnum.isLoanRegain(transType) || TransTypeEnum.isLoanInterest(transType);
    }

    public static boolean isInnerPayType(String transType) {
        return TransTypeEnum.isAgentPay(transType) || TransTypeEnum.isInnerTransfer(transType) || TransTypeEnum.isInnerDeduction(transType) || TransTypeEnum.isLinkagePAY(transType);
    }

    public static boolean isBookJournalType(String transType) {
        return TransTypeEnum.isAgentPay(transType) || TransTypeEnum.isInnerFundTransfer(transType);
    }
}

