/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.helper;

import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.bean.BizBalanceModelBean;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.BizBalanceModelHelper;
import kd.tmc.fbp.common.helper.TmcParameterHelper;

public class BankAccountBalanceHelper {
    private static final Log logger = LogFactory.getLog(BankAccountBalanceHelper.class);

    public static List<DynamicObject> getRecentAccountBalancesBank(Long bankAccountIds, String fields, QFilter[] filters) {
        return BankAccountBalanceHelper.getAccountBalancesBank(bankAccountIds, fields, filters);
    }

    public static List<DynamicObject> getRecentAccountBalancesNoBank(Long bankAccountIds, String fields, QFilter[] filters) {
        return BankAccountBalanceHelper.getAccountBalancesNoBank(bankAccountIds, fields, filters);
    }

    public static List<DynamicObject> getAccountBalancesBank(Long bankAccountId, String fields, QFilter[] filters) {
        List<QFilter> filterLst = Stream.of(filters).collect(Collectors.toList());
        filterLst.add(new QFilter("bankaccount", "=", (Object)bankAccountId));
        DynamicObjectCollection accountbalancesBank = QueryServiceHelper.query((String)"cas_accountbalance", (String)fields, (QFilter[])filterLst.toArray(new QFilter[0]));
        logger.info("accountbalance:query:" + accountbalancesBank);
        return accountbalancesBank;
    }

    public static List<DynamicObject> getAccountBalancesNoBank(Long bankAccountIds, String fields, QFilter[] filters) {
        List<QFilter> filterLst = Stream.of(filters).collect(Collectors.toList());
        filterLst.add(new QFilter("accountbank", "=", (Object)bankAccountIds));
        DynamicObjectCollection accountbalancesNoBank = QueryServiceHelper.query((String)"bei_bankbalance", (String)fields, (QFilter[])filterLst.toArray(new QFilter[0]));
        logger.info("bankbalance:query:" + accountbalancesNoBank);
        return accountbalancesNoBank;
    }

    public static BigDecimal getBankBalance(Long accountId, Long orgId, Long currencyId) {
        String balancetype = TmcParameterHelper.getAppStringParameter((String)TmcAppEnum.FCS.getId(), (long)orgId, (String)"balancevalue");
        logger.info("\u67e5\u8be2\u8d26\u6237\u4f59\u989d\uff1a\u8d26\u6237\u7c7b\u578b\uff1a{}\uff0c\u8d26\u6237id\uff1a{}\uff0c\u5e01\u79cd\uff1a{}", new Object[]{balancetype, accountId, currencyId});
        BizBalanceModelBean balanceBean = BizBalanceModelHelper.getRunningBalance((String)balancetype, (long)accountId, (long)currencyId);
        if (balanceBean == null || balanceBean.getAmount() == null) {
            return null;
        }
        return balanceBean.getAmount();
    }
}

