/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.ifm.helper.SystemParamHelper;

public class BankAccountHelper {
    private static final Log logger = LogFactory.getLog(BankAccountHelper.class);

    public static DynamicObject getBankAccounts(Long bankAccountIds) {
        String fields = "id,issetbankinterface,finorgtype";
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bd_accountbanks", (String)fields, (QFilter[])new QFilter("id", "=", (Object)bankAccountIds).toArray());
    }

    public static List<Object> getBankAccountsPkByOrgs(Set orgIds) {
        QFilter[] filters = new QFilter[]{new QFilter("company", "in", (Object)orgIds), new QFilter("acctstatus", "in", (Object)new String[]{"normal", "closing"})};
        return QueryServiceHelper.queryPrimaryKeys((String)"bd_accountbanks", (QFilter[])filters, null, (int)-1);
    }

    public static List<DynamicObject> getBankAccountsByOrgs(Set orgIds) {
        QFilter[] filters = new QFilter[]{new QFilter("company", "in", (Object)orgIds), new QFilter("acctstatus", "in", (Object)new String[]{"normal", "closing"})};
        String fields = "id,issetbankinterface,finorgtype";
        Map accountBanks = BusinessDataServiceHelper.loadFromCache((String)"bd_accountbanks", (String)fields, (QFilter[])filters);
        return new ArrayList<DynamicObject>(accountBanks.values());
    }

    public static List<DynamicObject> getAllBankAccountsByOrgs(Set<Long> orgList) {
        return BankAccountHelper.getAllBankAccountsByOrgs(orgList, "id,issetbankinterface,finorgtype", null);
    }

    public static List<DynamicObject> getAllBankAccountsByOrgs(Set<Long> orgList, String fields) {
        return BankAccountHelper.getAllBankAccountsByOrgs(orgList, fields, null);
    }

    public static List<DynamicObject> getAllBankAccountsByOrgs(Set<Long> orgList, String fields, QFilter[] otherFilters) {
        if (orgList == null || orgList.isEmpty()) {
            return new ArrayList<DynamicObject>();
        }
        QFilter accountFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountbanks", new ArrayList<Long>(orgList), (boolean)true);
        QFilter statusFilter = new QFilter("acctstatus", "in", (Object)new String[]{"normal", "closing"});
        Object[] basicFilters = new QFilter[]{accountFilter, statusFilter};
        Map accountBanks = BusinessDataServiceHelper.loadFromCache((String)"bd_accountbanks", (String)fields, (QFilter[])((QFilter[])ArrayUtils.addAll((Object[])basicFilters, (Object[])otherFilters)));
        logger.info(String.format("[TMC-MON-MB]BankAccountHelper getAllBankAccountsByOrgs orgIdList:%s,bankAccountIdList:%s", SerializationUtils.toJsonString(orgList), SerializationUtils.toJsonString(accountBanks.keySet())));
        return new ArrayList<DynamicObject>(accountBanks.values());
    }

    static Map<String, Set<Long>> dealBankAccounts(List<DynamicObject> bankAccounts) {
        HashSet<Long> accountIdsBank = new HashSet<Long>();
        HashSet<Long> accountIdsNoBank = new HashSet<Long>();
        String dataSource = (String)SystemParamHelper.getDataSource();
        if (StringUtils.equals((CharSequence)"A", (CharSequence)dataSource)) {
            accountIdsBank.addAll(bankAccounts.stream().map(dy -> dy.getLong("id")).collect(Collectors.toSet()));
        } else if (StringUtils.equals((CharSequence)"B", (CharSequence)dataSource)) {
            accountIdsNoBank.addAll(bankAccounts.stream().map(dy -> dy.getLong("id")).collect(Collectors.toSet()));
        } else {
            for (DynamicObject bankAcct : bankAccounts) {
                if (bankAcct.getString("finorgtype").equals("1") || bankAcct.getBoolean("issetbankinterface")) {
                    accountIdsBank.add(bankAcct.getLong("id"));
                    continue;
                }
                accountIdsNoBank.add(bankAcct.getLong("id"));
            }
        }
        HashMap<String, Set<Long>> map = new HashMap<String, Set<Long>>();
        map.put("accountIdsBank", accountIdsBank);
        map.put("accountIdsNoBank", accountIdsNoBank);
        return map;
    }
}

