/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.helper;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.model.interest.IntBillDetailInfo;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.enums.WriteOffStatusEnum;
import kd.tmc.ifm.helper.SettleIntWriteOffHelper;

public class BatchIntHelper {
    public static void writeBackIntObject(DynamicObject[] bankIntBills, boolean isAudit, boolean isPreInt) {
        HashMap<Object, Date> bankIntObjectMap = new HashMap<Object, Date>(bankIntBills.length);
        for (DynamicObject bankIntBill : bankIntBills) {
            Object intObjectId = bankIntBill.getDynamicObject("intobject").getPkValue();
            Date interestDay = isAudit ? bankIntBill.getDate("interestday") : DateUtils.getLastDay((Date)bankIntBill.getDate("begindate"), (int)1);
            bankIntObjectMap.put(intObjectId, interestDay);
        }
        Set bankIntObjectIds = bankIntObjectMap.keySet();
        DynamicObject[] bankIntObjects = TmcDataServiceHelper.load((String)"ifm_bankacctintobject", (String)"lastintdate,lastpreintdate,intobject,interestway,enable,status", (QFilter[])new QFilter[]{new QFilter("id", "in", bankIntObjectIds)});
        String writeBackDate = isPreInt ? "lastpreintdate" : "lastintdate";
        for (DynamicObject bankIntObject : bankIntObjects) {
            Date bizDate = (Date)bankIntObjectMap.get(bankIntObject.getPkValue());
            bankIntObject.set(writeBackDate, (Object)bizDate);
        }
        SaveServiceHelper.update((DynamicObject[])bankIntObjects);
    }

    public static DynamicObject pushIntBill(DynamicObject row, String batchNo, String bizType, String entityName) {
        DynamicObject bankIntBill = TmcDataServiceHelper.newDynamicObject((String)entityName);
        bankIntBill.set("batchno", (Object)batchNo);
        bankIntBill.set("biztype", (Object)bizType);
        bankIntBill.set("currency", (Object)row.getDynamicObject("currency"));
        bankIntBill.set("billstatus", (Object)BillStatusEnum.SUBMIT.getValue());
        DynamicObject intObject = row.getDynamicObject("intobject");
        bankIntBill.set("intobject", (Object)intObject);
        bankIntBill.set("inneracct", intObject.getDynamicObject("intobject").getPkValue());
        bankIntBill.set("begindate", (Object)row.getDate("startdate"));
        bankIntBill.set("enddate", (Object)row.getDate("enddate"));
        bankIntBill.set("interestday", (Object)row.getDate("enddate"));
        bankIntBill.set("intamount", (Object)row.getBigDecimal("interestamt"));
        bankIntBill.set("actualinstamt", (Object)row.getBigDecimal("actualinstamt"));
        bankIntBill.set("createtime", (Object)DateUtils.getCurrentTime());
        bankIntBill.set("creator", (Object)RequestContext.get().getCurrUserId());
        bankIntBill.set("org", intObject.getDynamicObject("org").getPkValue());
        bankIntBill.set("writeoffstatus", (Object)WriteOffStatusEnum.NO_WRITEOFF.getValue());
        IntBillInfo intBillInfo = (IntBillInfo)JSON.parseObject((String)row.getString("intdetail_tag"), IntBillInfo.class);
        BatchIntHelper.fillIntAmount(bankIntBill, intBillInfo);
        SettleIntWriteOffHelper.setScOrg(bankIntBill, intObject);
        List intDetails = intBillInfo.getDetails();
        DynamicObjectCollection intEntry = bankIntBill.getDynamicObjectCollection("entry");
        intDetails.sort(Comparator.comparing(IntBillDetailInfo::getBeginDate));
        for (IntBillDetailInfo intDetail : intDetails) {
            DynamicObject newEntry = intEntry.addNew();
            newEntry.set("inststartdate", (Object)intDetail.getBeginDate());
            newEntry.set("instenddate", (Object)intDetail.getEndDate());
            newEntry.set("instdays", (Object)intDetail.getDays());
            newEntry.set("instprincipal", (Object)intDetail.getPrinciple());
            newEntry.set("intrate", (Object)intDetail.getRate());
            newEntry.set("instctg", (Object)"normal");
            newEntry.set("instamount", (Object)intDetail.getAmount());
            newEntry.set("intType", (Object)intDetail.getIntType().getValue());
        }
        return bankIntBill;
    }

    public static void writeBackIntDetail(DynamicObjectCollection entry, List<Object> intDetailIds) {
        DynamicObject[] intDetails = TmcDataServiceHelper.load((String)"ifm_currentintbill_bank", (String)"billno,intobject", (QFilter[])new QFilter[]{new QFilter("id", "in", intDetailIds)});
        Map intDetailMap = Arrays.stream(intDetails).collect(Collectors.toMap(v -> v.getDynamicObject("intobject").getPkValue(), Function.identity(), (o1, o2) -> o1, HashMap::new));
        for (DynamicObject row : entry) {
            DynamicObject intDetail = (DynamicObject)intDetailMap.get(row.getDynamicObject("intobject").getPkValue());
            if (!EmptyUtil.isNoEmpty((DynamicObject)intDetail)) continue;
            row.set("intdetailnum", (Object)intDetail.getString("billno"));
            row.set("intbillid", intDetail.getPkValue());
            row.set("status", (Object)"success");
        }
    }

    private static void fillIntAmount(DynamicObject bankIntBill, IntBillInfo intBillInfo) {
        bankIntBill.set("amount", (Object)intBillInfo.getAmount());
        List details = intBillInfo.getDetails();
        BigDecimal deposit = BigDecimal.ZERO;
        BigDecimal depositIntAmt = BigDecimal.ZERO;
        for (IntBillDetailInfo detail : details) {
            deposit = deposit.add(detail.getPrinciple());
            depositIntAmt = depositIntAmt.add(detail.getAmount());
        }
        bankIntBill.set("deposit", (Object)deposit);
        bankIntBill.set("intamount", (Object)depositIntAmt);
    }

    public static void loanIntDetailInfo(DynamicObject entry, AbstractFormPlugin formPlugin, IDataModel dataModel) {
        formPlugin.getView().setVisible(Boolean.TRUE, new String[]{"intentry"});
        formPlugin.getView().setVisible(Boolean.FALSE, new String[]{"sofrintentry"});
        BatchIntHelper.initIntTypeComb(formPlugin, dataModel);
        Object currency = entry.getDynamicObject("currency").getPkValue();
        String callIntStr = entry.getString("intdetail_tag");
        if (EmptyUtil.isEmpty((String)callIntStr)) {
            return;
        }
        IntBillInfo intBillInfo = (IntBillInfo)SerializationUtils.fromJsonString((String)callIntStr, IntBillInfo.class);
        List details = intBillInfo.getDetails();
        details.sort((arg0, arg1) -> arg0.getBeginDate().compareTo(arg1.getBeginDate()));
        ArrayList dataMap = new ArrayList(details.size());
        for (IntBillDetailInfo intDetail : details) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("intstartdate", intDetail.getBeginDate());
            data.put("intenddate", intDetail.getEndDate());
            data.put("intentrydays", intDetail.getDays());
            data.put("intprinciple", intDetail.getPrinciple());
            data.put("intrate", intDetail.getRate());
            data.put("intdate", intDetail.getBeginDate());
            data.put("intcurrency", currency);
            data.put("entryinterestamt", intDetail.getAmount());
            data.put("basis", intDetail.getBasisDay());
            data.put("intcategory", intDetail.getIntType().getValue());
            dataMap.add(data);
        }
        TmcViewInputHelper.batchFillEntity((String)"intentry", (AbstractFormDataModel)((AbstractFormDataModel)dataModel), dataMap);
        formPlugin.getView().updateView("intentry");
    }

    private static void initIntTypeComb(AbstractFormPlugin formPlugin, IDataModel dataModel) {
        boolean isCurrentPre;
        ComboEdit categoryComb = (ComboEdit)formPlugin.getControl("intcategory");
        Object currentIntType = formPlugin.getView().getFormShowParameter().getCustomParams().get("currentinttype");
        String pModelName = dataModel.getDataEntityType().getName();
        boolean isCurrentInt = EmptyUtil.isNoEmpty(currentIntType) || pModelName.equals("ifm_intbill_batch_current");
        boolean bl = isCurrentPre = pModelName.equals("ifm_intbill_batch_pre") && "currentint".equals(dataModel.getValue("interesttype"));
        if (!isCurrentInt && !isCurrentPre) {
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(2);
            comboItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5e38\u5229\u606f", (String)"BatchIntHelper_0", (String)"tmc-ifm-formplugin", (Object[])new Object[0])), "normal"));
            comboItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u903e\u671f\u5229\u606f", (String)"BatchIntHelper_1", (String)"tmc-ifm-formplugin", (Object[])new Object[0])), "overdue"));
            comboItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5c55\u671f\u5229\u606f", (String)"BatchIntHelper_2", (String)"tmc-ifm-formplugin", (Object[])new Object[0])), "extend"));
            categoryComb.setComboItems(comboItems);
        }
    }
}

