/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.helper;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.fbp.common.helper.CasBusinessHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.service.servicehlper.BankServiceHelper;

public class DeductionBankHelper {
    public static DynamicObject getDefaultAccount(Object orgId, String field) {
        if (EmptyUtil.isEmpty((Object)orgId)) {
            return null;
        }
        QFilter filter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountbanks", (Long)((Long)orgId)).and(new QFilter("acctstatus", "=", (Object)"normal")).and(new QFilter(field, "=", (Object)"1"));
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bd_accountbanks", (String)"id,acctname,bankaccountnumber,bank,defaultcurrency,currency", (QFilter[])new QFilter[]{filter});
    }

    public static BigDecimal getCurrBalance(DynamicObject bankAcct, Object currencyId) {
        BigDecimal balance = null;
        boolean isOpenBei = bankAcct.getBoolean("issetbankinterface");
        if (isOpenBei) {
            balance = DeductionBankHelper.getBeiCurrBalance(bankAcct, currencyId);
        } else {
            try {
                balance = DeductionBankHelper.getBankCurrBalance(bankAcct, currencyId);
            }
            catch (KDBizException e) {
                return BigDecimal.ZERO;
            }
        }
        return balance;
    }

    private static BigDecimal getBeiCurrBalance(DynamicObject bankAcct, Object currencyId) {
        BigDecimal balance = BankServiceHelper.getCurBalance((Long)((Long)bankAcct.getPkValue()), (Long)((Long)currencyId));
        balance = balance == null ? BigDecimal.ZERO : balance;
        return balance;
    }

    private static BigDecimal getBankCurrBalance(DynamicObject bankAcct, Object currencyId) {
        BigDecimal balance = CasBusinessHelper.getBalance((long)((Long)bankAcct.get("company_id")), (long)((Long)bankAcct.getPkValue()), (long)((Long)currencyId));
        balance = balance == null ? BigDecimal.ZERO : balance;
        return balance;
    }
}

