/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.helper;

import com.alibaba.fastjson.JSON;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ElecReceiptViewHelper {
    public static void showElecReceiptBank(String entityName, List<Long> billIds, IFormView view) {
        Set<Long> detailIds = ElecReceiptViewHelper.getDetails(billIds, entityName);
        Set<String> receiptNos = ElecReceiptViewHelper.getReceipts(detailIds);
        ElecReceiptViewHelper.showBill(receiptNos, detailIds, view, "bei_transdetail");
    }

    public static Set<String> getReceipts(Set<Long> detailIds) {
        Set<String> receiptNos = new HashSet<String>();
        if (EmptyUtil.isNoEmpty(detailIds)) {
            DynamicObjectCollection details = QueryServiceHelper.query((String)"ifm_transdetail", (String)"receiptNo", (QFilter[])new QFilter[]{new QFilter("id", "in", detailIds)});
            receiptNos = details.stream().map(detail -> detail.getString("receiptNo")).collect(Collectors.toSet());
        }
        return receiptNos;
    }

    public static Set<Long> getDetails(List<Long> billIds, String entityName) {
        boolean isPayBill;
        String bankCheckFlag;
        DynamicObjectCollection bills;
        Set bankCheckFlags;
        HashSet<Long> detailIds = new HashSet<Long>();
        if (EmptyUtil.isEmpty(billIds)) {
            return detailIds;
        }
        DynamicObjectCollection transBills = QueryServiceHelper.query((String)"bei_transdetail_cas", (String)"id,recedbillentry.e_recedbillid billid", (QFilter[])new QFilter[]{new QFilter("recedbillentry.e_recedbillid", "in", billIds)});
        List existBillIds = transBills.stream().map(o -> o.getLong("billid")).collect(Collectors.toList());
        detailIds.addAll(transBills.stream().map(o -> o.getLong("id")).collect(Collectors.toSet()));
        billIds.removeAll(existBillIds);
        if (!"cas_recbill".equals(entityName) && billIds.size() > 0 && EmptyUtil.isNoEmpty(bankCheckFlags = (bills = QueryServiceHelper.query((String)entityName, (String)(bankCheckFlag = (isPayBill = "ifm_transhandlebill".equals(entityName)) ? "beibankcheckflag" : "bankcheckflag"), (QFilter[])new QFilter[]{new QFilter("id", "in", billIds), new QFilter(bankCheckFlag, "!=", (Object)" ")})).stream().filter(o -> EmptyUtil.isNoEmpty((String)o.getString(bankCheckFlag))).map(o -> o.getString(bankCheckFlag)).collect(Collectors.toSet()))) {
            List detailId = QueryServiceHelper.queryPrimaryKeys((String)"ifm_transdetail", (QFilter[])new QFilter[]{new QFilter("bankcheckflag", "in", bankCheckFlags)}, null, (int)-1);
            detailIds.addAll(detailId.stream().map(d -> (Long)d).collect(Collectors.toList()));
        }
        return detailIds;
    }

    public static void showElecReceiptInner(List<Long> billIds, IFormView view) {
        DynamicObjectCollection details = QueryServiceHelper.query((String)"ifm_transdetail", (String)"id,receiptNo", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", billIds)});
        Set<Long> innerDetails = details.stream().map(o -> o.getLong("id")).collect(Collectors.toSet());
        Set<String> receiptNos = details.stream().map(o -> o.getString("receiptno")).collect(Collectors.toSet());
        ElecReceiptViewHelper.showBill(receiptNos, innerDetails, view, "ifm_transdetail");
    }

    public static void showBill(Set<String> receiptNos, Set<Long> innerDetails, IFormView view, String entityName) {
        if (EmptyUtil.isEmpty(innerDetails)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u5173\u8054\u7684\u7535\u5b50\u56de\u5355", (String)"ElecReceiptViewHelper_0", (String)"tmc-ifm-common", (Object[])new Object[0]));
            return;
        }
        FormShowParameter para = new FormShowParameter();
        para.setFormId("cas_multitag");
        para.setCustomParam("receiptNo", (Object)JSON.toJSONString(receiptNos));
        para.setCustomParam("detailIds", (Object)JSON.toJSONString(innerDetails));
        para.setCustomParam("entityName", (Object)entityName);
        para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        view.showForm(para);
    }

    public static void openElecView(List<String> receiptNos, IFormView view) {
        List elecNos = receiptNos.stream().filter(o -> EmptyUtil.isNoEmpty((String)o)).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(elecNos)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u5173\u8054\u7684\u7535\u5b50\u56de\u5355", (String)"ElecReceiptViewHelper_0", (String)"tmc-ifm-common", (Object[])new Object[0]));
            return;
        }
        List receiptLists = (List)DispatchServiceHelper.invokeBizService((String)"tmc", (String)"bei", (String)"viewreceipt", (String)"getElecByReceiptno", (Object[])new Object[]{view.getPageId(), elecNos.toArray()});
        long noUrls = receiptLists.stream().filter(o -> EmptyUtil.isEmpty((Object)JSON.parseObject((String)o).get((Object)"url"))).count();
        if ((long)receiptNos.size() == noUrls) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u5173\u8054\u7684\u7535\u5b50\u56de\u5355", (String)"ElecReceiptViewHelper_0", (String)"tmc-ifm-common", (Object[])new Object[0]));
            return;
        }
        for (String receiptList : receiptLists) {
            Object url = JSON.parseObject((String)receiptList).get((Object)"url");
            if (EmptyUtil.isEmpty((Object)url)) continue;
            FormShowParameter para = new FormShowParameter();
            para.setFormId("bos_printpreview");
            para.setCustomParam("src", (Object)String.valueOf(url));
            para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            para.setCaption(ResManager.loadKDString((String)"\u8054\u67e5\u56de\u5355", (String)"ElecReceiptViewHelper_1", (String)"tmc-ifm-common", (Object[])new Object[0]));
            view.showForm(para);
        }
    }
}

