/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.helper;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeMap;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.model.BalanceQueryParam;

public class GLBalanceHelper {
    private static Log log = LogFactory.getLog((String)GLBalanceHelper.class.getName());

    public static Map<Date, BigDecimal> getBalance(Long accountOrgId, Long currencyId, Long accountId, String itemType, Long flexId, Date beginDate, Date endDate) {
        HashMap<Date, BigDecimal> balanceMap = new HashMap<Date, BigDecimal>();
        BalanceQueryParam param = new BalanceQueryParam();
        param.addSelector("beginfor");
        param.addSelector("endfor");
        param.setOrgId(accountOrgId);
        DynamicObject accountBook = GLBalanceHelper.getAccountBook(accountOrgId);
        if (EmptyUtil.isEmpty((DynamicObject)accountBook)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u67e5\u8be2\u4e0d\u5230\u4f1a\u8ba1\u8d26\u7c3f", (String)"GLBalanceHelper_0", (String)"tmc-ifm-common", (Object[])new Object[0]));
        }
        long bookTypeId = accountBook.getDynamicObject("bookstype").getLong("id");
        param.setBookTypeId(bookTypeId);
        GLBalanceHelper.setAssTypeValue(accountId, itemType, flexId, param);
        param.setCurrencyId(currencyId);
        long periodId = accountBook.getDynamicObject("periodtype").getLong("id");
        DynamicObject period = GLBalanceHelper.getPeriodByDate(accountOrgId, beginDate, periodId);
        param.setPeriodId(period.getLong("id"));
        BigDecimal initBalanceAmt = Constants.ZERO;
        long beginTime = System.currentTimeMillis();
        log.info(String.format("\u79d1\u76ee\u4f59\u989d\u53d6\u6570\u53c2\u6570\uff1a%s", param.toString()));
        String result = (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)"gl", (String)"BalanceService", (String)"getBalance", (Object[])new Object[]{param.toString()});
        log.info(String.format("\u79d1\u76ee\u4f59\u989d\u53d6\u6570\u8fd4\u56de\u6570\u636e\uff1a%s,\u8017\u65f6\uff1a%s", result, System.currentTimeMillis() - beginTime));
        List initBalance = JSON.parseArray((String)result, Map.class);
        initBalanceAmt = initBalance.stream().map(v -> (BigDecimal)v.get("beginfor")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        Map<Date, BigDecimal> dailyGLBalance = GLBalanceHelper.getDailyGLBalance(accountOrgId, accountId, currencyId, flexId, bookTypeId, period.getDate("begindate"), endDate);
        GLBalanceHelper.genBalance(balanceMap, initBalanceAmt, dailyGLBalance, period.getDate("begindate"), beginDate, endDate);
        return balanceMap;
    }

    public static Map<Date, BigDecimal> getDailyGLBalance(Long orgId, Long accountId, Long currencyId, Long flexId, Long bookTypeId, Date startDate, Date endDate) {
        BigDecimal sign;
        TreeMap<Date, BigDecimal> voucherAmts = new TreeMap<Date, BigDecimal>();
        StringBuilder sqlStr = new StringBuilder();
        ArrayList<Comparable<Long>> params = new ArrayList<Comparable<Long>>();
        Set<Long> periodIdSet = GLBalanceHelper.getPeriodIdSet(startDate, endDate);
        if (EmptyUtil.isEmpty(periodIdSet)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u4f1a\u8ba1\u671f\u95f4\u662f\u5426\u5b58\u5728", (String)"GLBalanceHelper_1", (String)"tmc-ifm-common", (Object[])new Object[0]));
        }
        StringJoiner sj = new StringJoiner(",");
        periodIdSet.forEach(v -> sj.add(v.toString()));
        params.add(orgId);
        params.add(bookTypeId);
        params.add(startDate);
        params.add(endDate);
        params.add(accountId);
        params.add(currencyId);
        params.add(orgId);
        sqlStr.append("select a.fbookeddate ,sum(case when b.fentrydc = '1' then b.foriginaldebit else -1*b.foriginalcredit end) amount ");
        if (EmptyUtil.isNoEmpty((Long)flexId)) {
            sqlStr.append("from t_gl_voucher a inner join t_gl_voucherentry b on a.fid = b.fid inner join t_gl_assist_bd c on c.fid = b.fassgrpid ");
            sqlStr.append(" where  a.forgid = ? and a.fbooktypeid = ? and a.fperiodid in (%s) and a.Fbookeddate >= ? and a.Fbookeddate <= ? and b.faccountid = ? and b.fcurrencyid = ? ");
            sqlStr.append(" and b.forgid = ? and b.fperiodid in (%s) and c.fvalue = ? ");
            params.add(flexId);
        } else {
            sqlStr.append("from t_gl_voucher a inner join t_gl_voucherentry b on a.fid = b.fid ");
            sqlStr.append(" where a.forgid = ? and a.fbooktypeid = ? and a.fperiodid in (%s) and a.Fbookeddate >= ? and a.Fbookeddate <= ? and b.faccountid = ? and b.fcurrencyid = ? ");
            sqlStr.append(" and b.forgid = ? and b.fperiodid in (%s)");
        }
        sqlStr.append(" group by a.fbookeddate");
        SqlBuilder sqlBuilder = new SqlBuilder();
        String periodStr = sj.toString();
        sqlBuilder.append(String.format(sqlStr.toString(), periodStr, periodStr), params);
        long beginTime = System.currentTimeMillis();
        DataSet result = DB.queryDataSet((String)"GLBanlanceQuery", (DBRoute)new DBRoute("fi"), (SqlBuilder)sqlBuilder);
        log.info(String.format("\u67e5\u8be2\u6bcf\u65e5\u53d1\u751f\u989d\u8017\u65f6\uff1a%sms", System.currentTimeMillis() - beginTime));
        DynamicObject accountView = TmcDataServiceHelper.loadSingleFromCache((Object)accountId, (String)"bd_accountview");
        String dc = accountView.getString("dc");
        BigDecimal bigDecimal = sign = dc.equals("1") ? Constants.ONE : Constants._ONE;
        while (result.hasNext()) {
            Row next = result.next();
            Date bookedDate = next.getDate("fbookeddate");
            BigDecimal debitAmt = next.getBigDecimal("amount").multiply(sign);
            voucherAmts.put(bookedDate, debitAmt);
        }
        return voucherAmts;
    }

    public static DynamicObject getPeriodByDate(long orgId, Date date, long periodId) {
        QFilter[] filters = new QFilter[]{new QFilter("begindate", "<=", (Object)date), new QFilter("enddate", ">=", (Object)date), new QFilter("periodtype", "=", (Object)periodId)};
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (QFilter[])filters);
    }

    public static Set<Long> getPeriodIdSet(Date beginDate, Date endDate) {
        QFilter beginDateFilter = new QFilter("begindate", "<=", (Object)endDate);
        QFilter endDateFilter = new QFilter("enddate", ">=", (Object)beginDate);
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"bd_period", (String)"id", (QFilter[])new QFilter[]{beginDateFilter.or(endDateFilter)});
        HashSet<Long> pdIdSet = new HashSet<Long>();
        for (DynamicObject pd : coll) {
            pdIdSet.add(pd.getLong("id"));
        }
        return pdIdSet;
    }

    public static DynamicObject getAccountBook(Long orgId) {
        QFilter qfilter = new QFilter("org", "=", (Object)orgId);
        qfilter.and(new QFilter("bookstype.accounttype", "=", (Object)"1"));
        DynamicObject accountBank = TmcDataServiceHelper.loadSingle((String)"gl_accountbook", (String)"periodtype,accounttable,org,bookstype", (QFilter[])qfilter.toArray());
        return accountBank;
    }

    private static void setAssTypeValue(Long accountId, String itemType, Long flexId, BalanceQueryParam param) {
        ArrayList<Map<String, Long>> asstTypeValues = new ArrayList<Map<String, Long>>();
        DynamicObject flexProp = TmcDataServiceHelper.loadSingleFromCache((String)"bos_flex_property", (QFilter[])new QFilter[]{new QFilter("valuesource", "=", (Object)itemType)});
        HashMap<String, Long> flexMap = new HashMap<String, Long>(2);
        if (EmptyUtil.isNoEmpty((Long)flexId)) {
            flexMap.put(flexProp.getString("flexfield"), flexId);
            param.addGroupBy(flexProp.getString("flexfield"));
            asstTypeValues.add(flexMap);
        }
        param.setAccountAssgrp(accountId, asstTypeValues);
    }

    private static void genBalance(Map<Date, BigDecimal> balanceMap, BigDecimal initBalance, Map<Date, BigDecimal> dailyGLBalance, Date startDate, Date beginDate, Date endDate) {
        BigDecimal amt = initBalance;
        Date tempDate = startDate;
        while (tempDate.compareTo(endDate) <= 0) {
            amt = amt.add(dailyGLBalance.getOrDefault(tempDate, BigDecimal.ZERO));
            if (tempDate.compareTo(beginDate) >= 0) {
                balanceMap.put(tempDate, amt);
            }
            tempDate = DateUtils.getNextDay((Date)tempDate, (int)1);
        }
    }
}

