/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class IfmSettleCenterHelper {
    public static Long getSettleCenterOrgIdByFinOrg(Long finorgId) {
        DynamicObject org;
        Long orgId = 0L;
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)finorgId)};
        DynamicObject settleCenter = TmcDataServiceHelper.loadSingle((String)"bd_finorginfo", (String)"org", (QFilter[])filters);
        if (settleCenter != null && (org = settleCenter.getDynamicObject("org")) != null) {
            orgId = settleCenter.getDynamicObject("org").getLong("id");
        }
        return orgId;
    }

    public static DynamicObject getSettleFinByOrg(Long orgId) {
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId)};
        DynamicObject settleCenter = TmcDataServiceHelper.loadSingle((String)"bd_finorginfo", (String)"id", (QFilter[])filters);
        return settleCenter;
    }

    public static List<Long> getAuthorizedRegisteredSettleCenterIds(Long userID, String appId, String entityID, String permissionItem) {
        Object[] settleCenters;
        ArrayList<Long> settleCenterIds = new ArrayList<Long>(10);
        List orgIds = TmcOrgDataHelper.getCacheUserPermission((Long)userID, (String)appId, (String)entityID, (String)permissionItem);
        QFilter qFilter = new QFilter("usestatus", "=", (Object)Boolean.TRUE);
        if (orgIds != null && orgIds.size() == 0) {
            return settleCenterIds;
        }
        if (EmptyUtil.isNoEmpty((Object)orgIds)) {
            qFilter.and(new QFilter("scorg", "in", (Object)orgIds));
        }
        if (!EmptyUtil.isEmpty((Object[])(settleCenters = TmcDataServiceHelper.load((String)"ifm_settcentersetting", (String)"settlecenter", (QFilter[])qFilter.toArray())))) {
            for (Object sc : settleCenters) {
                if (sc.getDynamicObject("settlecenter") == null) continue;
                settleCenterIds.add(sc.getDynamicObject("settlecenter").getLong("id"));
            }
        }
        return settleCenterIds;
    }

    public static List<DynamicObject> getSettleCenterBanks() {
        QFilter[] filters = new QFilter[]{new QFilter("finorgtype.type", "=", (Object)FinOrgTypeEnum.CLEARINGHOUSE.getValue()), new QFilter("is_leaf", "=", (Object)"1")};
        DynamicObject[] res = TmcDataServiceHelper.load((String)"bd_finorginfo", (String)"id,number,name,org", (QFilter[])filters);
        return Arrays.asList(res);
    }

    public static Date getAcceptDate(Long finOrgId) {
        DynamicObject finOrg = TmcDataServiceHelper.loadSingleFromCache((Object)finOrgId, (String)"bd_finorginfo", (String)"id,enable_time,createtime");
        QFilter[] filters = new QFilter[]{new QFilter("settlecenter", "=", (Object)finOrgId)};
        Object[] settlementCenters = TmcDataServiceHelper.load((String)"ifm_settcentersetting", (String)"id,acceptdate", (QFilter[])filters);
        Date acceptDate = null;
        if (EmptyUtil.isNoEmpty((Object[])settlementCenters)) {
            acceptDate = settlementCenters[0].getDate("acceptdate");
        }
        if (EmptyUtil.isEmpty(acceptDate)) {
            Date enableDate = finOrg.getDate("enable_time");
            enableDate = enableDate == null ? finOrg.getDate("createtime") : enableDate;
            acceptDate = DateUtils.truncateDate((Date)enableDate);
        }
        return acceptDate;
    }

    public static Map<Long, Date> getAcceptDateMap(List<Long> finOrgIds) {
        Map finOrgMap = TmcDataServiceHelper.loadFromCache((Object[])finOrgIds.toArray(), (String)"bd_finorginfo");
        QFilter[] filterSc = new QFilter[]{new QFilter("settlecenter", "in", finOrgIds)};
        Object[] settleCenters = TmcDataServiceHelper.load((String)"ifm_settcentersetting", (String)"settlecenter.id,acceptdate", (QFilter[])filterSc);
        HashMap<Long, Date> acceptDateMap = new HashMap<Long, Date>(settleCenters.length);
        if (EmptyUtil.isNoEmpty((Object[])settleCenters)) {
            for (Object d : settleCenters) {
                acceptDateMap.put(d.getDynamicObject("settlecenter").getLong("id"), d.getDate("acceptdate"));
            }
        }
        for (Long id : finOrgIds) {
            Date acceptDate = (Date)acceptDateMap.get(id);
            if (null != acceptDate) continue;
            DynamicObject finOrg = (DynamicObject)finOrgMap.get(id);
            Date enableDate = finOrg.getDate("enable_time");
            enableDate = enableDate == null ? finOrg.getDate("createtime") : enableDate;
            acceptDateMap.put(id, DateUtils.truncateDate((Date)enableDate));
        }
        return acceptDateMap;
    }

    public static DynamicObject getCurUseSettleCenter(String appId, String entityId, Long orgId, String permissionItem) {
        int hasPerm = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (Long)orgId, (String)appId, (String)entityId, (String)permissionItem);
        if (1 == hasPerm) {
            return IfmSettleCenterHelper.getSettleFinByOrg(orgId);
        }
        return null;
    }
}

