/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.ReceredtypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.ifm.enums.TradeTypeEnum;
import kd.tmc.ifm.helper.InnerAccountBalanceHelper;

public class InitInnerAcctBalanceHelper {
    private static AtomicInteger counter = new AtomicInteger(0);

    public static DynamicObject createInitTransDetail(DynamicObject acct, DynamicObject currency, BigDecimal amount, Date bizDate) {
        DynamicObject transDetail = BusinessDataServiceHelper.newDynamicObject((String)"ifm_transdetail");
        long id = DBServiceHelper.genGlobalLongId();
        transDetail.set("id", (Object)id);
        transDetail.set("uniqueseq", (Object)id);
        transDetail.set("biztype", (Object)TradeTypeEnum.PT.getDetailType());
        transDetail.set("company", acct.getDynamicObject("company").getPkValue());
        transDetail.set("accountbank", acct.getPkValue());
        transDetail.set("currency", currency.getPkValue());
        transDetail.set("bizdate", (Object)DateUtils.truncateDate((Date)bizDate));
        transDetail.set("biztime", (Object)DateUtils.truncateDate((Date)bizDate));
        transDetail.set("bank", acct.getDynamicObject("bank").getPkValue());
        transDetail.set("creditamount", (Object)amount);
        transDetail.set("debitamount", (Object)BigDecimal.ZERO);
        transDetail.set("scorg", acct.getDynamicObject("scorg").getPkValue());
        transDetail.set("datasource", (Object)"fromifm");
        transDetail.set("sourcebilltype", (Object)"bd_accountbanks");
        transDetail.set("sourcebillid", acct.getPkValue());
        transDetail.set("createtime", (Object)new Date());
        transDetail.set("modifytime", (Object)new Date());
        transDetail.set("lastmodifytime", (Object)new Date());
        transDetail.set("modifier", (Object)RequestContext.get().getCurrUserId());
        transDetail.set("description", (Object)ResManager.loadKDString((String)"\u8d26\u6237\u521d\u59cb\u5316\u4f59\u989d", (String)"InitInnerAcctBalanceHelper_0", (String)"tmc-ifm-common", (Object[])new Object[0]));
        transDetail.set("isdowntobankstate", (Object)"1");
        transDetail.set("receredtype", (Object)ReceredtypeEnum.ACCOUNTED.getValue());
        int count = counter.incrementAndGet();
        if (count == 1000) {
            counter = new AtomicInteger(0);
        }
        transDetail.set("sortno", (Object)(DateUtils.getCurrentTime().getTime() * 100000L + (long)count % 100000L));
        TmcOperateServiceHelper.execOperate((String)"save", (String)"ifm_transdetail", (DynamicObject[])new DynamicObject[]{transDetail}, (OperateOption)OperateOption.create());
        return transDetail;
    }

    public static void saveAccountBalance(Long[] innerAccountIds) {
        QFilter bdAccountQF = new QFilter("inneracct", "in", (Object)innerAccountIds);
        DynamicObjectCollection bdAccounts = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id,company.id, scorg.id, opendate, defaultcurrency.id, inneracct.id", (QFilter[])bdAccountQF.toArray());
        ArrayList<DynamicObject> bals = new ArrayList<DynamicObject>(bdAccounts.size());
        for (DynamicObject bdAcct : bdAccounts) {
            Long companyId = bdAcct.getLong("company.id");
            Long currencyId = bdAcct.getLong("defaultcurrency.id");
            Long scorgId = bdAcct.getLong("scorg.id");
            Long innerAcctId = bdAcct.getLong("id");
            Date openDate = DateUtils.truncateDate((Date)bdAcct.getDate("opendate"));
            DynamicObject balance = TmcDataServiceHelper.newDynamicObject((String)"ifm_accountbalance");
            balance.set("company", (Object)companyId);
            balance.set("scorg", (Object)scorgId);
            balance.set("accountbank", (Object)innerAcctId);
            balance.set("currency", (Object)currencyId);
            balance.set("bizdate", (Object)openDate);
            balance.set("lstbalance", (Object)BigDecimal.ZERO);
            balance.set("amount", (Object)BigDecimal.ZERO);
            balance.set("valibalance", (Object)BigDecimal.ZERO);
            String keyCol = InnerAccountBalanceHelper.genKeyCol(companyId, innerAcctId, currencyId, openDate);
            balance.set("keycol", (Object)keyCol);
            bals.add(balance);
        }
        TmcOperateServiceHelper.execOperate((String)"save", (String)"ifm_accountbalance", (DynamicObject[])bals.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
    }

    private InitInnerAcctBalanceHelper() {
    }
}

