/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.helper;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.helper.TmcDigestHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.helper.InnerAcctFrozenHelper;

public class InnerAccountBalanceHelper {
    private static final String UPDATE_VALIBALANCE_SQL = "UPDATE T_Bei_BankBalance SET FValiBalance = ?, FFreezeBalance = ? WHERE FId = ?";

    public static BigDecimal getCurrentBalance(Long acctBankId, Long currencyId) {
        QFilter[] filters = new QFilter[]{new QFilter("accountbank", "=", (Object)acctBankId), new QFilter("currency", "=", (Object)currencyId)};
        BigDecimal res = BigDecimal.ZERO;
        DynamicObjectCollection balanceCol = QueryServiceHelper.query((String)"getCurrentBalance", (String)"ifm_accountbalance", (String)"amount,bizdate,modifytime", (QFilter[])filters, (String)"bizdate desc", (int)1);
        if (!balanceCol.isEmpty()) {
            res = ((DynamicObject)balanceCol.get(0)).getBigDecimal("amount");
        }
        return res;
    }

    public static BigDecimal getBalance(Long acctBankId, Long currencyId, Date date) {
        BigDecimal res = BigDecimal.ZERO;
        Date formatedDay = DateUtils.getDataFormat((Date)DateUtils.getNextDay((Date)date, (int)1), (boolean)true);
        QFilter[] filters = new QFilter[]{new QFilter("accountbank", "=", (Object)acctBankId), new QFilter("currency", "=", (Object)currencyId), new QFilter("bizdate", "<", (Object)formatedDay)};
        DynamicObjectCollection balanceCol = QueryServiceHelper.query((String)"getBalance", (String)"ifm_accountbalance", (String)"amount,bizdate,modifytime", (QFilter[])filters, (String)"bizdate desc", (int)1);
        if (!balanceCol.isEmpty()) {
            res = ((DynamicObject)balanceCol.get(0)).getBigDecimal("amount");
        }
        return res;
    }

    public static String genKeyCol(Long companyId, Long innerAcctId, Long currencyId, Date bizDate) {
        StringBuilder builder = new StringBuilder();
        Timestamp biztimestamp = new Timestamp(bizDate.getTime());
        builder.append("accountbank:");
        builder.append(innerAcctId);
        builder.append(",");
        builder.append("bizdate:");
        builder.append(biztimestamp);
        builder.append(",");
        builder.append("company:");
        builder.append(companyId);
        builder.append(",");
        builder.append("currency:");
        builder.append(currencyId);
        builder.append(",");
        return TmcDigestHelper.getSHA256Base64Str((String)builder.toString());
    }

    public static BigDecimal getInnerAcctCurBalance(Long innerAcctId, Date bizDate) {
        Long accountBankId = InnerAccountBalanceHelper.getAccountBankIdByInnerAcctId(innerAcctId);
        if (accountBankId == null) {
            return BigDecimal.ZERO;
        }
        QFilter filter = new QFilter("accountbank.id", "=", (Object)accountBankId);
        filter.and("bizdate", "<=", (Object)bizDate);
        DynamicObjectCollection balances = QueryServiceHelper.query((String)"ifm_accountbalance", (String)"amount", (QFilter[])filter.toArray(), (String)"bizdate desc", (int)1);
        return EmptyUtil.isEmpty((DynamicObjectCollection)balances) ? BigDecimal.ZERO : ((DynamicObject)balances.get(0)).getBigDecimal("amount");
    }

    public static Long getAccountBankIdByInnerAcctId(Long innerAcctId) {
        DynamicObject innerAccount = BusinessDataServiceHelper.loadSingleFromCache((Object)innerAcctId, (String)"ifm_inneracct", (String)"number");
        if (innerAccount == null) {
            return null;
        }
        QFilter qFilter = new QFilter("bankaccountnumber", "=", (Object)innerAccount.getString("number"));
        DynamicObject accountBank = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_accountbanks", (String)"id", (QFilter[])qFilter.toArray());
        if (accountBank == null) {
            return null;
        }
        return accountBank.getLong("id");
    }

    public static Long getInnerAcctIdByAcctId(Long acctId) {
        DynamicObject account = BusinessDataServiceHelper.loadSingleFromCache((Object)acctId, (String)"bd_accountbanks", (String)"number");
        if (account == null) {
            return null;
        }
        QFilter qFilter = new QFilter("number", "=", (Object)account.getString("number"));
        DynamicObject innerAcct = BusinessDataServiceHelper.loadSingleFromCache((String)"ifm_inneracct", (String)"id", (QFilter[])qFilter.toArray());
        if (innerAcct == null) {
            return null;
        }
        return innerAcct.getLong("id");
    }

    public static void updateValidBalanceByInnerAcctId(Long innerAcctId, Date bizDate) {
        Long accountBankId = InnerAccountBalanceHelper.getAccountBankIdByInnerAcctId(innerAcctId);
        if (accountBankId == null) {
            return;
        }
        QFilter filter = new QFilter("accountbank.id", "=", (Object)accountBankId);
        filter.and("bizdate", ">=", (Object)DateUtils.truncateDate((Date)bizDate));
        DynamicObjectCollection balances = QueryServiceHelper.query((String)"ifm_accountbalance", (String)"id,bizdate,amount,lstbalance,valibalance,freezebalance", (QFilter[])filter.toArray(), (String)"bizdate");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)balances)) {
            return;
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>(16);
        BigDecimal frozenAmount = InnerAcctFrozenHelper.getTotalFrozenAmountByInnerAcctId(innerAcctId, bizDate);
        for (DynamicObject balance : balances) {
            BigDecimal amount = balance.getBigDecimal("amount");
            BigDecimal valiBalance = InnerAccountBalanceHelper.getValiBalance(amount, frozenAmount);
            params.add(new Object[]{valiBalance, frozenAmount, balance.getLong("id")});
        }
        DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)UPDATE_VALIBALANCE_SQL, params);
    }

    private static BigDecimal getValiBalance(BigDecimal amount, BigDecimal frozenAmount) {
        BigDecimal valiBalance = amount.subtract(frozenAmount);
        valiBalance = valiBalance.compareTo(BigDecimal.ZERO) <= 0 ? BigDecimal.ZERO : valiBalance;
        return valiBalance;
    }

    public static BigDecimal getValidBalanceByAcctBankId(Long acctBankId, Date bizDate, BigDecimal amount) {
        BigDecimal frozenAmount = InnerAcctFrozenHelper.getTotalFrozenAmountByAcctBankId(acctBankId, bizDate);
        return InnerAccountBalanceHelper.getValiBalance(amount, frozenAmount);
    }

    public static void batchUpdateValBalance(Long accountBankId, List<DynamicObject> balances) {
        if (EmptyUtil.isEmpty(balances)) {
            return;
        }
        balances.sort(Comparator.comparing(b -> b.getDate("bizdate")));
        DynamicObject lastBalance = balances.get(balances.size() - 1);
        TreeMap<Date, BigDecimal> frozenAmountMap = InnerAcctFrozenHelper.getFrozenAmountMapByAcctBankId(accountBankId, lastBalance.getDate("bizdate"));
        if (frozenAmountMap.isEmpty()) {
            return;
        }
        for (DynamicObject balance : balances) {
            Date bizDate = balance.getDate("bizdate");
            Map.Entry<Date, BigDecimal> entry = frozenAmountMap.floorEntry(bizDate);
            if (entry == null) continue;
            BigDecimal frozenAmount = entry.getValue();
            BigDecimal valiBalance = InnerAccountBalanceHelper.getValiBalance(balance.getBigDecimal("amount"), frozenAmount);
            balance.set("valibalance", (Object)valiBalance);
        }
    }
}

