/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.helper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.basedataref.BaseDataCheckRefrenceResult;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataRefrenceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class InnerAcctHelper {
    public static List<String> INNERACCT_IGNORE_REF_ON_DELETE = new ArrayList<String>(4);
    public static List<String> BANKACCT_IGNORE_REF_ON_DELETE = new ArrayList<String>(4);
    private static final String SQL_READOBJECTTYPEREF = "select t1.FObjectTypeId, t1.FTableName, t1.FFieldName, t3.FDBRoute, t4.ftablename as fmaintable, t1.fassttypeid, t1.FSqlLoadIdByTime  from t_meta_objecttyperef t1 inner join t_meta_entitydesign t2 on (t1.FObjectTypeId = t2.FNumber) left join t_meta_bizapp t3 on (t2.fbizappid = t3.fid) left join t_meta_mainentityinfo t4 on (t1.FObjectTypeId = t4.fid) ";

    public static String buildRefMessage(List<String> billNames) {
        if (!billNames.isEmpty()) {
            return String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5f15\u7528\u8be5\u8d26\u6237", (String)"InnerAcctHelper_0", (String)"tmc-ifm-common", (Object[])new Object[0]), String.join((CharSequence)",", billNames));
        }
        return null;
    }

    public static List<String> getRefEntityNames(String entity, Object pk, List<String> ignoreEntityIds) {
        ArrayList<String> billNames = new ArrayList<String>(10);
        try (TXHandle tx = TX.notSupported((String)"getRefEntityNames");){
            Map checkResult = BaseDataRefrenceHelper.checkRefrenced((String)entity, (Object[])new Object[]{pk}, ignoreEntityIds, null, (OperateOption)OperateOption.create());
            for (Map.Entry entry : checkResult.entrySet()) {
                BaseDataCheckRefrenceResult refrenceResult = (BaseDataCheckRefrenceResult)entry.getValue();
                if (!refrenceResult.isRefence()) continue;
                MainEntityType refMainType = EntityMetadataCache.getDataEntityType((String)refrenceResult.getRefenceKey().getRefEntityKey());
                billNames.add(refMainType.getDisplayName().toString());
            }
        }
        return billNames;
    }

    public static List<String> getRefEntityNames(String baseEntity) {
        BasedataEntityType basedataEntityType = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)baseEntity);
        List<String> refBDTypeNames = InnerAcctHelper.loadSameTableObjectTypes(basedataEntityType);
        return InnerAcctHelper.loadObjectTypeRefs(basedataEntityType, refBDTypeNames);
    }

    private static List<String> loadObjectTypeRefs(BasedataEntityType baseEntityType, List<String> refBDTypeNames) {
        ArrayList<String> strParams = new ArrayList<String>(16);
        Object[] selectParams = new SqlParameter[refBDTypeNames.size()];
        for (int i = 0; i < refBDTypeNames.size(); ++i) {
            selectParams[i] = new SqlParameter("FRefObjectTypeId" + String.valueOf(i), 12, (Object)refBDTypeNames.get(i));
            strParams.add("?");
        }
        String sql = SQL_READOBJECTTYPEREF;
        if (strParams.size() == 1) {
            sql = sql + "where t1.FRefObjectTypeId = ? ";
        } else {
            sql = sql + "where t1.FRefObjectTypeId in (%s)";
            sql = String.format(sql, StringUtils.join((Object[])strParams.toArray(), (String)","));
        }
        return (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])selectParams, (ResultSetHandler)new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws SQLException {
                ArrayList<String> refs = new ArrayList<String>(10);
                while (rs.next()) {
                    String tableName = rs.getString("FTableName");
                    String refAsstType = rs.getString("FAsstTypeId");
                    if (StringUtils.isNotBlank((CharSequence)refAsstType)) continue;
                    String objectTypeId = rs.getString("FObjectTypeId");
                    if (!StringUtils.isNotBlank((CharSequence)tableName)) continue;
                    refs.add(objectTypeId);
                }
                return refs;
            }
        });
    }

    private static List<String> loadSameTableObjectTypes(BasedataEntityType baseEntityType) {
        if (StringUtils.isBlank((CharSequence)baseEntityType.getAlias()) || baseEntityType.getPrimaryKey() == null || StringUtils.isBlank((CharSequence)baseEntityType.getPrimaryKey().getAlias())) {
            return new ArrayList<String>();
        }
        Object[] selectParams = new SqlParameter[]{new SqlParameter("FTableName", 12, (Object)String.valueOf(baseEntityType.getAlias().toLowerCase())), new SqlParameter("FPkFieldName", 12, (Object)String.valueOf(baseEntityType.getPrimaryKey().getAlias().toLowerCase()))};
        return (List)DB.query((DBRoute)DBRoute.meta, (String)"select fid from t_meta_mainentityinfo where ftablename = ? and fpkfieldname = ?", (Object[])selectParams, (ResultSetHandler)new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws SQLException {
                ArrayList<String> entityNumbers = new ArrayList<String>(16);
                while (rs.next()) {
                    entityNumbers.add(rs.getString("FId"));
                }
                return entityNumbers;
            }
        });
    }

    @Deprecated
    public static Map<Object, DynamicObject> loadRelBill(String billType, Object bankAcctId) {
        List<QFilter> qfilters = InnerAcctHelper.getQfilters(billType, bankAcctId);
        return TmcDataServiceHelper.loadFromCache((String)billType, (QFilter[])qfilters.toArray(new QFilter[0]));
    }

    public static DynamicObjectCollection loadRelBills(String billType, long bankAcctId) {
        List<QFilter> qfilters = InnerAcctHelper.getQfilters(billType, bankAcctId);
        return QueryServiceHelper.query((String)billType, (String)"billno", (QFilter[])qfilters.toArray(new QFilter[0]));
    }

    public static List<QFilter> getQfilters(String billType, Object bankAcctId) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        QFilter fb = new QFilter("billstatus", "=", (Object)BillStatusEnum.SUBMIT.getValue());
        QFilter fc = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        QFilter fe = new QFilter("billstatus", "=", (Object)BillStatusEnum.BEING.getValue());
        switch (billType) {
            case "cas_recbill": {
                filters.add(new QFilter("accountbank", "=", bankAcctId));
                filters.add(fb.or(fc));
                break;
            }
            case "cas_paybill": {
                filters.add(new QFilter("payeracctbank", "=", bankAcctId));
                filters.add(fb.or(fc).or(fe));
                break;
            }
            case "cas_agentpaybill": {
                filters.add(new QFilter("payeracctbank", "=", bankAcctId));
                filters.add(fb.or(fc).or(fe));
                break;
            }
        }
        return filters;
    }

    public static void updateBankAcct(DynamicObject innerAcct, Map<String, String> optionMap) {
        QFilter acctFlt = new QFilter("inneracct.id", "=", innerAcct.getPkValue());
        DynamicObject bankAcct = BusinessDataServiceHelper.loadSingle((String)"am_accountbank", (String)String.join((CharSequence)",", "name", "number", "bank", "bankaccountnumber", "strategy", "accttype", "acctstyle", "acctproperty", "shortnumber", "comment", "isopenbank", "acctmanageamt", "defaultcurrency", "currency", "englishname", "opendate", "acctname", "authquerpt", "acctstatus"), (QFilter[])acctFlt.toArray());
        bankAcct.set("name", innerAcct.get("name"));
        bankAcct.set("acctname", innerAcct.get("name"));
        bankAcct.set("bank", innerAcct.get("finorg"));
        bankAcct.set("bankaccountnumber", innerAcct.get("number"));
        bankAcct.set("number", innerAcct.get("number"));
        bankAcct.set("strategy", innerAcct.get("mgrstratg"));
        bankAcct.set("accttype", innerAcct.get("acctprop"));
        bankAcct.set("acctstyle", innerAcct.get("accttype"));
        bankAcct.set("acctproperty", innerAcct.get("acctuseage"));
        bankAcct.set("shortnumber", innerAcct.get("easy_code"));
        bankAcct.set("comment", innerAcct.get("comment"));
        bankAcct.set("isopenbank", innerAcct.get("onlinebank"));
        bankAcct.set("acctmanageamt", innerAcct.get("mgrfee"));
        bankAcct.set("defaultcurrency", innerAcct.get("currency_dflt"));
        bankAcct.set("englishname", innerAcct.get("englishname"));
        bankAcct.set("opendate", innerAcct.get("open_date"));
        bankAcct.set("authquerpt", innerAcct.get("authquerpt"));
        if (optionMap.containsKey("applyid")) {
            bankAcct.set("acctstatus", (Object)BankAcctStatusEnum.NORMAL.getValue());
        } else if (optionMap.containsKey("isNeedInsertHistory")) {
            bankAcct.set("acctstatus", (Object)BankAcctStatusEnum.CHANGING.getValue());
        }
        DynamicObject[] currencyArr = (DynamicObject[])innerAcct.getDynamicObjectCollection("currency").stream().map(o -> o.getDynamicObject("fbasedataid")).toArray(DynamicObject[]::new);
        DynamicObjectCollection bankAccCurrency = TmcDataServiceHelper.generateMultiPropValue((DynamicObject)bankAcct, (String)"currency", (DynamicObject[])currencyArr);
        bankAcct.set("currency", (Object)bankAccCurrency);
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bankAcct});
            }
            catch (Exception e) {
                txHandle.markRollback();
                throw e;
            }
        }
    }

    public static void updateIntObjectStatus(List<Long> pkValues, BaseEnableEnum dataStatus) {
        DynamicObject[] innerAccts = TmcDataServiceHelper.load((String)"ifm_inneracct", (String)"id,isdrawobject", (QFilter[])new QFilter[]{new QFilter("id", "in", pkValues)});
        List innerAccIds = Arrays.stream(innerAccts).filter(r -> r.getBoolean("isdrawobject")).map(r -> r.getLong("id")).collect(Collectors.toList());
        if (EmptyUtil.isNoEmpty(innerAccIds)) {
            List bdAcctIds = QueryServiceHelper.queryPrimaryKeys((String)"bd_accountbanks", (QFilter[])new QFilter[]{new QFilter("inneracct", "in", innerAccIds)}, null, (int)-1);
            if (EmptyUtil.isEmpty((Collection)bdAcctIds)) {
                return;
            }
            Object[] intObjs = TmcDataServiceHelper.load((String)"ifm_intobject", (String)"enable", (QFilter[])new QFilter[]{new QFilter("intobject", "in", (Object)bdAcctIds)});
            if (EmptyUtil.isEmpty((Object[])intObjs)) {
                return;
            }
            for (Object intObj : intObjs) {
                intObj.set("enable", (Object)dataStatus.getValue());
            }
            SaveServiceHelper.update((DynamicObject[])intObjs);
        }
    }

    public static String switchProperty(String changeField) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("acctname", "name");
        map.put("opendate", "open_date");
        map.put("bank", "finorg");
        map.put("bankaccountnumber", "number");
        map.put("defaultcurrency", "currency_dflt");
        map.put("acctstyle", "accttype");
        map.put("accttype", "acctprop");
        map.put("acctproperty", "acctuseage");
        map.put("shortnumber", "easy_code");
        map.put("strategy", "mgrstratg");
        map.put("issetbankinterface", "beiinterf");
        map.put("bebankfunc", "beifunc");
        map.put("isopenbank", "onlinebank");
        map.put("bankfunc", "onlinebankfunc");
        String targetFieldName = (String)map.get(changeField);
        return EmptyUtil.isNoEmpty((String)targetFieldName) ? targetFieldName : changeField;
    }

    static {
        BANKACCT_IGNORE_REF_ON_DELETE.add("bei_bankbalance");
        BANKACCT_IGNORE_REF_ON_DELETE.add("ifm_accountbalance");
        BANKACCT_IGNORE_REF_ON_DELETE.add("ifm_inneracctbal");
        BANKACCT_IGNORE_REF_ON_DELETE.add("cas_bankvccheck");
        INNERACCT_IGNORE_REF_ON_DELETE.add("ifm_inneracctbal");
        INNERACCT_IGNORE_REF_ON_DELETE.add("cas_bankvccheck");
        INNERACCT_IGNORE_REF_ON_DELETE.add("bd_accountbanks");
        INNERACCT_IGNORE_REF_ON_DELETE.add("am_accountbank");
        INNERACCT_IGNORE_REF_ON_DELETE.add("am_acctbank_schedule");
        INNERACCT_IGNORE_REF_ON_DELETE.add("ifm_inneraccountinit");
    }
}

