/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.IntHTRuleEnum;
import kd.tmc.fbp.common.enums.RateTypeEnum;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.model.interest.BizBillInfo;
import kd.tmc.fbp.common.model.interest.IntBillDetailInfo;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.model.interest.IntCalRequest;
import kd.tmc.fbp.common.model.interest.PlanCallResult;
import kd.tmc.fbp.common.model.interest.RateInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.factory.IntCallFactory;
import kd.tmc.fbp.service.inst.interest.IIntCallStragety;
import kd.tmc.ifm.bean.AccountBalanceInfo;
import kd.tmc.ifm.bean.IntObjectCalcRequest;
import kd.tmc.ifm.bean.IntObjectInfo;
import kd.tmc.ifm.bean.PrincipleFloatRateInfo;

public class IntObjectCalcHelper {
    private static final Log logger = LogFactory.getLog(IntObjectCalcHelper.class);
    private static final int INITIAL_CAPACITY = 16;

    public static IntBillInfo calcIntObjectInterest(IntObjectCalcRequest calcRequest) {
        IntObjectInfo intObjectInfo = calcRequest.getIntObjectInfo();
        Date startIntDate = intObjectInfo.getStartIntDate();
        if (startIntDate.after(calcRequest.getBeginDate())) {
            calcRequest.setBeginDate(startIntDate);
        }
        if (calcRequest.getEndDate().before(calcRequest.getBeginDate())) {
            logger.error("\u8ba1\u606f\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u542f\u7528\u65e5\u671f");
            IntBillInfo intBillInfo = new IntBillInfo();
            intBillInfo.setAmount(BigDecimal.ZERO);
            intBillInfo.setDetails(Collections.EMPTY_LIST);
            return intBillInfo;
        }
        List<RateInfo> allRateList = intObjectInfo.getRateList();
        Collections.sort(allRateList, Comparator.comparing(RateInfo::getEffectiveDate));
        calcRequest.setRateList(IntObjectCalcHelper.queryRateList(allRateList, intObjectInfo, calcRequest.getBeginDate()));
        logger.info("\u5185\u90e8\u8ba1\u606f\u5bf9\u8c61\u8ba1\u606f\u8bf7\u6c42\u53c2\u6570: {}", (Object)SerializationUtils.toJsonString((Object)calcRequest));
        IntBillInfo initBalanceBillInfo = IntObjectCalcHelper.calIntByInitIntBalance(intObjectInfo, calcRequest, allRateList);
        IntBillInfo intBillInfo = IntObjectCalcHelper.checkIntThreshold(calcRequest, intObjectInfo.getIntThresholdBalance());
        if (intBillInfo != null) {
            return initBalanceBillInfo != null ? initBalanceBillInfo : intBillInfo;
        }
        List<AccountBalanceInfo> balanceList = calcRequest.getBalanceList();
        AccountBalanceInfo.subtractFreeBalance(intObjectInfo.getFreeBalance(), balanceList);
        List balances = balanceList.stream().filter(b -> b.getPrinciple().compareTo(BigDecimal.ZERO) != 0).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(balances)) {
            return initBalanceBillInfo != null ? initBalanceBillInfo : IntObjectCalcHelper.buildIntBillInfo(calcRequest.getBeginDate(), calcRequest.getBeginDate(), calcRequest.getEndDate(), BigDecimal.ZERO, Collections.EMPTY_LIST);
        }
        IntBillInfo billInfo = null;
        List<PrincipleFloatRateInfo> floatRateList = intObjectInfo.getPrincipleFloatRateList();
        if (floatRateList != null && !floatRateList.isEmpty()) {
            billInfo = IntObjectCalcHelper.calcIntByPrincipleFloatRate(calcRequest, floatRateList);
        } else {
            Collections.sort(balanceList, Comparator.comparing(PlanCallResult::getBizDate));
            calcRequest.setRepaymentWay(RepaymentWayEnum.zhyeNew);
            billInfo = IntObjectCalcHelper.calcInterest(calcRequest);
        }
        if (initBalanceBillInfo != null) {
            if (billInfo == null) {
                return initBalanceBillInfo;
            }
            if (EmptyUtil.isEmpty((BigDecimal)billInfo.getAmount())) {
                billInfo.setEndDate(DateUtils.getLastDay((Date)billInfo.getBizDate(), (int)1));
            }
            billInfo.setAmount(billInfo.getAmount().add(initBalanceBillInfo.getAmount()));
            billInfo.setBeginDate(initBalanceBillInfo.getBeginDate());
            billInfo.getDetails().addAll(0, initBalanceBillInfo.getDetails());
            List sortedList = billInfo.getDetails().stream().sorted(Comparator.comparing(r -> r.getEndDate())).collect(Collectors.toList());
            if (EmptyUtil.isNoEmpty(sortedList)) {
                IntBillDetailInfo detailInfo = (IntBillDetailInfo)sortedList.get(sortedList.size() - 1);
                Date endDate = billInfo.getEndDate();
                if (EmptyUtil.isNoEmpty((Object)endDate) && endDate.compareTo(detailInfo.getEndDate()) != 0) {
                    IntBillDetailInfo addIntDetail = IntBillDetailInfo.build((int)1, (Date)DateUtils.getNextDay((Date)detailInfo.getEndDate(), (int)1), (BigDecimal)BigDecimal.ZERO);
                    addIntDetail.setAmount(BigDecimal.ZERO);
                    addIntDetail.setEndDate(endDate);
                    addIntDetail.setBasisDay(detailInfo.getBasisDay());
                    addIntDetail.setPrinciple(BigDecimal.ZERO);
                    addIntDetail.setRate(detailInfo.getRate());
                    addIntDetail.setIntType(detailInfo.getIntType());
                    addIntDetail.setDays(DateUtils.getDiffDays((Date)addIntDetail.getBeginDate(), (Date)addIntDetail.getEndDate()));
                    billInfo.getDetails().add(addIntDetail);
                }
            }
        }
        logger.info("\u8d26\u6237\u4f59\u989d\u8ba1\u7b97\u5229\u606f\u7ed3\u679c: {}", (Object)SerializationUtils.toJsonString((Object)billInfo));
        return billInfo;
    }

    private static IntBillInfo calcIntByPrincipleFloatRate(IntObjectCalcRequest calcRequest, List<PrincipleFloatRateInfo> floatRateList) {
        List<AccountBalanceInfo> balanceList = calcRequest.getBalanceList();
        balanceList = IntObjectCalcHelper.buildAccountBalanceInfoList(floatRateList, calcRequest.getRateList(), balanceList);
        calcRequest.setBalanceList(balanceList);
        calcRequest.setRepaymentWay(RepaymentWayEnum.zhyeNew);
        return IntObjectCalcHelper.calcInterest(calcRequest);
    }

    private static void removeOutRangeBalance(IntObjectCalcRequest calcRequest, List<AccountBalanceInfo> balanceList) {
        for (int i = balanceList.size() - 1; i >= 0; --i) {
            AccountBalanceInfo balanceInfo = balanceList.get(i);
            Date bizDate = balanceInfo.getBizDate();
            if (bizDate.compareTo(calcRequest.getBeginDate()) >= 0 && bizDate.compareTo(calcRequest.getEndDate()) <= 0) continue;
            balanceList.remove(i);
        }
    }

    private static void removeOutRangeRate(IntObjectCalcRequest calcRequest, List<RateInfo> rateList) {
        for (int i = rateList.size() - 1; i >= 0; --i) {
            RateInfo rateInfo = rateList.get(i);
            Date effectiveDate = rateInfo.getEffectiveDate();
            if (effectiveDate.compareTo(calcRequest.getEndDate()) <= 0) continue;
            rateList.remove(i);
        }
    }

    private static IntBillInfo calcInterest(IntObjectCalcRequest calcRequest) {
        IntCalRequest request = new IntCalRequest();
        BizBillInfo bizBill = IntObjectCalcHelper.getBizBill(calcRequest);
        request.setBizBill(bizBill);
        request.setRateList(new HashSet<RateInfo>(calcRequest.getRateList()));
        request.setRepayList(calcRequest.transPlanCallResultList());
        IIntCallStragety stragety = IntCallFactory.getInstance((RepaymentWayEnum)bizBill.getRepayWay());
        return stragety.callInt(request);
    }

    private static BizBillInfo getBizBill(IntObjectCalcRequest calcRequest) {
        IntObjectInfo intObjectInfo = calcRequest.getIntObjectInfo();
        BizBillInfo bizBill = new BizBillInfo();
        bizBill.setLoanAmount(calcRequest.getBalance());
        bizBill.setBeginDate(calcRequest.getBeginDate());
        bizBill.setEndDate(calcRequest.getEndDate());
        bizBill.setRepayWay(calcRequest.getRepaymentWay());
        bizBill.setBasis(intObjectInfo.getBasis());
        bizBill.setCurrencyId(calcRequest.getCurrencyId().longValue());
        bizBill.setCalOverInt(calcRequest.isCalOverInt());
        bizBill.setOverPoint(intObjectInfo.getOverPoints() != null ? intObjectInfo.getOverPoints() : BigDecimal.ZERO);
        if (calcRequest.isPreCallInt()) {
            bizBill.setHtRule(IntHTRuleEnum.headnotail);
        }
        return bizBill;
    }

    private static List<RateInfo> queryRateList(List<RateInfo> rateInfoSet, IntObjectInfo intObjectInfo, Date beginDate) {
        if (CollectionUtils.isEmpty(rateInfoSet) || intObjectInfo.getInterestType() == null) {
            return Collections.EMPTY_LIST;
        }
        switch (intObjectInfo.getInterestType()) {
            case ENABLEDATE: {
                return IntObjectCalcHelper.getBeforeStartIntDateRateInfo(rateInfoSet, intObjectInfo);
            }
            case THISDRAWDATE: {
                return IntObjectCalcHelper.getAfterBeginDateRateInfo(rateInfoSet, beginDate);
            }
        }
        return rateInfoSet;
    }

    private static List<RateInfo> getBeforeStartIntDateRateInfo(List<RateInfo> rateInfoSet, IntObjectInfo intObjectInfo) {
        ArrayList<RateInfo> rateInfos = new ArrayList<RateInfo>(rateInfoSet);
        Collections.sort(rateInfos, Comparator.comparing(RateInfo::getEffectiveDate));
        Date startIntDate = intObjectInfo.getStartIntDate();
        RateInfo lastRateInfo = IntObjectCalcHelper.getNearestRateInfo(rateInfos, startIntDate);
        if (lastRateInfo != null) {
            return IntObjectCalcHelper.createSigleRateInfoSet(lastRateInfo);
        }
        return Collections.EMPTY_LIST;
    }

    private static List<RateInfo> getAfterBeginDateRateInfo(List<RateInfo> rateInfoSet, Date beginDate) {
        ArrayList<RateInfo> rateInfos = new ArrayList<RateInfo>(rateInfoSet);
        Collections.sort(rateInfos, Comparator.comparing(RateInfo::getEffectiveDate));
        for (RateInfo rateInfo : rateInfos) {
            if (rateInfo.getEffectiveDate().compareTo(beginDate) < 0) continue;
            return IntObjectCalcHelper.createSigleRateInfoSet(rateInfo);
        }
        return Collections.EMPTY_LIST;
    }

    private static List<RateInfo> createSigleRateInfoSet(RateInfo rateInfo) {
        ArrayList<RateInfo> rateSet = new ArrayList<RateInfo>(1);
        rateSet.add(IntObjectCalcHelper.createRateInfo(rateInfo.getEffectiveDate(), rateInfo.getRate()));
        return rateSet;
    }

    private static RateInfo createRateInfo(Date effectiveDate, BigDecimal rate) {
        RateInfo rateInfo = new RateInfo();
        rateInfo.setEffectiveDate(effectiveDate);
        rateInfo.setRate(rate);
        rateInfo.setRateType(RateTypeEnum.YEAR);
        return rateInfo;
    }

    private static IntBillInfo calIntByInitIntBalance(IntObjectInfo intObjectInfo, IntObjectCalcRequest calcRequest, List<RateInfo> rateList) {
        int diffDays;
        Date lastIntDate;
        Date startIntDate = intObjectInfo.getStartIntDate();
        Date date = lastIntDate = calcRequest.isPreCallInt() ? intObjectInfo.getLastPreIntDate() : intObjectInfo.getLastIntDate();
        if (!IntObjectCalcHelper.isCalcInitIntBalance(intObjectInfo, calcRequest)) {
            return null;
        }
        Date endDate = startIntDate;
        Date beginDate = DateUtils.getNextDay((Date)lastIntDate, (int)1);
        BigDecimal initIntBalance = intObjectInfo.getInitIntBalance();
        RateInfo rateInfo = IntObjectCalcHelper.getNearestRateInfo(rateList, beginDate);
        if (rateInfo == null) {
            rateInfo = IntObjectCalcHelper.createRateInfo(beginDate, BigDecimal.ZERO);
        }
        diffDays = (diffDays = DateUtils.getDiffDays((Date)beginDate, (Date)endDate) - 1) == 0 ? 1 : diffDays;
        BigDecimal balance = initIntBalance.divide(BigDecimal.valueOf(diffDays), 10, 4);
        IntObjectCalcRequest request = calcRequest.clone();
        request.setBalanceList(Collections.singletonList(AccountBalanceInfo.build(false, beginDate, balance, BigDecimal.ZERO)));
        request.setRateList(Collections.singletonList(rateInfo));
        request.setBeginDate(beginDate).setEndDate(endDate).setRepaymentWay(RepaymentWayEnum.zhyeNew);
        IntBillInfo billInfo = IntObjectCalcHelper.calcInterest(request);
        endDate = DateUtils.getLastDay((Date)endDate, (int)1);
        if (billInfo != null && EmptyUtil.isNoEmpty((Object)billInfo.getDetails())) {
            IntBillDetailInfo detailInfo = (IntBillDetailInfo)billInfo.getDetails().get(0);
            detailInfo.setPrinciple(initIntBalance.abs());
        } else {
            billInfo = IntObjectCalcHelper.buildIntBillInfo(beginDate, beginDate, endDate, BigDecimal.ZERO, Collections.EMPTY_LIST);
        }
        logger.info("\u521d\u59cb\u79ef\u6570\u8ba1\u7b97\u5229\u606f\u7ed3\u679c: {}", (Object)SerializationUtils.toJsonString((Object)billInfo));
        return billInfo;
    }

    private static IntBillInfo buildIntBillInfo(Date bizDate, Date beginDate, Date endDate, BigDecimal amount, List<IntBillDetailInfo> details) {
        IntBillInfo billInfo = new IntBillInfo();
        billInfo.setBizDate(bizDate);
        billInfo.setBeginDate(beginDate);
        billInfo.setEndDate(endDate);
        billInfo.setAmount(amount);
        billInfo.setDetails(details);
        return billInfo;
    }

    private static IntBillInfo checkIntThreshold(IntObjectCalcRequest calcRequest, BigDecimal intThresholdBalance) {
        if (intThresholdBalance == null || intThresholdBalance.compareTo(BigDecimal.ZERO) <= 0) {
            return null;
        }
        List<AccountBalanceInfo> balanceList = calcRequest.getBalanceList();
        balanceList.stream().filter(b -> b.getPrinciple().abs().compareTo(intThresholdBalance) <= 0).forEach(v -> v.setPrinciple(Constants.ZERO));
        List balanceNewList = balanceList.stream().filter(b -> b.getPrinciple().abs().compareTo(Constants.ZERO) > 0).collect(Collectors.toList());
        if (balanceNewList.isEmpty()) {
            return IntObjectCalcHelper.buildIntBillInfo(calcRequest.getBeginDate(), calcRequest.getBeginDate(), calcRequest.getEndDate(), BigDecimal.ZERO, Collections.EMPTY_LIST);
        }
        calcRequest.setBalanceList(balanceList);
        return null;
    }

    private static RateInfo getNearestRateInfo(List<RateInfo> rateList, Date bizDate) {
        for (int i = rateList.size() - 1; i >= 0; --i) {
            RateInfo rateInfo = rateList.get(i);
            if (rateInfo.getEffectiveDate().compareTo(bizDate) > 0) continue;
            return rateInfo;
        }
        return null;
    }

    private static List<AccountBalanceInfo> buildAccountBalanceInfoList(List<PrincipleFloatRateInfo> floatRateList, List<RateInfo> rateList, List<AccountBalanceInfo> balanceList) {
        Collections.sort(rateList, Comparator.comparing(RateInfo::getEffectiveDate));
        Collections.sort(balanceList, Comparator.comparing(PlanCallResult::getBizDate));
        logger.info("\u672c\u91d1\u7d2f\u8fdb\u6d6e\u52a8\u5229\u7387\u5217\u8868: {}", (Object)SerializationUtils.toJsonString(floatRateList));
        ArrayList<AccountBalanceInfo> balanceRateInfoList = new ArrayList<AccountBalanceInfo>(16);
        int size = balanceList.size();
        for (int i = 0; i < size; ++i) {
            AccountBalanceInfo balance = balanceList.get(i);
            Date bizDate = balance.getBizDate();
            BigDecimal principle = balance.getPrinciple();
            if (principle.compareTo(BigDecimal.ZERO) == 0) {
                balanceRateInfoList.add(AccountBalanceInfo.build(balance.isPayInt(), balance.getBizDate(), principle, BigDecimal.ZERO));
                continue;
            }
            List<PrincipleFloatRateInfo> floatRateInfoList = PrincipleFloatRateInfo.splitFloatRateByList(floatRateList, principle);
            for (PrincipleFloatRateInfo floatRateInfo : floatRateInfoList) {
                AccountBalanceInfo balanceRateInfo = new AccountBalanceInfo();
                balanceRateInfo.setPrinciple(floatRateInfo.getBeginPrinciple());
                balanceRateInfo.setFloatRate(floatRateInfo.getFloatRate());
                balanceRateInfo.setBizDate(bizDate);
                balanceRateInfoList.add(balanceRateInfo);
            }
        }
        logger.info("\u672c\u91d1\u7d2f\u8fdb\u5339\u914d\u5229\u7387\u4fe1\u606f\u7684\u6d6e\u52a8\u5229\u7387\u5217\u8868: {}", (Object)SerializationUtils.toJsonString(balanceRateInfoList));
        return balanceRateInfoList;
    }

    public static Set<RateInfo> querySubsectionRateList(DynamicObject product) {
        return IntObjectInfo.querySubsectionRateList(product);
    }

    private static boolean isCalcInitIntBalance(IntObjectInfo intObjectInfo, IntObjectCalcRequest calcRequest) {
        Date startIntDate = intObjectInfo.getStartIntDate();
        Date lastIntDate = intObjectInfo.getLastIntDate();
        Date lastPreIntDate = intObjectInfo.getLastPreIntDate();
        boolean preCallInt = calcRequest.isPreCallInt();
        return !preCallInt && null != lastIntDate && lastIntDate.compareTo(startIntDate) < 0 || preCallInt && (null == lastPreIntDate || lastPreIntDate.compareTo(startIntDate) < 0);
    }
}

