/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.SystemStatusCtrolHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.bean.JournalInfo;
import kd.tmc.ifm.enums.SettleMentTypeEnum;
import kd.tmc.ifm.enums.TransTypeEnum;
import kd.tmc.ifm.helper.TransBillHelper;
import org.apache.commons.lang3.tuple.Pair;

public class JournalBookHelper {
    private static Log logger = LogFactory.getLog(JournalBookHelper.class);

    public static boolean isBookJournalType(String transType) {
        return TransTypeEnum.isBookJournalType(transType);
    }

    public static Map<Long, String> doBookJournal(DynamicObject bill) {
        JournalInfo journalInfo = JournalBookHelper.createJournalInfo(bill);
        if (EmptyUtil.isEmpty((Object)journalInfo)) {
            return new HashMap<Long, String>();
        }
        return JournalBookHelper.bookJournal(Collections.singletonList(journalInfo));
    }

    public static JournalInfo createJournalInfo(DynamicObject bill) {
        if (TransTypeEnum.isAgentPay(bill.getString("transtype")) && JournalBookHelper.settleIsCdm(bill.getDynamicObject("settletype"))) {
            logger.info("bill iscdmtype, id is:{}", (Object)bill.getLong("id"));
            return null;
        }
        switch (bill.getDataEntityType().getName()) {
            case "ifm_rectransbill": {
                return JournalBookHelper.createJournalInfoRecTrans(bill);
            }
            case "ifm_transhandlebill": {
                return JournalBookHelper.createJournalInfoByPayTrans(bill);
            }
            case "ifm_deduction": {
                return JournalBookHelper.createJournalInfoDeduction(bill);
            }
        }
        return null;
    }

    public static boolean settleIsCdm(DynamicObject settleType) {
        if (EmptyUtil.isEmpty((DynamicObject)settleType)) {
            return false;
        }
        String settlementType = settleType.getString("settlementtype");
        return SettleMentTypeEnum.isBusiness(settlementType) || SettleMentTypeEnum.isBank(settlementType);
    }

    private static Map<Long, DynamicObject> queryAccountBankMap(List<Long> accountIds) {
        DynamicObjectCollection colls = QueryServiceHelper.query((String)"am_accountbank", (String)"id,company.id,company.name,bank.name,bankaccountnumber", (QFilter[])new QFilter("id", "in", accountIds).toArray());
        return colls.stream().collect(Collectors.toMap(a -> a.getLong("id"), a -> a));
    }

    private static JournalInfo createJournalInfoByPayTrans(DynamicObject transbill) {
        JournalInfo journalInfo = new JournalInfo();
        journalInfo.setSource(2);
        journalInfo.setDirection(2);
        BigDecimal amount = transbill.getBigDecimal("actpayamt");
        if (transbill.getBoolean("iscrosspay") && !transbill.getBoolean("singlestream")) {
            amount = amount.add(transbill.getBigDecimal("fee"));
        }
        journalInfo.setCreditAmount(amount);
        journalInfo.setDebitAmount(BigDecimal.ZERO);
        DynamicObject currencyObj = transbill.getDynamicObject("currency");
        journalInfo.setCurrencyId(currencyObj.getLong("id"));
        journalInfo.setBizDate(transbill.getDate("bizdate"));
        journalInfo.setDescription(transbill.getString("description"));
        DynamicObject settletypeObj = transbill.getDynamicObject("settletype");
        if (settletypeObj != null) {
            journalInfo.setSettlementTypeId(settletypeObj.getLong("id"));
        }
        journalInfo.setSettlementNumber(transbill.getString("settletnumber"));
        journalInfo.setSourceBillType(transbill.getDataEntityType().getName());
        journalInfo.setSourceBillNumber(transbill.getString("billno"));
        journalInfo.setBillno(transbill.getString("billno"));
        journalInfo.setSourceBillId(transbill.getLong("id"));
        journalInfo.setBankCheckFlag(transbill.getString("beibankcheckflag"));
        journalInfo.setBatchNo(transbill.getString("beibankcheckflag"));
        long payeeacctbank = transbill.getLong("payeeacctbank");
        String transType = transbill.getString("transtype");
        if (TransTypeEnum.isInnerFundTransfer(transType)) {
            DynamicObject payBank = transbill.getDynamicObject("paccountbank");
            Map<Long, DynamicObject> accountBankMap = JournalBookHelper.queryAccountBankMap(Arrays.asList(payeeacctbank, payBank.getLong("id")));
            DynamicObject accountBank = accountBankMap.get(payeeacctbank);
            journalInfo.setOrgId(accountBank.getLong("company.id"));
            journalInfo.setAccountBankId(accountBank.getLong("id"));
            DynamicObject accountBankById = accountBankMap.get(payBank.getLong("id"));
            journalInfo.setOppUnit(accountBankById.getString("company.name"));
            journalInfo.setOppAcctNumber(accountBankById.getString("bankaccountnumber"));
            journalInfo.setOppBank(accountBankById.getString("bank.name"));
        } else {
            DynamicObject agentPayerAccount = transbill.getDynamicObject("agentpayeraccount");
            DynamicObject org = transbill.getDynamicObject("scorg");
            journalInfo.setOrgId((Long)org.getPkValue());
            journalInfo.setAccountBankId(agentPayerAccount.getLong("id"));
            JournalBookHelper.jouranlOpp(journalInfo, transbill);
        }
        JournalBookHelper.setJournalInfo(transbill, journalInfo);
        return journalInfo;
    }

    private static JournalInfo createJournalInfoRecTrans(DynamicObject transbill) {
        JournalInfo journalInfo = new JournalInfo();
        journalInfo.setSource(2);
        journalInfo.setDirection(1);
        journalInfo.setCreditAmount(BigDecimal.ZERO);
        journalInfo.setDebitAmount(transbill.getBigDecimal("actrecamt"));
        journalInfo.setCurrencyId(transbill.getDynamicObject("currency").getLong("id"));
        journalInfo.setBizDate(transbill.getDate("bizdate"));
        journalInfo.setDescription(transbill.getString("description"));
        DynamicObject settletypeObj = transbill.getDynamicObject("settletype");
        if (settletypeObj != null) {
            journalInfo.setSettlementTypeId(settletypeObj.getLong("id"));
        }
        journalInfo.setSettlementNumber(transbill.getString("settletnumber"));
        journalInfo.setSourceBillType(transbill.getDataEntityType().getName());
        journalInfo.setSourceBillNumber(transbill.getString("billno"));
        journalInfo.setBillno(transbill.getString("billno"));
        journalInfo.setSourceBillId(transbill.getLong("id"));
        journalInfo.setBankCheckFlag(transbill.getString("bankcheckflag"));
        journalInfo.setBatchNo(transbill.getString("bankcheckflag"));
        long payeracctbank = transbill.getLong("payeracctbank");
        DynamicObject payBank = transbill.getDynamicObject("paccountbank");
        Map<Long, DynamicObject> accountBankMap = JournalBookHelper.queryAccountBankMap(Arrays.asList(payeracctbank, payBank.getLong("id")));
        DynamicObject pAccountBank = accountBankMap.get(payeracctbank);
        journalInfo.setOrgId(pAccountBank.getLong("company.id"));
        journalInfo.setAccountBankId(pAccountBank.getLong("id"));
        DynamicObject accountBankById = accountBankMap.get(payBank.getLong("id"));
        journalInfo.setOppUnit(accountBankById.getString("company.name"));
        journalInfo.setOppAcctNumber(accountBankById.getString("bankaccountnumber"));
        journalInfo.setOppBank(accountBankById.getString("bank.name"));
        JournalBookHelper.setJournalInfo(transbill, journalInfo);
        return journalInfo;
    }

    private static JournalInfo createJournalInfoDeduction(DynamicObject bill) {
        JournalInfo journalInfo = new JournalInfo();
        journalInfo.setSource(2);
        journalInfo.setDirection(2);
        journalInfo.setCreditAmount(bill.getBigDecimal("receiveamount"));
        journalInfo.setDebitAmount(BigDecimal.ZERO);
        DynamicObject currency = bill.getDynamicObject("receivecurrency");
        journalInfo.setCurrencyId(currency != null ? Long.valueOf(currency.getLong("id")) : null);
        journalInfo.setBizDate(bill.getDate("bizdate"));
        journalInfo.setDescription(bill.getString("comment"));
        journalInfo.setSourceBillType(bill.getDataEntityType().getName());
        journalInfo.setSourceBillNumber(bill.getString("billno"));
        journalInfo.setBillno(bill.getString("billno"));
        journalInfo.setSourceBillId(bill.getLong("id"));
        journalInfo.setBankCheckFlag(bill.getString("beibankcheckflag"));
        journalInfo.setBatchNo(bill.getString("beibankcheckflag"));
        DynamicObject org = bill.getDynamicObject("scorg");
        journalInfo.setOrgId(org != null ? (Long)org.getPkValue() : 0L);
        journalInfo.setAccountBankId(bill.getDynamicObject("paybankaccount").getLong("id"));
        journalInfo.setAccountBank(bill.getDynamicObject("paybankaccount"));
        journalInfo.setOppUnit(bill.getString("payeename"));
        journalInfo.setOppAcctNumber(bill.getString("payeebanknum"));
        DynamicObject payeeBank = bill.getDynamicObject("payeebank");
        journalInfo.setOppBank(bill.getString("payeebankname"));
        if (payeeBank != null) {
            journalInfo.setOppBank(payeeBank.getLocaleString("name").getLocaleValue());
        }
        journalInfo.setPayDate(bill.getDate("bizdate"));
        journalInfo.setPd(bill.getDate("bizdate"));
        journalInfo.setTraceDate(bill.getDate("bizdate"));
        journalInfo.setPreparationdate(bill.getDate("createtime"));
        journalInfo.setCashierId(bill.getDynamicObject("creator").getLong("id"));
        if (org != null && currency != null) {
            BigDecimal exchangeRate;
            long orgId = org.getLong("id");
            DynamicObject baseCurrency = SystemStatusCtrolHelper.getStandardCurrency((long)orgId);
            long srcCurrencyId = currency.getLong("id");
            long destCurrencyId = 0L;
            if (EmptyUtil.isNoEmpty((DynamicObject)baseCurrency)) {
                destCurrencyId = baseCurrency.getLong("id");
            }
            if (EmptyUtil.isEmpty((BigDecimal)(exchangeRate = TransBillHelper.getExchangeRateByTable(srcCurrencyId, destCurrencyId, orgId, bill.getDate("bizdate"), 0L)))) {
                exchangeRate = BigDecimal.ONE;
            }
            journalInfo.setExchangeRate(exchangeRate);
            BigDecimal actPayAmt = bill.getBigDecimal("receiveamount");
            journalInfo.setLocalAmount(actPayAmt.multiply(exchangeRate));
        }
        return journalInfo;
    }

    public static void ifmBookJournal(List<JournalInfo> journalInfos) {
        Map<Long, String> resultMap = JournalBookHelper.bookJournal(journalInfos);
        for (Map.Entry<Long, String> result : resultMap.entrySet()) {
            logger.info("ifmbook errorid\uff1a{}, msg\uff1a{}", (Object)result.getKey(), (Object)result.getValue());
        }
        if (EmptyUtil.isNoEmpty(resultMap) && resultMap.size() > 0) {
            logger.info("ifmbook errorsize:{}", (Object)resultMap.size());
            String resultMsg = resultMap.values().stream().collect(Collectors.joining(";"));
            throw new KDBizException(ResManager.loadKDString((String)"\u767b\u8bb0\u65e5\u8bb0\u8d26\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a%s", (String)"JournalBookHelper_0", (String)"tmc-ifm-common", (Object[])new Object[]{resultMsg}));
        }
    }

    public static Map<Long, String> bookJournal(List<JournalInfo> journalInfos) {
        List result = new ArrayList(6);
        HashMap<Long, String> errorMap = new HashMap<Long, String>(16);
        if (!EmptyUtil.isEmpty(journalInfos)) {
            result = (List)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cas", (String)"tmcbookservice", (String)"book", (Object[])new Object[]{SerializationUtils.toJsonString(journalInfos)});
        }
        ListIterator iter = result.listIterator();
        while (iter.hasNext()) {
            Pair next = (Pair)iter.next();
            errorMap.put((Long)next.getKey(), (String)next.getValue());
        }
        return errorMap;
    }

    public static Map<Long, String> cancelJournal(String billEntityName, List<Long> billPks) {
        List result = new ArrayList(6);
        HashMap<Long, String> errorMap = new HashMap<Long, String>(16);
        if (billPks != null && billPks.size() > 0) {
            logger.info("tmcbookservice cancelBook billPks:{}", (Object)billPks.stream().map(String::valueOf).collect(Collectors.joining("\u3001")));
            result = (List)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cas", (String)"tmcbookservice", (String)"cancelBook", (Object[])new Object[]{billEntityName, billPks});
        }
        ListIterator iter = result.listIterator();
        while (iter.hasNext()) {
            Pair next = (Pair)iter.next();
            errorMap.put((Long)next.getKey(), (String)next.getValue());
        }
        return errorMap;
    }

    public static Map<Long, String> validateBeforeCancel(String billEntityName, List<Long> billPks) {
        HashMap<Long, String> errorMap = new HashMap<Long, String>(10);
        List result = new LinkedList();
        if (billPks != null && billPks.size() > 0) {
            result = (List)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cas", (String)"tmcbookservice", (String)"validateBeforeCancelBook", (Object[])new Object[]{billEntityName, billPks});
        }
        ListIterator iter = result.listIterator();
        while (iter.hasNext()) {
            Pair next = (Pair)iter.next();
            errorMap.put((Long)next.getKey(), (String)next.getValue());
        }
        return errorMap;
    }

    private static void setJournalInfo(DynamicObject info, JournalInfo journalInfo) {
        DynamicObject payOrg = null;
        String entityName = info.getDataEntityType().getName();
        payOrg = "ifm_transhandlebill".equals(entityName) ? info.getDynamicObject("org") : info.getDynamicObject("payeeorg");
        DynamicObject currency = info.getDynamicObject("currency");
        QFilter qFilter = new QFilter("sourcebillid", "=", info.getPkValue());
        DynamicObjectCollection transDetail = QueryServiceHelper.query((String)"ifm_transdetail", (String)"id,bizdate", (QFilter[])new QFilter[]{qFilter});
        Date bizDate = null;
        if (!transDetail.isEmpty()) {
            bizDate = ((DynamicObject)transDetail.get(0)).getDate("bizdate");
        }
        journalInfo.setBizDate(bizDate);
        journalInfo.setPd(bizDate);
        journalInfo.setTraceDate(new Date());
        journalInfo.setPreparationdate(info.getDate("createtime"));
        journalInfo.setCashierId(info.getDynamicObject("creator").getLong("id"));
        journalInfo.setBookDate(journalInfo.getBizDate());
        if (payOrg != null && currency != null) {
            BigDecimal exchangeRate;
            long orgId = payOrg.getLong("id");
            DynamicObject baseCurrency = SystemStatusCtrolHelper.getStandardCurrency((long)orgId);
            long srcCurrencyId = currency.getLong("id");
            long destCurrencyId = 0L;
            if (EmptyUtil.isNoEmpty((DynamicObject)baseCurrency)) {
                destCurrencyId = baseCurrency.getLong("id");
            }
            if (EmptyUtil.isEmpty((BigDecimal)(exchangeRate = TransBillHelper.getExchangeRateByTable(srcCurrencyId, destCurrencyId, orgId, bizDate, 0L)))) {
                exchangeRate = BigDecimal.ONE;
            }
            journalInfo.setExchangeRate(exchangeRate);
            BigDecimal actPayAmt = null;
            if ("ifm_transhandlebill".equals(entityName)) {
                BigDecimal amount = info.getBigDecimal("actpayamt");
                if (info.getBoolean("iscrosspay") && !info.getBoolean("singlestream")) {
                    amount = amount.add(info.getBigDecimal("fee"));
                }
                actPayAmt = amount;
            } else {
                actPayAmt = info.getBigDecimal("actrecamt");
            }
            journalInfo.setLocalAmount(actPayAmt.multiply(exchangeRate));
        }
    }

    private static void jouranlOpp(JournalInfo journalInfo, DynamicObject transbill) {
        String transType = transbill.getString("transtype");
        if (TransTypeEnum.isLinkagePAY(transType)) {
            DynamicObject bankAccount = transbill.getDynamicObject("bankaccount");
            if (bankAccount == null) {
                return;
            }
            bankAccount = TmcDataServiceHelper.loadSingleFromCache((Object)bankAccount.getPkValue(), (String)"bd_accountbanks", (String)"bank,company,bankaccountnumber");
            DynamicObject bank = bankAccount.getDynamicObject("bank");
            DynamicObject company = bankAccount.getDynamicObject("company");
            journalInfo.setOppUnit(company != null ? company.getString("name") : "");
            journalInfo.setOppAcctNumber(bankAccount.getString("bankaccountnumber"));
            journalInfo.setOppBank(bank != null ? bank.getString("name") : "");
            return;
        }
        journalInfo.setOppUnit(transbill.getString("payeename"));
        journalInfo.setOppAcctNumber(transbill.getString("payeebanknum"));
        DynamicObject payeeBank = transbill.getDynamicObject("payeebank");
        if (payeeBank != null) {
            journalInfo.setOppBank(payeeBank.getLocaleString("name").getLocaleValue());
        } else {
            journalInfo.setOppBank(transbill.getString("payeebankname"));
        }
    }
}

