/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.helper;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.ReceredtypeEnum;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.enums.TradeTypeEnum;
import kd.tmc.ifm.enums.TransTypeEnum;
import kd.tmc.ifm.resource.IfmBizResource;

public class TransDetailHelper {
    private static final Log logger = LogFactory.getLog(TransDetailHelper.class);
    private static AtomicInteger counter = new AtomicInteger(0);

    public static void matchPayBillByBankCheckFlag(Set<String> bankCheckFlags) {
        List<Long> detailids = TransDetailHelper.getTransDatails(bankCheckFlags);
        TransDetailHelper.matchBillByBankCheckFlag(detailids, true);
    }

    public static void matchRecBillByBankCheckFlag(Set<String> bankCheckFlags) {
        List<Long> detailids = TransDetailHelper.getTransDatails(bankCheckFlags);
        TransDetailHelper.matchBillByBankCheckFlag(detailids, false);
    }

    public static void matchBillByBankCheckFlag(List<Long> detailids, boolean isPay) {
        if (EmptyUtil.isEmpty(detailids)) {
            return;
        }
        String entityName = isPay ? "bei_intelpay" : "bei_intelrec";
        logger.info("matchbill:{}, billids:{}", (Object)entityName, (Object)detailids.stream().map(String::valueOf).collect(Collectors.joining("\u3001")));
        TmcOperateServiceHelper.execOperateWithoutThrow((String)"matchbill", (String)entityName, (Object[])detailids.toArray(), (OperateOption)OperateOption.create());
    }

    public static List<Long> getTransDetails(DynamicObject[] transDetailArr, boolean isPay) {
        return Arrays.stream(transDetailArr).filter(o -> BigDecimal.ZERO.compareTo(o.getBigDecimal(isPay ? "debitamount" : "creditamount")) != 0).map(o -> o.getLong("id")).collect(Collectors.toList());
    }

    public static boolean isNeedMatchCasBill(String transType) {
        HashSet<String> transTypes = new HashSet<String>();
        transTypes.add(TransTypeEnum.DEPOSIT.getValue());
        transTypes.add(TransTypeEnum.RELEASE.getValue());
        transTypes.add(TransTypeEnum.CURRENT_INTEREST.getValue());
        transTypes.add(TransTypeEnum.REVENUE.getValue());
        transTypes.add(TransTypeEnum.LOAN_REGAIN.getValue());
        transTypes.add(TransTypeEnum.LOAN_INTEREST.getValue());
        return transTypes.contains(transType);
    }

    private static List<Long> getTransDatails(Set<String> bankCheckFlags) {
        if (EmptyUtil.isEmpty(bankCheckFlags)) {
            return Collections.EMPTY_LIST;
        }
        List bks = bankCheckFlags.stream().filter(s -> EmptyUtil.isNoEmpty((String)s)).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(bankCheckFlags)) {
            return Collections.EMPTY_LIST;
        }
        QFilter detailQF = new QFilter("datasource", "=", (Object)"fromifm");
        detailQF.and(new QFilter("bankcheckflag", "in", bks));
        DynamicObjectCollection details = QueryServiceHelper.query((String)"ifm_transdetail", (String)"id", (QFilter[])detailQF.toArray());
        return details.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
    }

    public static DynamicObject checkPayeeDetail(DynamicObject bill) {
        Object payeeAcct = bill.get("payeeacctbank");
        if (EmptyUtil.isEmpty((Object)payeeAcct)) {
            return null;
        }
        QFilter qFilter = new QFilter("id", "=", payeeAcct);
        DynamicObject[] accountBanks = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id,bank,company,bankaccountnumber,name,inneracct, scorg", (QFilter[])new QFilter[]{qFilter});
        if (accountBanks == null || accountBanks.length == 0) {
            return null;
        }
        DynamicObject accountBank = accountBanks[0];
        if (accountBank.getDynamicObject("inneracct") != null) {
            return accountBank;
        }
        return null;
    }

    @Deprecated
    public static void setBankcheckflag(DynamicObject transBill, String genCode) {
        transBill.set("bankcheckflag", (Object)genCode);
    }

    public static DynamicObject createTransDetail(DynamicObject bill) {
        DynamicObject transDetail = BusinessDataServiceHelper.newDynamicObject((String)"ifm_transdetail");
        Timestamp currentTime = DateUtils.getCurrentTime();
        String entityType = bill.getDataEntityType().getName();
        long currUserId = RequestContext.get().getCurrUserId();
        transDetail.set("uniqueseq", (Object)bill.getLong("id"));
        transDetail.set("detailid", (Object)bill.getLong("id"));
        transDetail.set("sourcebillid", (Object)bill.getLong("id"));
        transDetail.set("sourcebilltype", (Object)entityType);
        transDetail.set("modifytime", (Object)currentTime);
        transDetail.set("createtime", (Object)currentTime);
        transDetail.set("lastmodifytime", (Object)currentTime);
        transDetail.set("creator", (Object)currUserId);
        transDetail.set("modifier", (Object)currUserId);
        transDetail.set("datasource", (Object)"fromifm");
        transDetail.set("autorecorpay", (Object)"0");
        transDetail.set("bizrefno", (Object)bill.getString("billno"));
        transDetail.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
        transDetail.set("receredtype", (Object)ReceredtypeEnum.Pending.getValue());
        transDetail.set("debitamount", (Object)BigDecimal.ZERO);
        transDetail.set("creditamount", (Object)BigDecimal.ZERO);
        int count = counter.incrementAndGet();
        if (count == 1000) {
            counter = new AtomicInteger(0);
        }
        transDetail.set("sortno", (Object)(DateUtils.getCurrentTime().getTime() * 100000L + (long)count % 100000L));
        String detailType = StringUtils.equals((CharSequence)entityType, (CharSequence)"ifm_transhandlebill") ? "pay" : "rec";
        String bizType = TradeTypeEnum.translate(String.join((CharSequence)"_", detailType, bill.getString("transtype")));
        transDetail.set("biztype", (Object)bizType);
        String isbankWithHolding = "0";
        String sourceBillType = bill.getString("sourcebilltype");
        List<String> matchBills = Arrays.asList("ifm_deduction", "ifm_interestbill", "ifm_repaymentbill");
        if (matchBills.contains(sourceBillType)) {
            isbankWithHolding = "1";
        }
        transDetail.set("isbankwithholding", (Object)isbankWithHolding);
        return transDetail;
    }

    public static List<Long> getTransBills(String srcEntity, List<Long> srcbillIds) {
        ArrayList<Long> billIds = new ArrayList<Long>();
        Map targetBillMap = BFTrackerServiceHelper.findTargetBills((String)srcEntity, (Long[])srcbillIds.toArray(new Long[0]));
        for (Map.Entry entry : targetBillMap.entrySet()) {
            if (!"ifm_transhandlebill".equals(entry.getKey()) && !"ifm_rectransbill".equals(entry.getKey())) continue;
            billIds.addAll(((HashSet)entry.getValue()).stream().collect(Collectors.toList()));
        }
        return billIds;
    }

    public static void showInnerDetails(IFormView view, String srcEntity, List<Long> srcbillIds) {
        DynamicObjectCollection transDetails;
        Set transDetailIds;
        if (EmptyUtil.isEmpty(srcbillIds)) {
            return;
        }
        if (!"ifm_transhandlebill".equals(srcEntity) && !"ifm_rectransbill".equals(srcEntity)) {
            srcbillIds = TransDetailHelper.getTransBills(srcEntity, srcbillIds);
        }
        if (EmptyUtil.isEmpty(transDetailIds = (transDetails = QueryServiceHelper.query((String)"bei_transdetail", (String)"id", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", srcbillIds), new QFilter("datasource", "=", (Object)"fromifm")})).stream().map(o -> o.getLong("id")).collect(Collectors.toSet()))) {
            view.showTipNotification(IfmBizResource.getNoDetail());
            return;
        }
        if (transDetailIds.size() == 1) {
            BillShowParameter param = new BillShowParameter();
            param.setStatus(OperationStatus.VIEW);
            param.setPkId(transDetailIds.iterator().next());
            param.setFormId("ifm_transdetail");
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            param.setCaption(IfmBizResource.getDetails());
            view.showForm((FormShowParameter)param);
        } else {
            ListShowParameter parameters = new ListShowParameter();
            parameters.setBillFormId("ifm_transdetail");
            parameters.getListFilterParameter().getQFilters().add(new QFilter("id", "in", transDetailIds));
            parameters.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameters.setCaption(IfmBizResource.getDetailList());
            view.showForm((FormShowParameter)parameters);
        }
    }
}

