/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.mservice.balance;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.helper.InnerAccountBalanceHelper;
import kd.tmc.ifm.mservice.balance.IInnerAcctBalance;

public class InnerAcctBalanceService
implements IInnerAcctBalance {
    private static final Log logger = LogFactory.getLog(InnerAcctBalanceService.class);

    private DynamicObjectCollection queryInnerAccts(QFilter qFilter) {
        QFilter acctQF = new QFilter("inneracct", ">", (Object)0);
        acctQF.and("finorgtype", "=", (Object)"1");
        if (qFilter != null) {
            acctQF.and(qFilter);
        }
        return QueryServiceHelper.query((String)"bd_accountbanks", (String)"id, company.id as companyid, currency.fbasedataid.id as currencyid, opendate", (QFilter[])acctQF.toArray());
    }

    @Override
    public void rebuildAllBalance() {
        logger.info("rebuildAllBalance...");
        DynamicObjectCollection accts = this.queryInnerAccts(null);
        for (DynamicObject acctDO : accts) {
            this.rebuilBalance(acctDO.getLong("id"), acctDO.getLong("currencyid"), null, null);
        }
        logger.info("rebuildAllBalance...end");
    }

    public void rebuilBalanceByInnerId(List<Long> innerIds, Date beginDate, Date endDate) {
        logger.info("rebuilBalanceByInnerId");
        QFilter acctQF = new QFilter("inneracct", "in", innerIds);
        acctQF.and("finorgtype", "=", (Object)"1");
        DynamicObjectCollection accts = this.queryInnerAccts(acctQF);
        for (DynamicObject acctDO : accts) {
            this.rebuilBalance(acctDO.getLong("id"), acctDO.getLong("currencyid"), beginDate, endDate);
        }
        logger.info("rebuilBalanceByInnerId...end");
    }

    @Override
    public void rebuilBalance(Long innerAcctId, Long currencyId, Date beginDate, Date endDate) {
        QFilter filter = new QFilter("accountbank.finorgtype", "=", (Object)"1");
        if (EmptyUtil.isNoEmpty((Long)innerAcctId)) {
            filter.and(new QFilter("accountbank.id", "=", (Object)innerAcctId));
        }
        if (EmptyUtil.isNoEmpty((Long)currencyId)) {
            filter.and(new QFilter("currency.id", "=", (Object)currencyId));
        }
        if (EmptyUtil.isNoEmpty((Object)beginDate)) {
            filter.and(new QFilter("bizdate", ">=", (Object)beginDate));
        }
        if (EmptyUtil.isNoEmpty((Object)endDate)) {
            filter.and(new QFilter("bizdate", "<=", (Object)endDate));
        }
        Date _beginDate = beginDate;
        Date _endDate = endDate;
        DynamicObject acct = QueryServiceHelper.queryOne((String)"bd_accountbanks", (String)"company.id, opendate", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)innerAcctId)});
        Long compId = acct.getLong("company.id");
        Date openDate = acct.getDate("opendate");
        DataSet balanceDs = QueryServiceHelper.queryDataSet((String)"transDetail", (String)"ifm_transdetail", (String)"company.id,accountbank.id,currency.id,bizdate,debitamount,creditamount", (QFilter[])filter.toArray(), null);
        DataSet ds = balanceDs.groupBy(new String[]{"company.id", "accountbank.id", "currency.id", "bizdate"}).sum("debitamount").sum("creditamount").finish();
        BigDecimal lstBal = BigDecimal.ZERO;
        DataSet bizDateDS = ds.copy().groupBy().min("bizdate", "minbizdate").max("bizdate", "maxbizdate").finish();
        Date minBizDate = beginDate;
        Date maxBizDate = beginDate;
        if (!bizDateDS.hasNext()) {
            if (_beginDate == null) {
                _beginDate = acct.getDate("opendate");
            }
            if (_endDate == null) {
                _endDate = DateUtils.getCurrentDate();
            }
            this.reBuildEmptyBalance(compId, innerAcctId, currencyId, _beginDate, _endDate);
            BigDecimal beginLstBal = this.queryBalance(innerAcctId, currencyId, _beginDate);
            this.updateEmptyTransBal(compId, innerAcctId, currencyId, beginLstBal, _beginDate, _endDate);
            this.updateEndBalance(compId, innerAcctId, currencyId, _endDate);
            return;
        }
        Row bizDateDSRow = bizDateDS.next();
        minBizDate = bizDateDSRow.getDate("minbizdate");
        maxBizDate = bizDateDSRow.getDate("maxbizdate");
        if (_beginDate == null) {
            Date date = _beginDate = openDate.after(minBizDate) ? minBizDate : openDate;
        }
        if (_endDate == null) {
            Date currDate = DateUtils.getCurrentDate();
            _endDate = maxBizDate.after(currDate) ? maxBizDate : currDate;
        }
        lstBal = this.queryBalance(innerAcctId, currencyId, _beginDate);
        this.reBuildEmptyBalance(compId, innerAcctId, currencyId, _beginDate, _endDate);
        if (minBizDate.after(_beginDate)) {
            BigDecimal beginLstBal = this.queryBalance(innerAcctId, currencyId, _beginDate);
            this.updateEmptyTransBal(compId, innerAcctId, currencyId, beginLstBal, _beginDate, minBizDate);
        }
        ds = ds.orderBy(new String[]{"bizdate"});
        ds = ds.addField(lstBal.toPlainString(), "beginbal");
        ds = ds.addBalanceField("creditamount-debitamount", "creditdebitsum").addField("beginbal+creditdebitsum", "balance").addField("balance-creditamount+debitamount", "lstbal");
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(8);
        String sSQL = "Update T_Bei_BankBalance Set FCreditAmount = ?, FDebitAmount = ?, FAmount=?, FLstBalance=?, fenddate=? Where FKeyCol = ?";
        ArrayList<Object[]> dateGapList = new ArrayList<Object[]>(16);
        Date preRowBizDate = null;
        while (ds.hasNext()) {
            Row row = ds.next();
            Long companyId = row.getLong("company.id");
            innerAcctId = row.getLong("accountbank.id");
            currencyId = row.getLong("currency.id");
            Date bizDate = row.getDate("bizdate");
            BigDecimal creditamount = row.getBigDecimal("creditamount");
            BigDecimal debitamount = row.getBigDecimal("debitamount");
            BigDecimal balance = row.getBigDecimal("balance");
            BigDecimal lstBalance = row.getBigDecimal("lstbal");
            String keyCol = InnerAccountBalanceHelper.genKeyCol((Long)companyId, (Long)innerAcctId, (Long)currencyId, (Date)bizDate);
            paramsList.add(new Object[]{creditamount, debitamount, balance, lstBalance, DateUtils.getNextDay((Date)bizDate, (int)1), keyCol});
            if (preRowBizDate != null && DateUtils.getDiffDays((Date)preRowBizDate, (Date)bizDate) > 1) {
                dateGapList.add(new Object[]{preRowBizDate, bizDate, lstBalance});
            }
            preRowBizDate = bizDate;
        }
        if (!paramsList.isEmpty()) {
            DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)sSQL, paramsList);
        }
        if (!dateGapList.isEmpty()) {
            for (Object[] dateGap : dateGapList) {
                Date fromDate = DateUtils.getNextDay((Date)((Date)dateGap[0]), (int)1);
                Date toDate = DateUtils.getNextDay((Date)((Date)dateGap[1]), (int)-1);
                BigDecimal bal = (BigDecimal)dateGap[2];
                this.updateEmptyTransBal(compId, innerAcctId, currencyId, bal, fromDate, toDate);
            }
        }
        if (preRowBizDate != null && preRowBizDate.before(_endDate)) {
            Date fromDate = DateUtils.getNextDay((Date)preRowBizDate, (int)1);
            Date toDate = _endDate;
            BigDecimal bal = this.queryBalance(innerAcctId, currencyId, fromDate);
            this.updateEmptyTransBal(compId, innerAcctId, currencyId, bal, fromDate, toDate);
        }
        this.updateEndBalance(compId, innerAcctId, currencyId, _endDate);
    }

    private void updateEndBalance(Long companyId, Long innerAcctId, Long currencyId, Date endDate) {
        String sSQL = "Update T_Bei_BankBalance Set fenddate=? Where FKeyCol = ?";
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(8);
        String keyCol = InnerAccountBalanceHelper.genKeyCol((Long)companyId, (Long)innerAcctId, (Long)currencyId, (Date)endDate);
        paramsList.add(new Object[]{DateUtils.stringToDate((String)"9999-12-31", (String)"yyyy-MM-dd"), keyCol});
        DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)sSQL, paramsList);
    }

    private void updateEmptyTransBal(Long companyId, Long innerAcctId, Long currencyId, BigDecimal beginBal, Date beginDate, Date endDate) {
        String sSQL = "Update T_Bei_BankBalance Set FCreditAmount = ?, FDebitAmount = ?, FAmount=?, FLstBalance=?, FValiBalance=?, fenddate=? Where FKeyCol = ?";
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(8);
        Date bizDate = beginDate;
        while (endDate.compareTo(bizDate) >= 0) {
            String keyCol = InnerAccountBalanceHelper.genKeyCol((Long)companyId, (Long)innerAcctId, (Long)currencyId, (Date)bizDate);
            BigDecimal validBalance = InnerAccountBalanceHelper.getValidBalanceByAcctBankId((Long)innerAcctId, (Date)bizDate, (BigDecimal)beginBal);
            bizDate = DateUtils.getNextDay((Date)bizDate, (int)1);
            paramsList.add(new Object[]{BigDecimal.ZERO, BigDecimal.ZERO, beginBal, beginBal, validBalance, bizDate, keyCol});
        }
        if (!paramsList.isEmpty()) {
            DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)sSQL, paramsList);
        }
    }

    @Override
    public void rebuildAllEmptyBalance() {
        QFilter filter = new QFilter("accountbank.finorgtype", "=", (Object)"1");
        DataSet ds = QueryServiceHelper.queryDataSet((String)"checkEmptyBalance", (String)"ifm_accountbalance", (String)"id,company.id,accountbank.id,currency.id,bizdate", (QFilter[])filter.toArray(), null);
        DataSet bizDateDs = ds.groupBy(new String[]{"company.id", "accountbank.id", "currency.id"}).min("bizdate").finish();
        while (bizDateDs.hasNext()) {
            Row row = bizDateDs.next();
            Long companyId = row.getLong("company.id");
            Long accountBankId = row.getLong("accountbank.id");
            Long currencyId = row.getLong("currency.id");
            Date bizDate = row.getDate("bizdate");
            this.reBuildEmptyBalance(companyId, accountBankId, currencyId, bizDate, DateUtils.getCurrentDate());
        }
    }

    @Override
    public void reBuildEmptyBalance(Long companyId, Long innerAcctId, Long currencyId, Date beginDate, Date endDate) {
        DynamicObjectCollection addNewBals = new DynamicObjectCollection();
        QFilter filter = new QFilter("accountbank.id", "=", (Object)innerAcctId);
        filter.and(new QFilter("currency.id", "=", (Object)currencyId));
        if (EmptyUtil.isNoEmpty((Object)beginDate)) {
            filter.and(new QFilter("bizdate", ">=", (Object)beginDate));
        }
        if (EmptyUtil.isNoEmpty((Object)endDate)) {
            filter.and(new QFilter("bizdate", "<=", (Object)endDate));
        }
        DynamicObjectCollection updateBalances = QueryServiceHelper.query((String)"ifm_accountbalance", (String)"id,lstbalance,debitamount,creditamount,amount,valibalance,bizdate", (QFilter[])filter.toArray(), (String)"bizdate");
        BigDecimal beginBalance = this.queryBalance(innerAcctId, currencyId, beginDate);
        Map<Date, List<DynamicObject>> bizDateMap = updateBalances.stream().collect(Collectors.groupingBy(v -> v.getDate("bizdate")));
        Date bizDate = beginDate;
        while (endDate.compareTo(bizDate) >= 0) {
            if (!bizDateMap.containsKey(bizDate)) {
                DynamicObject balance = this.genBalance(companyId, innerAcctId, currencyId, bizDate, beginBalance);
                addNewBals.add((Object)balance);
            } else {
                beginBalance = bizDateMap.get(bizDate).get(0).getBigDecimal("amount");
            }
            bizDate = DateUtils.getNextDay((Date)bizDate, (int)1);
        }
        InnerAccountBalanceHelper.batchUpdateValBalance((Long)innerAcctId, (List)addNewBals);
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])addNewBals.toArray((Object[])new DynamicObject[addNewBals.size()])));
    }

    @Override
    public void reBuildBackBalance(Set<Long> ids) {
        QFilter qFilter = new QFilter("id", "in", ids);
        DynamicObjectCollection updateBals = new DynamicObjectCollection();
        DynamicObjectCollection balances = QueryServiceHelper.query((String)"ifm_accountbalance", (String)"accountbank,currency,bizdate,amount", (QFilter[])qFilter.toArray());
        for (DynamicObject balance : balances) {
            Long innerAcctId = balance.getLong("accountbank");
            Long currencyId = balance.getLong("currency");
            Date bizDate = balance.getDate("bizdate");
            QFilter filter = new QFilter("accountbank.id", "=", (Object)innerAcctId);
            filter.and(new QFilter("currency.id", "=", (Object)currencyId));
            filter.and(new QFilter("bizdate", ">", (Object)bizDate));
            Object[] updateBalances = TmcDataServiceHelper.load((String)"ifm_accountbalance", (String)"id,accountbank,lstbalance,debitamount,creditamount,amount,valibalance,bizdate", (QFilter[])filter.toArray(), (String)"bizdate");
            if (!EmptyUtil.isNoEmpty((Object[])updateBalances)) continue;
            BigDecimal lstBalance = balance.getBigDecimal("amount");
            for (Object updateBal : updateBalances) {
                updateBal.set("lstbalance", (Object)lstBalance);
                BigDecimal creditAmount = updateBal.getBigDecimal("creditamount");
                BigDecimal debitAmount = updateBal.getBigDecimal("debitamount");
                BigDecimal currentAmt = lstBalance.subtract(debitAmount).add(creditAmount);
                updateBal.set("amount", (Object)currentAmt);
                updateBal.set("valibalance", (Object)currentAmt);
                updateBals.add(updateBal);
                lstBalance = currentAmt;
            }
        }
        if (updateBals.isEmpty()) {
            return;
        }
        Map<Long, List<DynamicObject>> balanceMap = updateBals.stream().collect(Collectors.groupingBy(b -> b.getLong("accountbank.id")));
        for (Map.Entry<Long, List<DynamicObject>> entry : balanceMap.entrySet()) {
            InnerAccountBalanceHelper.batchUpdateValBalance((Long)entry.getKey(), entry.getValue());
        }
        SaveServiceHelper.update((DynamicObject[])((DynamicObject[])updateBals.toArray((Object[])new DynamicObject[updateBals.size()])));
    }

    @Override
    public BigDecimal queryBalance(Long innerAcctId, Long currencyId, Date bizDate) {
        QFilter filter = new QFilter("accountbank.id", "=", (Object)innerAcctId);
        filter.and(new QFilter("currency.id", "=", (Object)currencyId));
        filter.and(new QFilter("bizdate", "<", (Object)bizDate));
        DynamicObjectCollection colls = QueryServiceHelper.query((String)"ifm_accountbalance", (String)"amount", (QFilter[])filter.toArray(), (String)"bizdate desc", (int)1);
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)colls)) {
            return ((DynamicObject)colls.get(0)).getBigDecimal("amount");
        }
        return BigDecimal.ZERO;
    }

    public DynamicObject genBalance(Long companyId, Long innerAcctId, Long currencyId, Date bizDate, BigDecimal balAmt) {
        DynamicObject balance = TmcDataServiceHelper.newDynamicObject((String)"ifm_accountbalance");
        balance.set("company", (Object)companyId);
        balance.set("accountbank", (Object)innerAcctId);
        balance.set("currency", (Object)currencyId);
        balance.set("bizdate", (Object)bizDate);
        balance.set("enddate", (Object)DateUtils.getNextDay((Date)bizDate, (int)1));
        balance.set("lstbalance", (Object)balAmt);
        balance.set("amount", (Object)balAmt);
        balance.set("valibalance", (Object)balAmt);
        String keyCol = InnerAccountBalanceHelper.genKeyCol((Long)companyId, (Long)innerAcctId, (Long)currencyId, (Date)bizDate);
        balance.set("keycol", (Object)keyCol);
        return balance;
    }

    @Override
    public void buildDailyBalance() {
        this.buildBeforeDayBalance(1);
    }

    @Override
    public void buildBeforeDayBalance(Integer beforeDays) {
        DynamicObjectCollection accts = this.queryInnerAccts(null);
        Date currDate = DateUtils.getCurrentDate();
        Date beginDate = DateUtils.getLastDay((Date)currDate, (int)beforeDays);
        for (DynamicObject acct : accts) {
            this.reBuildEmptyBalance(acct.getLong("companyid"), acct.getLong("id"), acct.getLong("currencyid"), beginDate, currDate);
        }
    }
}

