/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.mservice.checktask;

import java.util.Arrays;
import java.util.Date;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.fi.ai.FIDataCheckTask;
import kd.bos.ext.fi.util.FIDataCheckUtil;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class TransBillStatusCheckTask
implements FIDataCheckTask {
    public boolean execute() {
        if (FIDataCheckUtil.isStop()) {
            return false;
        }
        String checkMsg = this.checkTranBillStatus();
        if (EmptyUtil.isNoEmpty((String)checkMsg)) {
            FIDataCheckUtil.saveResult((String)"ifm_transbillstatus_check", (String)"ifm", (boolean)false, (String)ResManager.loadKDString((String)"\u4ed8\u6b3e\u5904\u7406\u5355\u548c\u5185\u90e8\u91d1\u878d\u4ea4\u6613\u5904\u7406\u5355\u4ed8\u6b3e\u72b6\u6001\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\uff0c\u5355\u53f7[%s]", (String)"TransBillStatusCheckTask_0", (String)"tmc-ifm-mservice", (Object[])new Object[]{checkMsg}), (String)"kd.tmc.ifm.mservice.checktask.TransBillStatusCheckTask");
            return false;
        }
        return true;
    }

    private String checkTranBillStatus() {
        Date lastDay = DateUtils.getLastDay((Date)new Date(), (int)1);
        Object[] tansBills = TmcDataServiceHelper.load((String)"ifm_transhandlebill", (String)"sourcebillid", (QFilter[])new QFilter[]{new QFilter("paidstatus", "=", (Object)BillStatusEnum.PAYED.getValue()), new QFilter("sourcebilltype", "=", (Object)"ifm_payacceptancebill"), new QFilter("createtime", "<=", (Object)DateUtils.getDataFormat((Date)lastDay, (boolean)false)), new QFilter("createtime", ">=", (Object)DateUtils.getDataFormat((Date)lastDay, (boolean)true))});
        if (EmptyUtil.isEmpty((Object[])tansBills)) {
            return "";
        }
        Set payacctBillids = Arrays.stream(tansBills).map(o -> o.getLong("sourcebillid")).collect(Collectors.toSet());
        DynamicObject[] payacctBills = TmcDataServiceHelper.load((String)"ifm_payacceptancebill", (String)"sourcebillid", (QFilter[])new QFilter[]{new QFilter("sourcebilltype", "=", (Object)"cas_paybill"), new QFilter("id", "in", payacctBillids)});
        Set payIds = Arrays.stream(payacctBills).map(o -> o.getLong("sourcebillid")).collect(Collectors.toSet());
        Object[] payBills = TmcDataServiceHelper.load((String)"cas_paybill", (String)"billno", (QFilter[])new QFilter[]{new QFilter("id", "in", payIds), new QFilter("billstatus", "!=", (Object)BillStatusEnum.PAYED.getValue())});
        if (EmptyUtil.isEmpty((Object[])payBills)) {
            return "";
        }
        return Arrays.stream(payBills).map(o -> o.getString("billno")).collect(Collectors.joining());
    }
}

