/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.mservice.consistency.callback;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.kdtx.common.invoke.CommonDtxResponse;
import kd.bos.kdtx.common.invoke.DtxBranch;
import kd.bos.kdtx.common.invoke.DtxResponse;
import kd.bos.kdtx.common.invoke.DtxResult;
import kd.bos.kdtx.sdk.api.DTXCallback;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.helper.TransDetailHelper;

public class PushCasBillDtxCallback
implements DTXCallback,
Serializable {
    private static final Log logger = LogFactory.getLog(PushCasBillDtxCallback.class);

    public void callback(DtxResult dtxResult) {
        logger.info("PushCasBillDtxCallback callback start");
        List branchList = dtxResult.getBranchList();
        if (EmptyUtil.isEmpty((Collection)branchList)) {
            logger.info("\u5206\u652f\u4e8b\u52a1\u6267\u884c\u7ed3\u679c\u4e3a\u7a7a");
            return;
        }
        DtxResponse dtxResponse = ((DtxBranch)branchList.get(0)).getDtxResponse();
        if (dtxResponse == null) {
            logger.info("\u5206\u652f\u4e8b\u52a1\u6267\u884c\u540e\u8fd4\u56de\u7684\u7ed3\u679c\u4e3a\u7a7a");
            return;
        }
        this.doAutoMatch((CommonDtxResponse)dtxResponse);
    }

    private void doAutoMatch(CommonDtxResponse response) {
        logger.info("\u5206\u5e03\u5f0f\u4e8b\u52a1\u573a\u666f\uff1a{},traceId:{}\u5f00\u59cb\u6267\u884c\u56de\u8c03\uff0c\u4e8b\u52a1\u8fd4\u56de\u7ed3\u679c\uff1a{}", new Object[]{response.getString((Object)"businessType"), response.getString((Object)"traceId"), SerializationUtils.toJsonString((Object)response)});
        String businessIdStr = response.getString((Object)"businessIdStr");
        String transBillEntity = response.getString((Object)"transBillEntity");
        if (EmptyUtil.isEmpty((String)businessIdStr) || EmptyUtil.isEmpty((String)transBillEntity)) {
            logger.info("\u53c2\u6570businessIdStr\u6216\u53c2\u6570transBillEntity\u4e3a\u7a7a\uff0c\u56de\u8c03\u6267\u884c\u4e2d\u6b62");
            return;
        }
        List businessIds = (List)SerializationUtils.fromJsonString((String)businessIdStr, List.class);
        List transBillList = QueryServiceHelper.queryPrimaryKeys((String)transBillEntity, (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", (Object)businessIds)}, null, (int)-1);
        if (EmptyUtil.isEmpty((Collection)transBillList)) {
            logger.info("\u672a\u627e\u5230\u6536\u4ed8\u6b3e\u4ea4\u6613\u5904\u7406\uff0c\u56de\u8c03\u6267\u884c\u4e2d\u6b62");
            return;
        }
        List transDetails = QueryServiceHelper.queryPrimaryKeys((String)"ifm_transdetail", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", (Object)transBillList)}, null, (int)-1);
        if (EmptyUtil.isEmpty((Collection)transDetails)) {
            logger.info("\u672a\u627e\u5230\u4ea4\u6613\u660e\u7ec6\uff0c\u56de\u8c03\u6267\u884c\u4e2d\u6b62");
            return;
        }
        List transPayDetails = transDetails.stream().map(Object::toString).map(Long::valueOf).collect(Collectors.toList());
        TransDetailHelper.matchBillByBankCheckFlag(transPayDetails, (boolean)transBillEntity.equals("ifm_transhandlebill"));
        logger.info("\u56de\u8c03\u6267\u884c\u5b8c\u6bd5");
    }
}

