/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.mservice.ebservice;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.extplugin.PluginProxy;
import kd.bos.isv.ISVService;
import kd.sdk.tmc.ext.extpoint.committobe.IGenBankBillSDKService;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.BeiParameterHelper;
import kd.tmc.fbp.common.helper.CodeRuleHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.bean.PayDetail;
import kd.tmc.fbp.service.ebservice.bean.PayInfo;

public class PayInfoFactory {
    public static List<PayInfo> createPayInfo(List<DynamicObject> payBillList) {
        if (payBillList.size() == 0) {
            return Collections.emptyList();
        }
        return PayInfoFactory.createPaymentBillInfo(payBillList);
    }

    public static List<PayInfo> createPaymentBillInfo(List<DynamicObject> paymentBillList) {
        ArrayList<PayInfo> payInfoList = new ArrayList<PayInfo>(paymentBillList.size());
        for (DynamicObject paymentBill : paymentBillList) {
            PayInfo payInfo = new PayInfo();
            payInfo.setCompanyId((Long)paymentBill.getDynamicObject("scorg").getPkValue());
            payInfo.setPayAcctId((Long)paymentBill.getDynamicObject("agentpayeraccount").getPkValue());
            payInfo.setPayBankId((Long)paymentBill.getDynamicObject("agentfinorg").getPkValue());
            payInfo.setPayCurrencyId((Long)paymentBill.getDynamicObject("currency").getPkValue());
            payInfo.setTotalPayAmt(paymentBill.getBigDecimal("actpayamt"));
            payInfo.setBillNo(paymentBill.getString("billno"));
            payInfo.setBillId((Long)paymentBill.getPkValue());
            payInfo.setBillType("ifm_transhandlebill");
            payInfo.setEncryption(false);
            ArrayList<PayDetail> payDetailList = new ArrayList<PayDetail>();
            PayDetail payDetail = new PayDetail();
            payDetail.setRecName(paymentBill.getString("recaccbankname"));
            payDetail.setRecBankAcct(paymentBill.getString("payeebanknum"));
            payDetail.setRecBankName(paymentBill.getString("payeebankname"));
            payDetail.setRecBankNum(paymentBill.getString("recbanknumber"));
            payDetail.setRecAmount(paymentBill.getBigDecimal("actpayamt"));
            payDetail.setRemark(paymentBill.getString("usage"));
            DynamicObject recCountry = paymentBill.getDynamicObject("reccountry");
            if (recCountry != null) {
                payDetail.setCountry((Long)recCountry.getPkValue());
            }
            payDetail.setProvince(paymentBill.getString("recprovince"));
            payDetail.setCity(paymentBill.getString("reccity"));
            payDetail.setEntryId(paymentBill.getString("id"));
            payDetail.setExpectDate(paymentBill.getDate("expectdate"));
            payDetailList.add(payDetail);
            payInfo.setPayDetails(payDetailList);
            payInfoList.add(payInfo);
        }
        return payInfoList;
    }

    public static List<DynamicObject> transPayBillToBankBill(List<DynamicObject> payInfoList) {
        ArrayList<DynamicObject> billList = new ArrayList<DynamicObject>(payInfoList.size());
        MainEntityType bankPayBillEntityType = EntityMetadataCache.getDataEntityType((String)"bei_bankpaybill");
        long[] idArr = DB.genLongIds((String)"bei_bankpaybill", (int)payInfoList.size());
        for (int k = 0; k < payInfoList.size(); ++k) {
            DynamicObject paymentBill = payInfoList.get(k);
            DynamicObject bankPayBill = new DynamicObject((DynamicObjectType)bankPayBillEntityType);
            bankPayBill.set("id", (Object)idArr[k]);
            bankPayBill.set("company", (Object)paymentBill.getDynamicObject("scorg"));
            bankPayBill.set("applyorg", (Object)paymentBill.getDynamicObject("scorg"));
            bankPayBill.set("accountbank", (Object)paymentBill.getDynamicObject("agentpayeraccount"));
            bankPayBill.set("bank", (Object)paymentBill.getDynamicObject("agentfinorg"));
            bankPayBill.set("currency", (Object)paymentBill.getDynamicObject("currency"));
            bankPayBill.set("amount", (Object)paymentBill.getBigDecimal("actpayamt"));
            bankPayBill.set("sourcebillid", paymentBill.getPkValue());
            bankPayBill.set("payunique", (Object)-1L);
            bankPayBill.set("srcbillno", (Object)paymentBill.getString("billno"));
            bankPayBill.set("expectdealtime", (Object)paymentBill.getDate("expectdate"));
            bankPayBill.set("usage", (Object)paymentBill.getString("usage"));
            bankPayBill.set("payeename", (Object)paymentBill.getString("recaccbankname"));
            bankPayBill.set("payeeacct", (Object)paymentBill.getString("payeebanknum"));
            bankPayBill.set("payeebank", (Object)paymentBill.getString("payeebankname"));
            bankPayBill.set("recbanknumber", (Object)paymentBill.getString("recbanknumber"));
            DynamicObject recCountry = paymentBill.getDynamicObject("reccountry");
            if (recCountry != null) {
                bankPayBill.set("reccountry", (Object)recCountry);
            }
            bankPayBill.set("recprovince", (Object)paymentBill.getString("recprovince"));
            bankPayBill.set("reccity", (Object)paymentBill.getString("reccity"));
            bankPayBill.set("srcbilltype", (Object)"ifm_transhandlebill");
            bankPayBill.set("bizdate", (Object)new Date());
            bankPayBill.set("isbitback", (Object)Boolean.FALSE);
            bankPayBill.set("bankpaystate", (Object)BeBillStatusEnum.OP.getValue());
            bankPayBill.set("bankinterface", (Object)BeBillStatusEnum.OP.getValue());
            bankPayBill.set("creator", (Object)RequestContext.get().getCurrUserId());
            bankPayBill.set("createtime", (Object)new Date());
            bankPayBill.set("isurgent", (Object)paymentBill.getBoolean("isurgent"));
            Long companyId = paymentBill.getDynamicObject("scorg").getLong("id");
            boolean isBankBillAudit = BeiParameterHelper.getAppBoolParameter((long)companyId, (String)"bei002");
            boolean isNeedCommitBe = BeiParameterHelper.isBizBillCommitBe((long)companyId);
            if (!isNeedCommitBe && isBankBillAudit) {
                bankPayBill.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
            } else {
                bankPayBill.set("billstatus", (Object)BillStatusEnum.SUBMIT.getValue());
            }
            bankPayBill.set("billno", (Object)CodeRuleHelper.generateNumber((String)"bei_bankpaybill", (DynamicObject)bankPayBill, (String)companyId.toString(), null));
            DynamicObject settleType = paymentBill.getDynamicObject("settletype");
            Boolean isLinkPay = settleType.getBoolean("is_linkage_payment");
            if (isLinkPay.booleanValue()) {
                bankPayBill.set("islinkpay", (Object)isLinkPay);
                bankPayBill.set("parentacctbank", (Object)paymentBill.getDynamicObject("agentpayeraccount"));
                bankPayBill.set("childacctbank", (Object)paymentBill.getDynamicObject("bankaccount"));
            }
            if (paymentBill.getBoolean("iscrosspay")) {
                PayInfoFactory.dealCrossPayInfo(bankPayBill, paymentBill);
            }
            billList.add(bankPayBill);
        }
        PayInfoFactory.dealExPropValue("ifm_transhandlebill", payInfoList, billList);
        return billList;
    }

    protected static void dealExPropValue(String entityName, List<DynamicObject> bills, List<DynamicObject> bankBills) {
        PluginProxy pluginProxy = PluginProxy.create(IGenBankBillSDKService.class, (String)"kd.sdk.tmc.ext.extpoint.committobe.IGenBankBillSDKService.extFillBankBill");
        List changeProps = pluginProxy.callReplace(p -> p.extFillBankBill(entityName, bills));
        if (EmptyUtil.isNoEmpty((Object)changeProps) && changeProps.size() > 0 && EmptyUtil.isNoEmpty(changeProps.get(0))) {
            String isv = ISVService.getISVInfo().getId();
            for (DynamicObject one : bankBills) {
                Map extValue = (Map)((Map)changeProps.get(0)).get(one.getLong("sourcebillid"));
                if (!EmptyUtil.isNoEmpty((Object)extValue)) continue;
                for (Map.Entry oneExtValue : extValue.entrySet()) {
                    if (!((String)oneExtValue.getKey()).startsWith(isv)) continue;
                    one.set((String)oneExtValue.getKey(), oneExtValue.getValue());
                }
            }
        }
    }

    private static void dealCrossPayInfo(DynamicObject bankPayBill, DynamicObject paymentBill) {
        String overseaPayType = paymentBill.getDynamicObject("crosstrantype").getLocaleString("name").getLocaleValue();
        bankPayBill.set("usecn", (Object)overseaPayType);
        bankPayBill.set("incomeradds", paymentBill.get("recaddress"));
        bankPayBill.set("istranspay", (Object)true);
        bankPayBill.set("payeraddress", (Object)paymentBill.getDynamicObject("org").getLocaleString("contactaddress"));
        bankPayBill.set("recemail", (Object)"recemail");
        bankPayBill.set("reccountry", (Object)"recemail");
        bankPayBill.set("recprovince", (Object)"recprovince");
        bankPayBill.set("reccity", (Object)"reccity");
        bankPayBill.set("recbankadds", (Object)"recbankaddress");
        bankPayBill.set("incomeswiftcode", (Object)"recswiftcode");
        bankPayBill.set("incomebankcode", (Object)paymentBill.getString("recroutingnum"));
        bankPayBill.set("paymentmethod", (Object)paymentBill.getString("paymethod"));
        bankPayBill.set("servicelevel", (Object)paymentBill.getString("serlevel"));
        bankPayBill.set("chequetype", (Object)paymentBill.getString("checktype"));
        bankPayBill.set("deliverymethod", (Object)paymentBill.getString("sendway"));
        bankPayBill.set("chequeusage", (Object)paymentBill.getString("checkuse"));
        bankPayBill.set("settlementmethod", (Object)paymentBill.getString("settlementmethod"));
        bankPayBill.set("mobile", (Object)paymentBill.getString("mobile"));
        bankPayBill.set("paymentfps", (Object)paymentBill.getString("paymentfps"));
        bankPayBill.set("paymentareacode", (Object)paymentBill.getString("paymentareacode"));
        bankPayBill.set("inforpayment", (Object)paymentBill.getString("inforpayment"));
        bankPayBill.set("informrecemail", (Object)paymentBill.getString("informrecemail"));
        bankPayBill.set("proxybankname", (Object)paymentBill.getString("proxybebankname"));
        bankPayBill.set("proxyswiftcode", (Object)paymentBill.getString("proxybebanksc"));
        bankPayBill.set("proxybankadds", (Object)paymentBill.getString("proxybebankad"));
        DynamicObject proxyCountry = paymentBill.getDynamicObject("proxybebankcountry");
        if (null != proxyCountry) {
            String proxyCountryName = proxyCountry.getString("simplespell");
            bankPayBill.set("proxybankcountry", (Object)proxyCountryName);
            bankPayBill.set("proxybankarea", (Object)proxyCountryName);
        }
        bankPayBill.set("proxyaccno", (Object)paymentBill.getString("proxybebankactno"));
        bankPayBill.set("proxyaccname", (Object)paymentBill.getString("proxybebankactname"));
        DynamicObject transType = paymentBill.getDynamicObject("transtypes");
        if (transType != null) {
            bankPayBill.set("transremarks", (Object)transType.getString("number"));
        }
        bankPayBill.set("payerfeetype", (Object)paymentBill.getString("feepayer"));
        bankPayBill.set("payerfeecurrency", (Object)paymentBill.getDynamicObject("feecurrency"));
        DynamicObject feeAcct = paymentBill.getDynamicObject("feeactbank");
        if (feeAcct != null) {
            bankPayBill.set("payerfeeaccno", (Object)feeAcct.getString("number"));
        }
    }
}

