/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.mservice.ebservice.api;

import com.alibaba.fastjson.JSON;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.invoke.DtxResponse;
import kd.bos.kdtx.sdk.api.EventualConsistencyService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.tmc.fbp.common.errorcode.TmcErrorCode;
import kd.tmc.fbp.common.helper.MutexServiceHelper;
import kd.tmc.fbp.service.ebservice.bean.SyncStatusInfo;
import kd.tmc.fbp.service.ebservice.bean.SyncStatusResult;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;
import kd.tmc.ifm.mservice.ebservice.api.IEBServiceFacade;
import kd.tmc.ifm.mservice.ebservice.sync.TransBillSyncStatusService;

public class EBServiceFacadeImpl
extends EventualConsistencyService
implements IEBServiceFacade {
    private static final String OP_SYNVPAYBILLSTATUS = "syncPayBillStatus";
    private static final Log logger = LogFactory.getLog(EBServiceFacadeImpl.class);

    public static EBServiceFacadeImpl getInstance() {
        return new EBServiceFacadeImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SyncStatusResult syncPayBillStatus(String entityName, SyncStatusInfo info) {
        String id = String.valueOf(info.getPayBillId());
        boolean lock = MutexServiceHelper.request((String)id, (String)entityName, (String)OP_SYNVPAYBILLSTATUS);
        if (!lock) {
            DynamicObject paybill = BusinessDataServiceHelper.loadSingle((Object)info.getPayBillId(), (String)entityName, (String)"billno");
            SyncStatusResult result = new SyncStatusResult();
            result.setErrMsg(new TmcErrorCode().BILL_MUTEX_LOCK_WITH_NUMBER(paybill.getString("billno")).getMessage());
            result.setStatusCode(EBResultStatusCode.ERROR);
            logger.info("\u4ed8\u6b3e\u4ea4\u6613\u5904\u7406\u5355\u540c\u6b65\u5931\u8d25\uff0c\u7533\u8bf7\u4e92\u65a5\u9501\u5931\u8d25\uff0cpaybillId\uff1a{}", (Object)id);
            return result;
        }
        try {
            TransBillSyncStatusService service = new TransBillSyncStatusService();
            SyncStatusResult result = service.syncStatus(info);
            return result;
        }
        catch (Exception e) {
            SyncStatusResult result = new SyncStatusResult();
            result.setErrMsg(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            result.setStatusCode(EBResultStatusCode.ERROR);
            logger.error("\u4ed8\u6b3e\u4ea4\u6613\u5904\u7406\u5355\u540c\u6b65\u5931\u8d25\uff0cpaybillId\uff1a{}, error:", (Object)id, (Object)e);
            SyncStatusResult syncStatusResult = result;
            return syncStatusResult;
        }
        finally {
            MutexServiceHelper.release((String)id, (String)entityName, (String)OP_SYNVPAYBILLSTATUS);
        }
    }

    public String syncBankBillStatus(String entityName, String jsonParam) {
        SyncStatusInfo payInfos = (SyncStatusInfo)JSON.parseObject((String)jsonParam, SyncStatusInfo.class);
        EBServiceFacadeImpl facade = EBServiceFacadeImpl.getInstance();
        SyncStatusResult resultList = facade.syncPayBillStatus(entityName, payInfos);
        return JSON.toJSONString((Object)resultList);
    }

    public DtxResponse execute(Object param, Object lastReturn) {
        SyncStatusInfo payInfos;
        SyncStatusResult result;
        String userId;
        CommonParam commonParam = (CommonParam)param;
        String entityName = (String)commonParam.get((Object)"entityName");
        String syncInfoStr = (String)commonParam.get((Object)"syncInfo");
        RequestContext rc = RequestContext.get();
        if ((rc.getUserId() == null || rc.getUserId().isEmpty()) && (userId = (String)commonParam.get((Object)"userId")) != null && !userId.isEmpty()) {
            rc.setUserId(userId);
        }
        if ((result = this.syncPayBillStatus(entityName, payInfos = (SyncStatusInfo)JSON.parseObject((String)syncInfoStr, SyncStatusInfo.class))).getStatusCode() != EBResultStatusCode.SUCCESS) {
            throw new KDBizException(result.getErrMsg());
        }
        return null;
    }
}

