/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.mservice.ebservice.sync;

import com.alibaba.fastjson.JSON;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.api.DTXCallback;
import kd.bos.kdtx.sdk.session.DTX;
import kd.bos.kdtx.sdk.session.DTXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.bean.SyncStatusDetail;
import kd.tmc.fbp.service.ebservice.bean.SyncStatusInfo;
import kd.tmc.fbp.service.ebservice.bean.SyncStatusResult;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;
import kd.tmc.ifm.bean.JournalInfo;
import kd.tmc.ifm.helper.TransBillHelper;
import kd.tmc.ifm.mservice.ebservice.sync.DetailMatchDtxCallback;

public class BankBillSyncStatusHelper {
    private static final Log logger = LogFactory.getLog(BankBillSyncStatusHelper.class);

    public static void syncPaymentBill(SyncStatusInfo syncStatusInfo, JournalInfo journalInfo, List<Long> details, boolean isPay) {
        logger.info("syspaymentbill dtx start, paybankid:{}", (Object)syncStatusInfo.getBankBillId());
        try (DTXHandle dtx = DTX.requiresNew((String)"sync_caspaybill", (DBRoute)DBRouteConst.TMC, (boolean)true);){
            try {
                CommonParam param = new CommonParam();
                HashSet<String> bizBillIds = new HashSet<String>();
                if (syncStatusInfo != null) {
                    bizBillIds.add(String.valueOf(syncStatusInfo.getBankBillId()));
                    logger.info("syspaymentbill dtx payid:{}", (Object)syncStatusInfo.getPayBillId());
                    param.put((Object)"syncInfo", (Object)SerializationUtils.toJsonString((Object)syncStatusInfo));
                }
                if (details != null) {
                    param.put((Object)"detailIds", (Object)details.stream().map(String::valueOf).collect(Collectors.joining(",")));
                }
                if (journalInfo != null) {
                    bizBillIds.add(String.valueOf(journalInfo.getSourceBillId()));
                    param.put((Object)"journalInfo", (Object)SerializationUtils.toJsonString((Object)journalInfo));
                }
                param.put((Object)"ispay", (Object)String.valueOf(isPay));
                dtx.setBusinessType("sync_caspaybill");
                List billIdList = bizBillIds.stream().collect(Collectors.toList());
                dtx.setBusinessInfo(billIdList);
                dtx.register("tmc", TmcAppEnum.IFM.getValue(), "transBillWriteBackCasService", (Param)param, null, billIdList);
                dtx.setCallback(TmcAppEnum.IFM.getValue(), (DTXCallback)new DetailMatchDtxCallback());
            }
            catch (Exception e) {
                dtx.markRollback();
                logger.error("syspaymentbill dtx error");
                throw e;
            }
        }
        logger.info("syspaymentbill dtx end");
    }

    public static SyncStatusInfo getSyncStatusInfo(Long transBillid, Long payBillId, String bankCheckFlag) {
        SyncStatusInfo syncStatusInfo = TransBillHelper.getBaseSyncStatusInfo((Long)transBillid, (Long)payBillId, (String)BeBillStatusEnum.TS.getValue(), (String)bankCheckFlag);
        List detailList = syncStatusInfo.getDetailList();
        for (SyncStatusDetail detail : detailList) {
            detail.setEbStatusMsg(ResManager.loadKDString((String)"\u5185\u90e8\u91d1\u878d\u4ed8\u6b3e\u6210\u529f", (String)"BankBillSyncStatusHelper_0", (String)"tmc-ifm-mservice", (Object[])new Object[0]));
        }
        return syncStatusInfo;
    }

    public static void syncBankBill(SyncStatusInfo syncStatusInfo) {
        SyncStatusResult rpcResult;
        String resultStr = BankBillSyncStatusHelper.invokeCasService(syncStatusInfo);
        if (EmptyUtil.isNoEmpty((String)resultStr) && (rpcResult = (SyncStatusResult)JSON.parseObject((String)resultStr, SyncStatusResult.class)).getStatusCode() == EBResultStatusCode.ROLLBACK) {
            logger.info("casEbService result traceid:{}", (Object)RequestContext.get().getTraceId());
            logger.info("cas paybillid:{}", (Object)syncStatusInfo.getPayBillId());
            throw new KDBizException(rpcResult.getErrMsg());
        }
    }

    public static String invokeCasService(SyncStatusInfo syncStatusInfo) {
        syncStatusInfo.setSourceType("ifm_transhandlebill");
        String info = SerializationUtils.toJsonString((Object)syncStatusInfo);
        logger.info("\u540c\u6b65\u51fa\u7eb3\u4ed8\u6b3e\u5355\u53c2\u6570\u5bf9\u8c61syncStatusInfo\uff1a{}", (Object)info);
        String resultStr = (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cas", (String)"casEbService", (String)"syncBankBillStatus", (Object[])new Object[]{"cas_paybill", info});
        logger.info("\u540c\u6b65\u51fa\u7eb3\u4ed8\u6b3e\u5355\u8fd4\u56de\u7ed3\u679ccasEbService:{}", (Object)resultStr);
        return resultStr;
    }

    public static long getCasPayBillId(DynamicObject transBill) {
        if (!"ifm_payacceptancebill".equals(transBill.getString("sourcebilltype"))) {
            return 0L;
        }
        DynamicObject payAcceptBill = BusinessDataServiceHelper.loadSingle((Object)transBill.get("sourcebillid"), (String)"ifm_payacceptancebill", (String)"sourcebillid,sourcebilltype");
        if (EmptyUtil.isEmpty((DynamicObject)payAcceptBill) || !"cas_paybill".equals(payAcceptBill.getString("sourcebilltype"))) {
            return 0L;
        }
        return payAcceptBill.getLong("sourcebillid");
    }

    public static void revertCasPayBill(DynamicObject transBill) {
        if (!"ifm_payacceptancebill".equals(transBill.getString("sourcebilltype"))) {
            return;
        }
        Long acceptBillId = transBill.getLong("sourcebillid");
        DynamicObject acceptBill = QueryServiceHelper.queryOne((String)"ifm_payacceptancebill", (String)"sourcebillid, sourcebilltype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)acceptBillId)});
        if (acceptBill != null && acceptBill.getLong("sourcebillid") > 0L) {
            SyncStatusResult rpcResult;
            Long payBillId = acceptBill.getLong("sourcebillid");
            SyncStatusInfo syncStatusInfo = TransBillHelper.getBaseSyncStatusInfo((Long)transBill.getLong("id"), (Long)payBillId, (String)BeBillStatusEnum.TF.getValue(), (String)"");
            logger.info("writeback cas info:{}", (Object)SerializationUtils.toJsonString((Object)syncStatusInfo));
            String resultStr = "";
            try (TXHandle tx = TX.requiresNew();){
                try {
                    resultStr = BankBillSyncStatusHelper.invokeCasService(syncStatusInfo);
                    logger.info("writeback cas result:{}", (Object)resultStr);
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                    tx.markRollback();
                }
            }
            if (EmptyUtil.isNoEmpty((String)resultStr) && ((rpcResult = (SyncStatusResult)JSON.parseObject((String)resultStr, SyncStatusResult.class)).getStatusCode() == EBResultStatusCode.ROLLBACK || rpcResult.getStatusCode() == EBResultStatusCode.ERROR)) {
                throw new KDBizException(rpcResult.getErrMsg());
            }
        }
    }
}

