/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.mservice.ebservice.sync;

import com.alibaba.fastjson.JSON;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.invoke.CommonDtxResponse;
import kd.bos.kdtx.common.invoke.DtxResponse;
import kd.bos.kdtx.sdk.api.EventualConsistencyService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.bean.SyncStatusDetail;
import kd.tmc.fbp.service.ebservice.bean.SyncStatusInfo;
import kd.tmc.ifm.bean.JournalInfo;
import kd.tmc.ifm.enums.TransBillPaidStatusEnum;
import kd.tmc.ifm.helper.JournalBookHelper;
import kd.tmc.ifm.mservice.ebservice.sync.BankBillSyncStatusHelper;

public class TransBillWriteBackCasService
extends EventualConsistencyService
implements Serializable {
    private static final long serialVersionUID = -8995502581900686688L;
    private static Log logger = LogFactory.getLog(TransBillWriteBackCasService.class);

    public DtxResponse execute(Object o, Object o1) throws Exception {
        CommonParam commonParam = (CommonParam)o;
        String syncInfoStr = (String)commonParam.get((Object)"syncInfo");
        String journalInfo = (String)commonParam.get((Object)"journalInfo");
        if (EmptyUtil.isNoEmpty((String)syncInfoStr)) {
            SyncStatusInfo payInfo = (SyncStatusInfo)JSON.parseObject((String)syncInfoStr, SyncStatusInfo.class);
            boolean isCheck = this.checkRepeat(payInfo);
            if (!isCheck) {
                logger.info("checkRepeat false, paybillid:{}", (Object)payInfo.getPayBillId());
            } else {
                logger.info("cas paybill update start, journalInfo:{}", (Object)journalInfo);
                BankBillSyncStatusHelper.syncBankBill(payInfo);
            }
        }
        if (EmptyUtil.isNoEmpty((String)journalInfo)) {
            logger.info("cas journal start");
            JournalBookHelper.ifmBookJournal(Collections.singletonList(SerializationUtils.fromJsonString((String)journalInfo, JournalInfo.class)));
        }
        CommonDtxResponse response = new CommonDtxResponse();
        Object details = commonParam.get((Object)"detailIds");
        if (EmptyUtil.isNoEmpty((Object)details)) {
            response.put((Object)"detailIds", details);
        }
        return response;
    }

    private boolean checkRepeat(SyncStatusInfo payInfo) {
        List detailList = payInfo.getDetailList();
        if (detailList != null && detailList.size() > 0) {
            SyncStatusDetail detail = (SyncStatusDetail)detailList.get(0);
            Long transBillId = detail.getPayBillEntryId();
            String bankPayStatus = payInfo.getBankPayStatus();
            String batchSeqId = payInfo.getBatchSeqId();
            if (EmptyUtil.isEmpty((String)batchSeqId)) {
                return true;
            }
            DynamicObject payBill = QueryServiceHelper.queryOne((String)"ifm_transhandlebill", (String)"iscommitbe,bankpaystatus,paidstatus", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)transBillId)});
            if (EmptyUtil.isEmpty((DynamicObject)payBill)) {
                return true;
            }
            boolean iscommitbe = payBill.getBoolean("iscommitbe");
            String bankpayBillstatus = payBill.getString("bankpaystatus");
            String paidStatus = payBill.getString("paidstatus");
            if (iscommitbe && !BeBillStatusEnum.TF.getValue().equals(bankPayStatus) && !StringUtils.equals((CharSequence)bankPayStatus, (CharSequence)bankpayBillstatus)) {
                logger.info("status check false, bankPayStatus:{}, bankpayBillstatus:{}", (Object)bankPayStatus, (Object)bankpayBillstatus);
                return false;
            }
            if (!iscommitbe) {
                if (BeBillStatusEnum.TS.getValue().equals(bankPayStatus) && !TransBillPaidStatusEnum.PAID.getValue().equals(paidStatus)) {
                    logger.info("status check false,TS paidStatus:{}", (Object)paidStatus);
                    return false;
                }
                if (BeBillStatusEnum.TF.getValue().equals(bankPayStatus) && TransBillPaidStatusEnum.PAID.getValue().equals(paidStatus)) {
                    logger.info("status check false,TF paidStatus:{}", (Object)paidStatus);
                    return false;
                }
            }
        }
        return true;
    }
}

