/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.mservice.recwriteback;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.recwriteback.AbstractRecBillWriteBackService;
import kd.tmc.fbp.service.recwriteback.RecBillWriteBackParam;
import kd.tmc.ifm.helper.PushRecBillVerifyHelper;

public class BankIntRecBillWriteBackService
extends AbstractRecBillWriteBackService {
    private static final String SELECT_PROP = "id,billno,billstatus,currency.id,actualinstamt,recbillno";

    protected void doSaveExecute(RecBillWriteBackParam param, DynamicObject sourceBill) {
        super.doSaveExecute(param, sourceBill);
        sourceBill.set("recbillno", (Object)param.getRecBill().getRecBillNo());
        this.DBTxBizUpdate(sourceBill);
    }

    protected void doSubmitExecute(RecBillWriteBackParam param, DynamicObject sourceBill) {
        super.doSubmitExecute(param, sourceBill);
        this.doSaveExecute(param, sourceBill);
    }

    protected void doDeleteExecute(RecBillWriteBackParam param, DynamicObject sourceBill) {
        super.doDeleteExecute(param, sourceBill);
        sourceBill.set("recbillno", null);
        this.DBTxBizUpdate(sourceBill);
    }

    protected void doSaveValidateExecute(RecBillWriteBackParam param, DynamicObject sourceBill) {
        super.doSaveValidateExecute(param, sourceBill);
        this.validateBizCore(sourceBill);
    }

    protected void doSubmitValidateExecute(RecBillWriteBackParam param, DynamicObject sourceBill) {
        super.doSubmitValidateExecute(param, sourceBill);
        this.validateBizCore(sourceBill);
    }

    protected DynamicObject getSourceBill(RecBillWriteBackParam param) {
        return TmcDataServiceHelper.loadSingle((Object)param.getRecBill().getSourceBillId(), (String)"ifm_currentintbill_bank", (String)SELECT_PROP);
    }

    protected Long getSourceBillCurrencyId(RecBillWriteBackParam param, DynamicObject sourceBill) {
        return sourceBill.getLong("currency.id");
    }

    protected BigDecimal getSourceBillRecAmount(RecBillWriteBackParam param, DynamicObject sourceBill) {
        return sourceBill.getBigDecimal("actualinstamt");
    }

    private void validateBizCore(DynamicObject sourceBill) {
        String msg = PushRecBillVerifyHelper.verifyCurrentBankIntBill((DynamicObject)sourceBill);
        if (EmptyUtil.isNoEmpty((String)msg)) {
            throw new KDBizException(msg);
        }
    }
}

