/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.mservice.transdetail;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.enums.ReceredtypeEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.GenBankcheckCode;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.enums.SettleMentTypeEnum;
import kd.tmc.ifm.enums.TransTypeEnum;
import kd.tmc.ifm.helper.IfmSettleCenterHelper;
import kd.tmc.ifm.helper.TransBillHelper;
import kd.tmc.ifm.helper.TransDetailHelper;
import kd.tmc.ifm.mservice.transdetail.AbstractTransDetailBuilder;

public class PayTransDetailBuilder
extends AbstractTransDetailBuilder {
    private Date currentDate = new Date();

    public PayTransDetailBuilder(DynamicObject bill) {
        super(bill);
    }

    @Override
    public List<DynamicObject> build() {
        ArrayList<DynamicObject> transDetails = new ArrayList<DynamicObject>(2);
        DynamicObject bizBill = this.getBizBill();
        DynamicObject settleType = bizBill.getDynamicObject("settletype");
        if (EmptyUtil.isNoEmpty((DynamicObject)settleType) && SettleMentTypeEnum.isBankOrBusiness((String)settleType.getString("settlementtype"))) {
            return transDetails;
        }
        transDetails.add(this.createPayerTransDetail(bizBill));
        DynamicObject oppTransDetail = this.createOppTransDetail(bizBill);
        if (oppTransDetail != null) {
            if (StringUtils.equals((CharSequence)TransTypeEnum.RELEASE.getValue(), (CharSequence)bizBill.getString("transtype"))) {
                oppTransDetail.set("bankcheckflag", (Object)bizBill.getString("bankcheckflag"));
                DynamicObject payTransDetail = (DynamicObject)transDetails.get(0);
                payTransDetail.set("receredtype", (Object)ReceredtypeEnum.ACCOUNTED.getValue());
            }
            transDetails.add(oppTransDetail);
        }
        return transDetails;
    }

    private void handleAutoRecord(DynamicObject bill, DynamicObject transdetail) {
        String transType = bill.getString("transtype");
        if (TransTypeEnum.isLinkagePAY((Object)transType)) {
            DynamicObject bankAccount = bill.getDynamicObject("bankaccount");
            bankAccount = TmcDataServiceHelper.loadSingleFromCache((Object)bankAccount.getPkValue(), (String)"bd_accountbanks", (String)"company");
            DynamicObject company = bankAccount.getDynamicObject("company");
            if (bankAccount != null && company != null) {
                boolean isBookIfm = TransBillHelper.isBookIfm((long)company.getLong("id"));
                if (isBookIfm) {
                    return;
                }
                transdetail.set("receredtype", (Object)ReceredtypeEnum.ACCOUNTED.getValue());
                boolean isBookInner = TransBillHelper.isBookInner((long)company.getLong("id"));
                if (!isBookInner) {
                    transdetail.set("isdowntobankstate", (Object)"1");
                }
            }
        }
    }

    private DynamicObject createPayerTransDetail(DynamicObject bill) {
        DynamicObject transdetail = TransDetailHelper.createTransDetail((DynamicObject)bill);
        Date billBizDate = DateUtils.truncateDate((Date)bill.getDate("bizdate"));
        Date payerAcceptDate = IfmSettleCenterHelper.getAcceptDate((Long)((Long)bill.getDynamicObject("payerbank").getPkValue()));
        Boolean iscommitbe = bill.getBoolean("iscommitbe");
        Date payerBizDate = this.getBizDate(payerAcceptDate, billBizDate, this.currentDate, iscommitbe);
        transdetail.set("company", bill.getDynamicObject("org").getPkValue());
        transdetail.set("bizdate", (Object)payerBizDate);
        transdetail.set("scorg", bill.getDynamicObject("scorg").getPkValue());
        transdetail.set("currency", bill.getDynamicObject("currency").getPkValue());
        transdetail.set("accountbank", bill.getDynamicObject("payeracctbank").getPkValue());
        transdetail.set("bank", bill.getDynamicObject("payerbank").getPkValue());
        transdetail.set("biztime", (Object)this.getBizTime(payerBizDate, this.currentDate));
        transdetail.set("description", (Object)this.getDecription(bill));
        transdetail.set("debitamount", (Object)bill.getBigDecimal("actpayamt"));
        this.transDetailOpp(transdetail, bill);
        transdetail.set("bankcheckflag", (Object)this.getBankcheckflag(bill, true));
        transdetail.set("originalbankcheckflag", (Object)bill.getString("beibankcheckflag"));
        if (bill.containsProperty("agentpayeraccount") && bill.getDynamicObject("agentpayeraccount") != null) {
            transdetail.set("settlecenteraccno", (Object)bill.getDynamicObject("agentpayeraccount").getString("bankaccountnumber"));
            transdetail.set("settlecenteraccname", (Object)bill.getDynamicObject("agentpayeraccount").getString("acctname"));
        }
        this.handleAutoRecord(bill, transdetail);
        return transdetail;
    }

    private DynamicObject createOppTransDetail(DynamicObject bill) {
        DynamicObject accountBank = TransDetailHelper.checkPayeeDetail((DynamicObject)bill);
        if (accountBank != null) {
            Boolean iscommitbe = bill.getBoolean("iscommitbe");
            Date billBizDate = DateUtils.truncateDate((Date)bill.getDate("bizdate"));
            DynamicObject transdetail = TransDetailHelper.createTransDetail((DynamicObject)bill);
            Long payerccountBankId = (Long)bill.getDynamicObject("payeracctbank").getPkValue();
            DynamicObject payerAccountBank = BusinessDataServiceHelper.loadSingle((Object)payerccountBankId, (String)"bd_accountbanks", (String)"id, scorg, company,bank,bankaccountnumber, name");
            Long bankId = (Long)accountBank.getDynamicObject("bank").getPkValue();
            Date payeeAcceptDate = IfmSettleCenterHelper.getAcceptDate((Long)bankId);
            Date bizDate = this.getBizDate(payeeAcceptDate, billBizDate, this.currentDate, iscommitbe);
            transdetail.set("company", accountBank.getDynamicObject("company").getPkValue());
            transdetail.set("bizdate", (Object)bizDate);
            transdetail.set("scorg", accountBank.getDynamicObject("scorg").getPkValue());
            transdetail.set("currency", bill.getDynamicObject("currency").getPkValue());
            transdetail.set("accountbank", accountBank.getPkValue());
            transdetail.set("bank", (Object)accountBank.getDynamicObject("bank"));
            transdetail.set("biztime", (Object)this.getBizTime(bizDate, this.currentDate));
            transdetail.set("description", (Object)this.getDecription(bill));
            transdetail.set("creditamount", (Object)bill.getBigDecimal("actpayamt"));
            transdetail.set("oppbank", (Object)payerAccountBank.getDynamicObject("bank").getString("name"));
            transdetail.set("oppbanknumber", (Object)payerAccountBank.getString("bankaccountnumber"));
            transdetail.set("oppunit", (Object)payerAccountBank.getString("name"));
            String bankcheckflag = this.getBankcheckflag(bill, false);
            transdetail.set("bankcheckflag", (Object)bankcheckflag);
            transdetail.set("detailid", (Object)("REC" + bill.getLong("id")));
            transdetail.set("uniqueseq", (Object)("REC" + bill.getLong("id")));
            transdetail.set("receredtype", (Object)this.getReceredType(bill, bankcheckflag));
            return transdetail;
        }
        return null;
    }

    private String getDecription(DynamicObject bill) {
        String description = bill.getString("description");
        if (EmptyUtil.isEmpty((String)description)) {
            description = bill.getString("usage");
        }
        return description;
    }

    private String getReceredType(DynamicObject transBill, String oppBankFlag) {
        String bankCheckFlag = transBill.getString("bankcheckflag");
        if (EmptyUtil.isNoEmpty((String)oppBankFlag) && oppBankFlag.equals(bankCheckFlag)) {
            return ReceredtypeEnum.ACCOUNTED.getValue();
        }
        return ReceredtypeEnum.Pending.getValue();
    }

    private String getBankcheckflag(DynamicObject transBill, boolean isPay) {
        String bankCheckFlag = transBill.getString("bankcheckflag");
        if (isPay) {
            return bankCheckFlag;
        }
        DynamicObject org = transBill.getDynamicObject("org");
        long payeeId = transBill.getLong("payee");
        boolean isOppBook = false;
        if (org != null && org.getLong("id") == payeeId) {
            isOppBook = TmcParameterHelper.getAppBoolParameter((String)TmcAppEnum.CAS.getId(), (long)payeeId, (String)"cs1047");
        }
        if (!isOppBook) {
            return GenBankcheckCode.genCode();
        }
        return bankCheckFlag;
    }

    private void transDetailOpp(DynamicObject transdetail, DynamicObject bill) {
        String transType = bill.getString("transtype");
        if (TransTypeEnum.isLinkagePAY((Object)transType)) {
            DynamicObject bankAccount = bill.getDynamicObject("bankaccount");
            if (bankAccount == null) {
                return;
            }
            DynamicObject bank = (bankAccount = TmcDataServiceHelper.loadSingleFromCache((Object)bankAccount.getPkValue(), (String)"bd_accountbanks", (String)"bank,company,bankaccountnumber")).getDynamicObject("bank");
            transdetail.set("oppbank", (Object)(bank != null ? bank.getString("name") : ""));
            transdetail.set("oppbanknumber", (Object)bankAccount.getString("bankaccountnumber"));
            DynamicObject company = bankAccount.getDynamicObject("company");
            transdetail.set("oppunit", (Object)(company != null ? company.getString("name") : ""));
            return;
        }
        transdetail.set("oppbank", (Object)bill.getString("payeebankname"));
        transdetail.set("oppbanknumber", (Object)bill.getString("payeebanknum"));
        String recAccBankName = bill.getString("recaccbankname");
        String string = recAccBankName = EmptyUtil.isEmpty((String)recAccBankName) ? bill.getString("payeename") : recAccBankName;
        if (TransTypeEnum.isInnerPayType((String)transType)) {
            DynamicObject acctBank = TmcDataServiceHelper.loadSingleFromCache((String)"bd_accountbanks", (String)"acctname", (QFilter[])new QFilter[]{new QFilter("bankaccountnumber", "=", (Object)bill.getString("payeebanknum"))});
            recAccBankName = EmptyUtil.isNoEmpty((DynamicObject)acctBank) ? acctBank.getLocaleString("acctname").getLocaleValue() : recAccBankName;
        }
        transdetail.set("oppunit", (Object)recAccBankName);
    }
}

