/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.mservice.transdetail;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.helper.ElecReceiptViewHelper;

public class QueryBankReceiptService {
    public Set<String> getBankReceipts(Set<Long> bizIds, boolean isPay) {
        List<Long> transBillIds = this.getTransBillIds(bizIds, isPay);
        if (CollectionUtils.isEmpty(transBillIds)) {
            return Collections.emptySet();
        }
        Set details = ElecReceiptViewHelper.getDetails(transBillIds, (String)(isPay ? "ifm_transhandlebill" : "cas_recbill"));
        return ElecReceiptViewHelper.getReceipts((Set)details);
    }

    public Set<Long> getBankDetails(Set<Long> bizIds, boolean isPay) {
        List<Long> transBillIds = this.getTransBillIds(bizIds, isPay);
        if (CollectionUtils.isEmpty(transBillIds)) {
            return Collections.emptySet();
        }
        return ElecReceiptViewHelper.getDetails(transBillIds, (String)(isPay ? "ifm_transhandlebill" : "cas_recbill"));
    }

    private List<Long> getTransBillIds(Set<Long> bizIds, boolean isPay) {
        if (isPay) {
            Object[] payAcceptBills = TmcDataServiceHelper.load((String)"ifm_payacceptancebill", (String)"id", (QFilter[])new QFilter[]{new QFilter("sourcebilltype", "=", (Object)"cas_paybill"), new QFilter("sourcebillid", "in", bizIds)});
            if (EmptyUtil.isEmpty((Object[])payAcceptBills)) {
                return null;
            }
            Set tansBillIds = Arrays.stream(payAcceptBills).map(o -> o.getPkValue()).collect(Collectors.toSet());
            Object[] transHandleBills = TmcDataServiceHelper.load((String)"ifm_transhandlebill", (String)"id", (QFilter[])new QFilter[]{new QFilter("sourcebilltype", "=", (Object)"ifm_payacceptancebill"), new QFilter("sourcebillid", "in", tansBillIds)});
            if (EmptyUtil.isEmpty((Object[])transHandleBills)) {
                return null;
            }
            return Arrays.stream(transHandleBills).map(o -> o.getLong("id")).collect(Collectors.toList());
        }
        DynamicObject[] recBills = TmcDataServiceHelper.load((String)"cas_recbill", (String)"bankcheckflag", (QFilter[])new QFilter[]{new QFilter("id", "in", bizIds)});
        Set bankcheckflags = Arrays.stream(recBills).map(o -> o.getString("bankcheckflag")).collect(Collectors.toSet());
        DynamicObject[] recTransBills = TmcDataServiceHelper.load((String)"ifm_rectransbill", (String)"id,sourcebillid", (QFilter[])new QFilter[]{new QFilter("sourcebilltype", "=", (Object)"cas_recbill"), new QFilter("bankcheckflag", "in", bankcheckflags)});
        return Arrays.stream(recTransBills).map(o -> o.getLong("sourcebillid")).collect(Collectors.toList());
    }
}

