/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.mservice.transdetail;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.helper.IfmSettleCenterHelper;
import kd.tmc.ifm.helper.TransDetailHelper;
import kd.tmc.ifm.mservice.transdetail.AbstractTransDetailBuilder;

public class RecTransDetailBuilder
extends AbstractTransDetailBuilder {
    private static Log logger = LogFactory.getLog(RecTransDetailBuilder.class);

    public RecTransDetailBuilder(DynamicObject bill) {
        super(bill);
    }

    @Override
    public List<DynamicObject> build() {
        return this.createTransDetail(this.getBizBill());
    }

    private List<DynamicObject> createTransDetail(DynamicObject bill) {
        DynamicObject transdetail = TransDetailHelper.createTransDetail((DynamicObject)bill);
        Date currentDate = new Date();
        Date bizBizDate = bill.getDate("bizdate");
        Long payeeAccountId = (Long)bill.getDynamicObject("payeeaccountbank").getPkValue();
        DynamicObject accountBank = BusinessDataServiceHelper.loadSingle((Object)payeeAccountId, (String)"bd_accountbanks", (String)"id,bank");
        Date acceptDate = IfmSettleCenterHelper.getAcceptDate((Long)((Long)bill.getDynamicObject("payeebank").getPkValue()));
        Date bizDate = this.getBizDate(acceptDate, bizBizDate, currentDate, false);
        transdetail.set("company", bill.getDynamicObject("payeeorg").getPkValue());
        transdetail.set("bizdate", (Object)bizDate);
        transdetail.set("scorg", bill.getDynamicObject("scorg").getPkValue());
        transdetail.set("currency", bill.getDynamicObject("currency").getPkValue());
        transdetail.set("accountbank", accountBank.getPkValue());
        transdetail.set("bank", accountBank.getDynamicObject("bank").getPkValue());
        transdetail.set("biztime", (Object)this.getBizTime(bizDate, currentDate));
        transdetail.set("description", (Object)bill.getString("description"));
        transdetail.set("creditamount", (Object)bill.getBigDecimal("actrecamt"));
        DynamicObject payerAcctBank = this.getOppAcct(bill);
        if (payerAcctBank != null) {
            String oppunit = payerAcctBank.getString("name");
            if (EmptyUtil.isEmpty((String)oppunit)) {
                oppunit = bill.getString("payername");
            }
            transdetail.set("oppbank", (Object)payerAcctBank.getDynamicObject("bank").getString("name"));
            transdetail.set("oppbanknumber", (Object)payerAcctBank.getString("bankaccountnumber"));
            transdetail.set("oppunit", (Object)oppunit);
        } else {
            transdetail.set("oppbank", (Object)bill.getString("payerbankname"));
            transdetail.set("oppbanknumber", (Object)bill.getString("payeracctbanknum"));
            transdetail.set("oppunit", (Object)bill.getString("payername"));
        }
        transdetail.set("bankcheckflag", (Object)bill.getString("bankcheckflag"));
        return Collections.singletonList(transdetail);
    }

    private DynamicObject getOppAcct(DynamicObject bill) {
        QFilter qFilter;
        DynamicObject[] payerAcctBanks;
        long payerAcctBankId = bill.get("payeracctbank") == null ? 0L : Long.parseLong(bill.get("payeracctbank").toString());
        DynamicObject payerAcctBank = null;
        if (payerAcctBankId != 0L && (payerAcctBanks = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id,bank,bankaccountnumber,name", (QFilter[])new QFilter[]{qFilter = new QFilter("id", "=", (Object)payerAcctBankId)})).length > 0) {
            payerAcctBank = payerAcctBanks[0];
        }
        return payerAcctBank;
    }
}

