/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.mservice.transdetail;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.ifm.mservice.transdetail.TransDetailBotpBuilder;
import org.apache.commons.lang3.tuple.Pair;

public class SaveBotpRelation {
    public static void createTransDetailIntelRelation(DynamicObject[] objs) {
        List ids = Stream.of(objs).map(v -> v.get("id")).collect(Collectors.toList());
        QFilter qFilter = new QFilter("sourcebillid", "in", ids);
        DynamicObject[] transDetailObjs = BusinessDataServiceHelper.load((String)"ifm_transdetail", (String)"id,debitamount,sourcebillid,sourcebilltype", (QFilter[])new QFilter[]{qFilter});
        SaveBotpRelation.saveRelation(transDetailObjs);
    }

    public static void saveRelation(DynamicObject[] transDetailObjs) {
        ArrayList<Pair> paySrcTarBotpIdList = new ArrayList<Pair>(10);
        ArrayList<Pair> recSrcTarBotpIdList = new ArrayList<Pair>(10);
        for (DynamicObject obj : transDetailObjs) {
            TransDetailBotpBuilder builder;
            Long casSrcId;
            BigDecimal payAmt = obj.getBigDecimal("debitamount");
            String sourceBillType = (String)obj.get("sourcebilltype");
            if ("ifm_transhandlebill".equals(sourceBillType) && payAmt.compareTo(BigDecimal.ZERO) == 0 || "ifm_rectransbill".equals(sourceBillType) && payAmt.compareTo(BigDecimal.ZERO) != 0 || null == (casSrcId = (builder = TransDetailBotpBuilder.builder(obj)).getCasSrcId())) continue;
            Long pkValue = (Long)obj.getPkValue();
            if (payAmt.compareTo(BigDecimal.ZERO) == 0) {
                recSrcTarBotpIdList.add(Pair.of((Object)pkValue, (Object)casSrcId));
                continue;
            }
            paySrcTarBotpIdList.add(Pair.of((Object)pkValue, (Object)casSrcId));
        }
        try (TXHandle tx = TX.requiresNew();){
            if (!paySrcTarBotpIdList.isEmpty()) {
                TmcBotpHelper.batchSaveRelation((String)"bei_intelpay", (String)"cas_paybill", paySrcTarBotpIdList);
            }
            if (!recSrcTarBotpIdList.isEmpty()) {
                TmcBotpHelper.batchSaveRelation((String)"bei_intelrec", (String)"cas_recbill", recSrcTarBotpIdList);
            }
        }
    }
}

