/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.mservice.transdetail;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.ReceredtypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.mq.TmcMQParam;
import kd.tmc.fbp.common.mq.TmcMQTypeEnum;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.enums.TransTypeEnum;
import kd.tmc.ifm.helper.InnerAccountBalanceHelper;
import kd.tmc.ifm.mservice.transdetail.AbstractTransDetailBuilder;

public class TransDetailService {
    private static final Log logger = LogFactory.getLog(TransDetailService.class);

    public static DynamicObject[] createTransDetail(DynamicObject bill) {
        AbstractTransDetailBuilder builder = AbstractTransDetailBuilder.createBuilder(bill);
        List<DynamicObject> transdetails = builder.build();
        TransDetailService.saveTransDetail(transdetails);
        return transdetails.toArray(new DynamicObject[0]);
    }

    public static void asyncDeleteTransDetail(DynamicObject bill) {
        DynamicObject[] transDynColls = TransDetailService.getTransDetailFromDB(bill);
        if (transDynColls.length == 0) {
            return;
        }
        Object[] ids = Arrays.stream(transDynColls).map(DataEntityBase::getPkValue).toArray();
        boolean isPay = StringUtils.equals((CharSequence)bill.getDynamicObjectType().getName(), (CharSequence)"ifm_transhandlebill");
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("transdetailids", ids);
        paramMap.put("ispay", isPay);
        TmcMQParam.build((TmcMQTypeEnum)TmcMQTypeEnum.ASYNC_DEL_TRANSDETAIL, paramMap).sendMessageInDbTranscation("kd.tmc.ifm.trans");
    }

    public static void revertTransDetail(DynamicObject bill) {
        DynamicObject[] transDynColls = TransDetailService.getTransDetailFromDB(bill);
        if (transDynColls.length == 0) {
            return;
        }
        Object[] pks = Arrays.stream(transDynColls).map(DataEntityBase::getPkValue).toArray();
        boolean isPay = StringUtils.equals((CharSequence)bill.getDynamicObjectType().getName(), (CharSequence)"ifm_transhandlebill");
        if (Objects.equals(bill.getString("transtype"), TransTypeEnum.RELEASE.getValue())) {
            isPay = false;
        }
        TransDetailService.revertTransDetail(pks, isPay);
    }

    public static void revertTransDetail(Object[] transDetailIds, boolean isPay) {
        if (EmptyUtil.isNoEmpty((Object[])transDetailIds)) {
            QFilter filter = new QFilter("id", "in", (Object)transDetailIds);
            DynamicObject[] transDynColls = TmcDataServiceHelper.load((String)"ifm_transdetail", (String)"id,receredtype,recedbillentry", (QFilter[])filter.toArray());
            TransDetailService.cancelMatchTransDetail(isPay, transDynColls);
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            TmcOperateServiceHelper.execOperate((String)"delete", (String)"ifm_transdetail", (Object[])transDetailIds, (OperateOption)OperateOption.create());
        }
    }

    private static void cancelMatchTransDetail(boolean isPay, DynamicObject[] transDynColls) {
        Object[] pks = Arrays.stream(transDynColls).filter(v -> StringUtils.equals((CharSequence)ReceredtypeEnum.ACCOUNTED.getValue(), (CharSequence)v.getString("receredtype"))).filter(r -> EmptyUtil.isNoEmpty((DynamicObjectCollection)r.getDynamicObjectCollection("recedbillentry"))).map(DataEntityBase::getPkValue).toArray();
        if (EmptyUtil.isNoEmpty((Object[])pks)) {
            String entityName = isPay ? "bei_intelpay" : "bei_intelrec";
            TmcOperateServiceHelper.execOperate((String)"cancelmatch", (String)entityName, (Object[])pks, (OperateOption)OperateOption.create());
        }
    }

    private static void saveTransDetail(List<DynamicObject> transDetails) {
        TmcOperateServiceHelper.execOperate((String)"save", (String)"ifm_transdetail", (DynamicObject[])transDetails.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
    }

    public static void updateTransDetailBalanceAfter(Long accBankId, Long currencyId, BigDecimal addAmount, Date bizDate) {
        Date currentDate = DateUtils.getCurrentDate();
        if (bizDate.before(currentDate)) {
            String transSQLOther = "update t_bei_transdetail set ftransbalance = ftransbalance + ? where faccountbankid = ? and fcurrencyid = ? and fbizdate > ?";
            TmcDataServiceHelper.execute((DBRoute)DBRouteConst.TMC, (String)transSQLOther, (Object[])new Object[]{addAmount, accBankId, currencyId, bizDate});
        }
    }

    public static void rebuildTransDetailBalance(Long accBankId, Long currencyId, Date bizDate) {
        List<DynamicObject> transDetails = TransDetailService.getTransDetails(accBankId, currencyId, bizDate);
        if (transDetails == null || transDetails.size() == 0) {
            return;
        }
        BigDecimal lastDayAmount = InnerAccountBalanceHelper.getBalance((Long)accBankId, (Long)currencyId, (Date)DateUtils.getLastDay((Date)bizDate, (int)1));
        BigDecimal transAmt = BigDecimal.ZERO;
        for (DynamicObject transObj : transDetails) {
            BigDecimal payAmt = transObj.getBigDecimal("debitamount");
            BigDecimal recAmt = transObj.getBigDecimal("creditamount");
            transAmt = transAmt.subtract(payAmt).add(recAmt);
            BigDecimal balanceAmt = lastDayAmount.add(transAmt);
            transObj.set("transbalance", (Object)balanceAmt);
        }
        SaveServiceHelper.save((DynamicObject[])transDetails.toArray(new DynamicObject[0]));
    }

    private static List<DynamicObject> getTransDetails(Long acctBankId, Long currencyId, Date fromDate) {
        QFilter qFilter = new QFilter("accountbank.id", "=", (Object)acctBankId);
        qFilter.and(new QFilter("currency", "=", (Object)currencyId));
        qFilter.and(new QFilter("bizdate", "=", (Object)fromDate));
        DynamicObject[] transObjs = BusinessDataServiceHelper.load((String)"ifm_transdetail", (String)"id, bizdate, biztime,debitamount,creditamount, transbalance", (QFilter[])new QFilter[]{qFilter}, (String)"biztime asc");
        if (transObjs == null || transObjs.length == 0) {
            return null;
        }
        return Arrays.asList(transObjs);
    }

    public static boolean existTransDetail(Long acctBankId, Long currencyId, Date bizDate, Date bizTime) {
        QFilter accFilter = new QFilter("accountbank.id", "=", (Object)acctBankId);
        accFilter.and(new QFilter("currency", "=", (Object)currencyId));
        QFilter dateFilter = new QFilter("bizdate", ">", (Object)bizDate);
        QFilter timeFilter = new QFilter("bizdate", "=", (Object)bizDate);
        timeFilter.and(new QFilter("biztime", ">", (Object)bizTime));
        dateFilter.or(timeFilter);
        QFilter finalQFilter = accFilter.copy().and(dateFilter);
        int count = TmcDataServiceHelper.count((String)"ifm_transdetail", (QFilter[])finalQFilter.toArray());
        return count != 0;
    }

    public static DynamicObject[] getTransDetailFromDB(DynamicObject bill) {
        QFilter transQFilter = new QFilter("sourcebillid", "=", bill.getPkValue());
        transQFilter.and("sourcebilltype", "=", (Object)bill.getDataEntityType().getName());
        return BusinessDataServiceHelper.load((String)"ifm_transdetail", (String)"id,debitamount,creditamount,transbalance,accountbank.id,currency.id,bizdate,biztime,biztype,receredtype,recedbillentry", (QFilter[])new QFilter[]{transQFilter});
    }

    public static DynamicObject[] getTransDetailFromDB(List<Object> transBillIds) {
        QFilter transQFilter = new QFilter("id", "in", transBillIds);
        return BusinessDataServiceHelper.load((String)"ifm_transdetail", (String)"id,debitamount,creditamount,transbalance,accountbank.id,currency.id,bizdate,biztime,biztype,receredtype,recedbillentry", (QFilter[])new QFilter[]{transQFilter});
    }

    public static void deleteTransBill(Object[] ids, boolean isPay) {
        String entityName;
        String string = entityName = isPay ? "ifm_transhandlebill" : "ifm_rectransbill";
        if (TmcDataServiceHelper.exists((String)entityName, (QFilter[])new QFilter("id", "in", (Object)ids).toArray())) {
            TmcOperateServiceHelper.execOperate((String)"canclepay", (String)entityName, (Object[])ids, (OperateOption)OperateOption.create());
        }
    }

    public static void deleteCasPayRecBill(Object[] ids, boolean isPay) {
        String entityName = isPay ? "cas_paybill" : "cas_recbill";
        String cancelKey = isPay ? "cancelpay" : "cancelrec";
        QFilter filter = new QFilter("id", "in", (Object)ids);
        filter.and("billstatus", "!=", (Object)"G");
        DynamicObjectCollection payBills = QueryServiceHelper.query((String)entityName, (String)"id,billstatus", (QFilter[])filter.toArray());
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)payBills)) {
            for (DynamicObject payBill : payBills) {
                String billStatus = payBill.getString("billstatus");
                if (StringUtils.equals((CharSequence)billStatus, (CharSequence)BillStatusEnum.PAYED.getValue())) {
                    TmcOperateServiceHelper.execOperate((String)cancelKey, (String)entityName, (Object[])ids, (OperateOption)OperateOption.create(), (boolean)true);
                    billStatus = BillStatusEnum.AUDIT.getValue();
                }
                if (StringUtils.equals((CharSequence)billStatus, (CharSequence)BillStatusEnum.AUDIT.getValue())) {
                    TmcOperateServiceHelper.execOperate((String)"unaudit", (String)entityName, (Object[])ids, (OperateOption)OperateOption.create(), (boolean)true);
                }
                if (StringUtils.equals((CharSequence)billStatus, (CharSequence)BillStatusEnum.SUBMIT.getValue())) {
                    TmcOperateServiceHelper.execOperate((String)"unsubmit", (String)entityName, (Object[])ids, (OperateOption)OperateOption.create(), (boolean)true);
                }
                TmcOperateServiceHelper.execOperate((String)"delete", (String)entityName, (Object[])ids, (OperateOption)OperateOption.create(), (boolean)true);
            }
        }
    }

    public static DynamicObjectCollection getDetailColls(List<Long> transBillIds) {
        if (EmptyUtil.isEmpty(transBillIds)) {
            return null;
        }
        QFilter transQFilter = new QFilter("sourcebillid", "in", transBillIds);
        DynamicObjectCollection transBills = QueryServiceHelper.query((String)"ifm_transdetail", (String)"id,sourcebillid,billno", (QFilter[])new QFilter[]{transQFilter});
        if (EmptyUtil.isEmpty((DynamicObjectCollection)transBills)) {
            return transBills;
        }
        return transBills;
    }
}

