/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.mservice.transhandlebill;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.bean.TransBillUpdatePaidInfo;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DeductionReserveService {
    private static final Log logger = LogFactory.getLog(DeductionReserveService.class);

    public void reserveDeduction(List<TransBillUpdatePaidInfo> params) {
        String paramStr = SerializationUtils.toJsonString(params);
        logger.info("DeductionReserveService params:{}", (Object)paramStr);
        if (EmptyUtil.isEmpty(params)) {
            return;
        }
        Set deductionIds = params.stream().map(o -> o.getTransBillId()).collect(Collectors.toSet());
        DynamicObject[] deductionBills = TmcDataServiceHelper.load((String)"ifm_deduction", (String)"id,billstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", deductionIds)});
        Set deductionAuditIds = Arrays.stream(deductionBills).filter(o -> BillStatusEnum.isAudit((String)o.getString("billstatus"))).map(o -> o.getLong("id")).collect(Collectors.toSet());
        Set deductionSubmitIds = Arrays.stream(deductionBills).filter(o -> BillStatusEnum.isSubmit((String)o.getString("billstatus"))).map(o -> o.getLong("id")).collect(Collectors.toSet());
        Set deductionSaveIds = Arrays.stream(deductionBills).filter(o -> BillStatusEnum.isSave((String)o.getString("billstatus"))).map(o -> o.getLong("id")).collect(Collectors.toSet());
        if (EmptyUtil.isNoEmpty(deductionAuditIds)) {
            TmcOperateServiceHelper.execOperate((String)"unaudit", (String)"ifm_deduction", (Object[])deductionAuditIds.toArray(), (OperateOption)OperateOption.create());
            deductionSaveIds.addAll(deductionAuditIds);
            logger.info("unaudit success, ids:{}", (Object)deductionAuditIds.stream().map(String::valueOf).collect(Collectors.joining("\u3001")));
        }
        if (EmptyUtil.isNoEmpty(deductionSubmitIds)) {
            TmcOperateServiceHelper.execOperate((String)"unsubmit", (String)"ifm_deduction", (Object[])deductionSubmitIds.toArray(), (OperateOption)OperateOption.create());
            deductionSaveIds.addAll(deductionSubmitIds);
            logger.info("unsubmit success, ids:{}", (Object)deductionSubmitIds.stream().map(String::valueOf).collect(Collectors.joining("\u3001")));
        }
        if (EmptyUtil.isNoEmpty(deductionSaveIds)) {
            TmcOperateServiceHelper.execOperate((String)"delete", (String)"ifm_deduction", (Object[])deductionSaveIds.toArray(), (OperateOption)OperateOption.create());
            logger.info("delete success, ids:{}", (Object)deductionSaveIds.stream().map(String::valueOf).collect(Collectors.joining("\u3001")));
        }
    }
}

