/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.mservice.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CurrentIntBillScOrgUpgradeService
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                this.upgradeInternalIntObject();
            }
            catch (Exception e) {
                result.setErrorInfo(e.getMessage());
                result.setSuccess(false);
            }
        }
        return result;
    }

    private void upgradeInternalIntObject() {
        String querySql = "select fsettlecenterid, fid from t_ifm_currentintbill where fscorgid = 0 and fsettlecenterid != 0 and fintsource = ?";
        Object[] queryParams = new Object[]{"inneracct"};
        DataSet upgradeData = DB.queryDataSet((String)"upgradeInternalIntObject", (DBRoute)DBRouteConst.TMC, (String)querySql, (Object[])queryParams);
        if (upgradeData.isEmpty()) {
            return;
        }
        ArrayList<Long> finOrgList = new ArrayList<Long>();
        for (Row row : upgradeData.copy()) {
            Long settleCenterId = row.getLong("fsettlecenterid");
            if (EmptyUtil.isEmpty((Long)settleCenterId)) continue;
            finOrgList.add(settleCenterId);
        }
        if (EmptyUtil.isEmpty(finOrgList)) {
            return;
        }
        String idStr = finOrgList.stream().map(String::valueOf).collect(Collectors.joining(","));
        querySql = String.format("select fid,forgid from t_bd_finorginfo where fid in (%s)", idStr);
        DataSet finOrgInfos = DB.queryDataSet((String)"queryFinOrg", (DBRoute)DBRouteConst.SYS, (String)querySql);
        if (finOrgInfos.isEmpty()) {
            return;
        }
        HashMap<Long, Object> finOrgInfoMap = new HashMap<Long, Object>(16);
        for (Row row : finOrgInfos) {
            Long orgId = row.getLong("forgid");
            if (!EmptyUtil.isNoEmpty((Long)orgId)) continue;
            finOrgInfoMap.put(row.getLong("fid"), orgId);
        }
        if (finOrgInfoMap.size() == 0) {
            return;
        }
        String updateSql = "update t_ifm_currentintbill set fscorgid = ? where fid = ? and fscorgid = 0";
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        for (Row row : upgradeData) {
            Long finOrgInfoId = row.getLong("fsettlecenterid");
            Long scOrgId = (Long)finOrgInfoMap.get(finOrgInfoId);
            if (EmptyUtil.isEmpty((Long)scOrgId)) continue;
            Object[] params = new Object[]{scOrgId, row.getLong("fid")};
            paramsList.add(params);
        }
        if (paramsList.size() > 0) {
            for (int i = 0; i < paramsList.size(); i += 500) {
                int len = Math.min(i + 500, paramsList.size());
                List temp = paramsList.subList(i, len);
                DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)updateSql, temp);
            }
        }
    }
}

