/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.mservice.upgrade;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.constant.RpcResult;
import kd.tmc.fbp.common.constant.RpcResultStatusCode;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;

public class InnerAcctUpgradeService {
    private static final Log LOGGER = LogFactory.getLog(InnerAcctUpgradeService.class);

    public String upgrade() {
        RpcResult result = new RpcResult();
        QFilter orgFilter = new QFilter("org", "=", (Object)0);
        DynamicObject[] innerAccts = TmcDataServiceHelper.load((String)"ifm_inneracct", (String)String.join((CharSequence)",", "finorg", "org"), (QFilter[])orgFilter.toArray());
        if (innerAccts == null || innerAccts.length == 0) {
            return JSON.toJSONString((Object)result);
        }
        HashMap<Long, DynamicObject> idMap = new HashMap<Long, DynamicObject>(10);
        for (DynamicObject innerAcct : innerAccts) {
            DynamicObject org;
            DynamicObject openBank = innerAcct.getDynamicObject("finorg");
            Long openBankId = (Long)openBank.get("id");
            DynamicObject finOrg = idMap.computeIfAbsent(openBankId, fo -> TmcDataServiceHelper.loadSingle((Object)openBankId, (String)"bd_finorginfo"));
            if (finOrg == null || (org = (DynamicObject)finOrg.get("org")) == null) continue;
            innerAcct.set("org", org.get("id"));
        }
        try (TXHandle h = TX.requiresNew((String)"InnerAcctUpgradeService.upgrade.save");){
            try {
                SaveServiceHelper.save((DynamicObject[])innerAccts);
            }
            catch (Exception e) {
                result.setStatusCode(RpcResultStatusCode.ERROR);
                result.setMessage(e.getMessage());
                LOGGER.error((Throwable)e);
                h.markRollback();
            }
        }
        return JSON.toJSONString((Object)result);
    }
}

