/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.mservice.upgrade;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.ListUtils;
import kd.tmc.ifm.enums.TradeTypeEnum;

public class TransDetailUpgradeService
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        String querySql = "select fsourcebillid,fid from t_bei_transdetail where fbizType = '1' and fsrcbilltype in ('ifm_transhandlebill','ifm_rectransbill')";
        DataSet transDetailSet = DB.queryDataSet((String)"queryTransDetail", (DBRoute)DBRouteConst.TMC, (String)querySql);
        if (transDetailSet.isEmpty()) {
            return null;
        }
        ArrayList<Object> transBillIds = new ArrayList<Object>();
        for (Row row : transDetailSet.copy()) {
            transBillIds.add(row.get("fsourcebillid"));
        }
        Map<Object, String> transBillMap = this.getTransBillMap(transBillIds);
        HashMap updateMap = new HashMap();
        for (Row row : transDetailSet) {
            String srcTradeType = transBillMap.get(row.get("fsourcebillid"));
            List<Object> idList = updateMap.containsKey(srcTradeType) ? (List)updateMap.get(srcTradeType) : new ArrayList();
            idList.add(row.get("fid"));
            updateMap.put(srcTradeType, idList);
        }
        if (updateMap.size() > 0) {
            String updateSql = "update t_bei_transdetail set fbiztype = ? where fid in (%s)";
            for (Map.Entry entry : updateMap.entrySet()) {
                String bizType = (String)entry.getKey();
                List ids = (List)entry.getValue();
                if (EmptyUtil.isEmpty((String)bizType) || EmptyUtil.isEmpty((Collection)ids)) continue;
                List splitList = ListUtils.splitList((List)ids, (long)500L);
                for (List list : splitList) {
                    String idStr = list.stream().map(Object::toString).collect(Collectors.joining(","));
                    ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
                    paramsList.add(new Object[]{bizType});
                    DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)String.format(updateSql, idStr), paramsList);
                }
            }
        }
        return null;
    }

    private Map<Object, String> getTransBillMap(List<Object> transDetailIds) {
        List lists = ListUtils.splitList(transDetailIds, (long)500L);
        HashMap<Object, String> updateMap = new HashMap<Object, String>();
        String transQuerySql = "select fid,ftranstype from t_ifm_transhandle where fid in (%s)";
        String recTransQuerySql = "select fid,ftranstype from t_ifm_rectransbill where fid in (%s)";
        for (List ids : lists) {
            String isStr = ids.stream().map(Object::toString).collect(Collectors.joining(","));
            DataSet transHandleSet = DB.queryDataSet((String)"queryTransHandle", (DBRoute)DBRouteConst.TMC, (String)String.format(transQuerySql, isStr));
            this.addBizTypeMap(updateMap, transHandleSet, "pay");
            DataSet recTransHandleSet = DB.queryDataSet((String)"queryRecTransHandle", (DBRoute)DBRouteConst.TMC, (String)String.format(recTransQuerySql, isStr));
            this.addBizTypeMap(updateMap, recTransHandleSet, "rec");
        }
        return updateMap;
    }

    private void addBizTypeMap(Map<Object, String> updateMap, DataSet dataSet, String splicer) {
        if (dataSet.isEmpty()) {
            return;
        }
        for (Row row : dataSet) {
            String transType = row.getString("ftranstype");
            if (!EmptyUtil.isNoEmpty((String)transType)) continue;
            transType = TradeTypeEnum.translate((String)String.join((CharSequence)"_", splicer, transType));
            updateMap.put(row.get("fid"), transType);
        }
    }
}

