/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.opservice.apply;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.helper.BillChangeHistoryHelper;
import kd.tmc.fbp.common.helper.CreditLimitServiceHelper;
import kd.tmc.fbp.common.helper.GuaranteeUseHelper;
import kd.tmc.fbp.common.helper.SuretyHelper;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.lc.common.enums.LetterBizTypeEnum;
import kd.tmc.lc.common.enums.LetterCreditStatusEnum;
import kd.tmc.lc.common.helper.LetterCreditHelper;

public class LetterCreditApplyAuditService
extends AbstractTmcBizOppService {
    private static final String SEPARATOR = "/";
    private static final String[] NO_SAVE_PROPERTYS = new String[]{"feedetail", "entrys", "id", "billno", "billstatus", "billhead_lk", "creator", "creatortime", "modifier", "modifytime", "auditor", "auditdate", "multilanguagetext", "applydate"};

    public List<String> getSelector() {
        List sic = super.getSelector();
        this.setSelectorByEntity(sic);
        sic.add("feedetail");
        sic.add("applydate");
        sic.add("entrys");
        sic.add("gcontract");
        sic.add("gamount");
        sic.add("gratio");
        sic.add("gcomment");
        sic.add("gexchrate");
        return sic;
    }

    private void setSelectorByEntity(List<String> sic) {
        DynamicObject entityObj = TmcDataServiceHelper.newDynamicObject((String)"lc_bizapply");
        for (IDataEntityProperty property : entityObj.getDataEntityType().getProperties()) {
            if (Arrays.asList(NO_SAVE_PROPERTYS).contains(property.getName()) || property.getName().endsWith("_id")) continue;
            sic.add(property.getName());
        }
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        ArrayList<DynamicObject> letterCreditLists = new ArrayList<DynamicObject>(16);
        for (DynamicObject applyBill : dataEntities) {
            String bizType = applyBill.getString("biztype");
            if (LetterBizTypeEnum.OPEN_CARD.getValue().equals(bizType)) {
                DynamicObject targetBill;
                OperateOption option = OperateOption.create();
                this.dealApplyFeeEntry(bizType, applyBill, option);
                option.setVariableValue("auditPush", LetterBizTypeEnum.OPEN_CARD.getValue());
                OperationResult result = TmcOperateServiceHelper.execOperate((String)"pushregister", (String)"lc_bizapply", (DynamicObject[])new DynamicObject[]{applyBill}, (OperateOption)option);
                if (!result.isSuccess() || !EmptyUtil.isNoEmpty((DynamicObject)(targetBill = TmcBotpHelper.getTargetBill((String)"lc_bizapply", (Object)applyBill.getPkValue(), (String)"lc_lettercredit")))) continue;
                this.setAttachments(applyBill, (Long)targetBill.getPkValue());
                targetBill.set("entry_gcontract", applyBill.get("entry_gcontract"));
                GuaranteeUseHelper.saveGuaranteeUse((DynamicObject[])new DynamicObject[]{targetBill}, (String[])new String[0]);
                continue;
            }
            if (LetterBizTypeEnum.EDIT_CARD.getValue().equals(bizType)) {
                DynamicObject letterCredit = LetterCreditHelper.getLetterInfo((Long)((Long)(applyBill = TmcDataServiceHelper.loadSingle((Object)applyBill.getPkValue(), (String)"lc_bizapply")).getDynamicObject("lettercredit").getPkValue()), (boolean)false);
                List creditAtt = AttachmentServiceHelper.getAttachments((String)"lc_lettercredit", (Object)letterCredit.get("id"), (String)"attachmentpanel");
                if (creditAtt != null && creditAtt.size() > 0) {
                    HashMap<Object, String> tempMap = new HashMap<Object, String>(creditAtt.size());
                    for (Map attachmentInfo : creditAtt) {
                        Object attPkId = attachmentInfo.get("attPkId");
                        String originalUid = (String)attachmentInfo.get("uid");
                        tempMap.put(attPkId, originalUid);
                    }
                    this.delAttachments(applyBill, (Long)letterCredit.getPkValue(), tempMap);
                }
                this.setAttachments(applyBill, (Long)letterCredit.getPkValue());
                this.saveBillHistoryInfo(applyBill, letterCredit);
                this.updateLetterCredit(bizType, applyBill, letterCredit);
                letterCreditLists.add(letterCredit);
                continue;
            }
            if (LetterBizTypeEnum.REPEAL_CARD.getValue().equals(bizType)) {
                this.setLetterCreditStatus(applyBill, LetterCreditStatusEnum.DONE_REPEAL.getValue());
                continue;
            }
            if (!LetterBizTypeEnum.CLOSE_CARD.getValue().equals(bizType)) continue;
            this.setLetterCreditStatus(applyBill, LetterCreditStatusEnum.DONE_CLOSE.getValue());
        }
        if (EmptyUtil.isNoEmpty(letterCreditLists)) {
            GuaranteeUseHelper.saveGuaranteeUse((DynamicObject[])letterCreditLists.toArray(new DynamicObject[0]), (String[])new String[0]);
            List bizIdSet = letterCreditLists.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
            GuaranteeUseHelper.confirmGuaranteeUse(bizIdSet);
        }
    }

    private void setLetterCreditStatus(DynamicObject applyBill, String creditStatus) {
        DynamicObject letterCredit = TmcDataServiceHelper.loadSingle((Object)applyBill.getDynamicObject("lettercredit").getPkValue(), (String)"lc_lettercredit");
        letterCredit.set("creditstatus", (Object)creditStatus);
        if (EmptyUtil.isNoEmpty((DynamicObject)letterCredit.getDynamicObject("creditlimit"))) {
            BigDecimal notArrAmount;
            if (LetterCreditStatusEnum.DONE_CLOSE.getValue().equals(creditStatus)) {
                letterCredit.set("isclosed", (Object)true);
            }
            if (BigDecimal.ZERO.compareTo(notArrAmount = letterCredit.getBigDecimal("notarramount")) > 0) {
                notArrAmount = notArrAmount.add(letterCredit.getBigDecimal("totalarramount"));
            }
            if (BigDecimal.ZERO.compareTo(notArrAmount) != 0) {
                CreditLimitServiceHelper.returnCreditLimit((DynamicObject)letterCredit, (DynamicObject)letterCredit, (boolean)false, (BigDecimal)notArrAmount, (Long)((Long)letterCredit.getPkValue()), (boolean)true, (Date)new Date());
            }
        }
        if (LetterCreditStatusEnum.DONE_REPEAL.getValue().equals(creditStatus)) {
            letterCredit.set("closecarddate", null);
            letterCredit.set("repealdate", (Object)DateUtils.getCurrentDate());
        } else if (LetterCreditStatusEnum.DONE_CLOSE.getValue().equals(creditStatus)) {
            letterCredit.set("closecarddate", (Object)DateUtils.getCurrentDate());
            letterCredit.set("repealdate", null);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{letterCredit});
        LetterCreditHelper.updateSuretyStatus((DynamicObject)letterCredit, (String)creditStatus);
    }

    private void dealApplyFeeEntry(String bizType, DynamicObject applyBill, OperateOption create) {
        DynamicObjectCollection feeDetail = applyBill.getDynamicObjectCollection("feedetail");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)feeDetail)) {
            if (LetterBizTypeEnum.OPEN_CARD.getValue().equals(bizType)) {
                create.setVariableValue("FeeDetailEditPageSaveOp", ProductTypeEnum.LC_APPLY.getFormId());
            } else if (LetterBizTypeEnum.EDIT_CARD.getValue().equals(bizType)) {
                String editApplyFeeEntrySeriStr = DynamicObjectSerializeUtil.serialize((Object[])feeDetail.toArray(), (DynamicObjectType)((DynamicObject)feeDetail.get(0)).getDynamicObjectType());
                create.setVariableValue("EditApplyFeeEntrySeriStr", editApplyFeeEntrySeriStr);
                create.setVariableValue("EditApplyFeeOpTypeFormId", ProductTypeEnum.LC_CHANGE.getFormId());
            }
        }
    }

    private void setAttachments(DynamicObject data, Long successPkId) {
        List attachments = AttachmentServiceHelper.getAttachments((String)"lc_bizapply", (Object)data.get("id"), (String)"attachmentpanel");
        if (attachments != null && attachments.size() > 0) {
            for (Map attachment : attachments) {
                if (attachment.containsKey("lastModified") && attachment.get("lastModified") instanceof Date) {
                    Date date = (Date)attachment.get("lastModified");
                    attachment.put("lastModified", date.getTime());
                }
                if (!attachment.containsKey("attPkId")) continue;
                DynamicObject atts = TmcDataServiceHelper.loadSingle(attachment.get("attPkId"), (String)"bos_attachment", (String)"ffileid");
                String property = System.getProperty("clusterName");
                StringBuilder path = new StringBuilder();
                if (EmptyUtil.isNoEmpty((String)property)) {
                    path.append(property);
                    path.append(SEPARATOR);
                }
                path.append(DateUtils.formatString((Date)new Date(), (String)"yyyyMM"));
                path.append(SEPARATOR);
                path.append("lc");
                path.append(SEPARATOR);
                path.append("lc_lettercredit");
                path.append(SEPARATOR);
                path.append(successPkId);
                path.append(SEPARATOR);
                path.append("attachments");
                path.append(SEPARATOR);
                path.append(attachment.get("name"));
                TXHandle h = TX.requiresNew();
                Throwable throwable = null;
                try {
                    try {
                        FileService fs = FileServiceFactory.getAttachmentFileService();
                        FileItem fi = new FileItem((String)attachment.get("name"), path.toString(), fs.getInputStream(atts.getString("ffileid")));
                        String upload = fs.upload(fi);
                        attachment.put("url", upload);
                    }
                    catch (Throwable e) {
                        h.markRollback();
                        throw e;
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (h == null) continue;
                    if (throwable != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    h.close();
                }
            }
            try (TXHandle h = TX.requiresNew();){
                try {
                    AttachmentServiceHelper.upload((String)"lc_lettercredit", (Object)successPkId, (String)"attachmentpanel", (List)attachments);
                }
                catch (Throwable e) {
                    h.markRollback();
                    throw e;
                }
            }
        }
    }

    public void handlerException(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject bill : dataEntities) {
            Map botpMap = BFTrackerServiceHelper.findTargetBills((String)"lc_bizapply", (Long[])new Long[]{bill.getLong("id")});
            this.deletePushRegisterBill(botpMap);
        }
    }

    private void deletePushRegisterBill(Map<String, HashSet<Long>> botpMap) {
        Object[] downBillIds = botpMap.entrySet().stream().filter(o -> "lc_lettercredit".equals(o.getKey())).map(Map.Entry::getValue).flatMap(Collection::stream).toArray();
        if (downBillIds.length > 0) {
            TmcOperateServiceHelper.execOperate((String)"delete", (String)"lc_lettercredit", (Object[])downBillIds, (OperateOption)OperateOption.create());
        }
    }

    protected void updateLetterCredit(String bizType, DynamicObject applyBill, DynamicObject letterCredit) {
        for (IDataEntityProperty property : applyBill.getDataEntityType().getProperties()) {
            String prop = property.getName();
            if (!letterCredit.getDataEntityType().getProperties().containsKey((Object)prop) || Arrays.asList(NO_SAVE_PROPERTYS).contains(prop) || prop.endsWith("_id") || "entry_gcontract".equals(prop)) continue;
            letterCredit.set(prop, applyBill.get(prop));
        }
        DynamicObjectCollection letterCreditGuaranteeEntry = letterCredit.getDynamicObjectCollection("entry_gcontract");
        DynamicObjectCollection applyBillGuaranteeEntry = applyBill.getDynamicObjectCollection("entry_gcontract");
        Set applyBillGContractIds = applyBillGuaranteeEntry.stream().map(o -> o.getDynamicObject("gcontract").getLong("id")).collect(Collectors.toSet());
        letterCreditGuaranteeEntry.removeIf(o -> applyBillGContractIds.contains(o.getDynamicObject("gcontract").getLong("id")));
        letterCreditGuaranteeEntry.forEach(o -> o.set("gratio", (Object)BigDecimal.ZERO));
        letterCreditGuaranteeEntry.forEach(o -> o.set("gamount", (Object)BigDecimal.ZERO));
        letterCreditGuaranteeEntry.addAll((Collection)applyBillGuaranteeEntry);
        letterCredit.getDynamicObjectCollection("entrys").clear();
        for (DynamicObject entry_a : applyBill.getDynamicObjectCollection("entrys")) {
            DynamicObject entry_l = letterCredit.getDynamicObjectCollection("entrys").addNew();
            for (IDataEntityProperty property : entry_a.getDataEntityType().getProperties()) {
                if (!entry_l.getDataEntityType().getProperties().containsKey((Object)property.getName())) continue;
                entry_l.set(property, entry_a.get(property));
            }
            entry_l.set("id", entry_a.get("id"));
        }
        OperateOption operate = OperateOption.create();
        operate.setVariableValue("history", "true");
        Long pkId = (Long)applyBill.getPkValue();
        operate.setVariableValue("applyId", String.valueOf(pkId));
        letterCredit.set("creditstatus", (Object)LetterCreditStatusEnum.DONE_REGISTER.getValue());
        letterCredit.set("applyreason", applyBill.get("applyreason"));
        this.dealApplyFeeEntry(bizType, applyBill, operate);
        SuretyHelper.setSuretyInfo((DynamicObject)letterCredit);
        TmcOperateServiceHelper.execOperate((String)"save", (String)"lc_lettercredit", (DynamicObject[])new DynamicObject[]{letterCredit}, (OperateOption)operate);
    }

    private void saveBillHistoryInfo(DynamicObject applyBill, DynamicObject letterCredit) {
        BillChangeHistoryHelper.addChangeHistory((Long)((Long)applyBill.getPkValue()), (String)"lc_bizapply", (String)applyBill.getString("billno"), (String)applyBill.getString("applyreason"), (String)"GZ", (DynamicObject)letterCredit);
    }

    private void delAttachments(DynamicObject data, Long pkValue, Map<Object, String> tempMap) {
        List attachments = AttachmentServiceHelper.getAttachments((String)"lc_bizapply", (Object)data.get("id"), (String)"attachmentpanel");
        if (attachments != null && !attachments.isEmpty()) {
            for (Map attachment : attachments) {
                Object attPkId = attachment.get("attPkId");
                tempMap.remove(attPkId);
            }
        }
        if (!tempMap.isEmpty()) {
            for (String value : tempMap.values()) {
                TXHandle h = TX.requiresNew();
                Throwable throwable = null;
                try {
                    try {
                        AttachmentServiceHelper.remove((String)"lc_lettercredit", (Object)pkValue, (Object)value);
                    }
                    catch (Throwable e) {
                        h.markRollback();
                        throw e;
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (h == null) continue;
                    if (throwable != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    h.close();
                }
            }
        }
    }
}

