/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.opservice.apply;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.BillChangeHistoryHelper;
import kd.tmc.fbp.common.helper.CreditLimitServiceHelper;
import kd.tmc.fbp.common.helper.GuaranteeUseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.lc.common.enums.LetterBizTypeEnum;
import kd.tmc.lc.common.enums.LetterCreditStatusEnum;
import kd.tmc.lc.common.helper.LetterCreditHelper;

public class LetterCreditApplyUnAuditService
extends AbstractTmcBizOppService {
    private static final String[] NO_SAVE_PROPERTYS = new String[]{"entrys", "id", "seq", "billno", "billstatus", "billhead_lk", "creator", "creatortime", "modifier", "modifytime", "auditor", "auditdate", "multilanguagetext", "feedetail", "entry_gcontract"};

    public List<String> getSelector() {
        List sic = super.getSelector();
        this.setSelectorByEntity(sic);
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        ArrayList<DynamicObject> letterCreditLists = new ArrayList<DynamicObject>(16);
        for (DynamicObject applyBill : dataEntities) {
            DynamicObject nowLetterCredit;
            Long letterCreditId;
            DynamicObject letterCredit;
            String bizType = applyBill.getString("biztype");
            if (LetterBizTypeEnum.OPEN_CARD.getValue().equals(bizType)) {
                if (!EmptyUtil.isNoEmpty((DynamicObject)applyBill.getDynamicObject("creditlimit"))) continue;
                CreditLimitServiceHelper.cancelCreditLimit((DynamicObject)applyBill, null, (boolean)true);
                applyBill.set("creditgratio", null);
                continue;
            }
            if (LetterBizTypeEnum.EDIT_CARD.getValue().equals(bizType)) {
                letterCredit = applyBill.getDynamicObject("lettercredit");
                letterCreditId = (Long)letterCredit.getPkValue();
                nowLetterCredit = LetterCreditHelper.getLetterInfo((Long)letterCreditId, (boolean)false);
                DynamicObject oldLetterCredit = BillChangeHistoryHelper.genDelChangeHistory((Long)letterCreditId, (String)"lc_lettercredit");
                this.copyValue(oldLetterCredit, nowLetterCredit);
                nowLetterCredit.set("creditstatus", (Object)LetterCreditStatusEnum.CHANGE_ING.getValue());
                letterCreditLists.add(nowLetterCredit);
                LetterCreditHelper.changeUnAuditCreditLimit((DynamicObject)nowLetterCredit, (DynamicObject)applyBill);
                applyBill.set("creditgratio", null);
                continue;
            }
            if (!LetterBizTypeEnum.REPEAL_CARD.getValue().equals(bizType)) continue;
            letterCredit = applyBill.getDynamicObject("lettercredit");
            letterCreditId = (Long)letterCredit.getPkValue();
            nowLetterCredit = LetterCreditHelper.getLetterInfo((Long)letterCreditId, (boolean)false);
            nowLetterCredit.set("creditstatus", (Object)LetterCreditStatusEnum.REPEAL_ING.getValue());
            nowLetterCredit.set("repealdate", null);
            BigDecimal notArrAmount = nowLetterCredit.getBigDecimal("notarramount");
            if (EmptyUtil.isNoEmpty((DynamicObject)nowLetterCredit.getDynamicObject("creditlimit")) && BigDecimal.ZERO.compareTo(notArrAmount) != 0) {
                CreditLimitServiceHelper.cancelReturnCreditLimit((DynamicObject)nowLetterCredit, (DynamicObject)nowLetterCredit, (boolean)false, (BigDecimal)notArrAmount, (Long)((Long)nowLetterCredit.getPkValue()));
            }
            letterCreditLists.add(nowLetterCredit);
        }
        if (letterCreditLists.size() > 0) {
            GuaranteeUseHelper.saveGuaranteeUse((DynamicObject[])letterCreditLists.toArray(new DynamicObject[0]), (String[])new String[0]);
            List bizIdSet = letterCreditLists.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
            GuaranteeUseHelper.confirmGuaranteeUse(bizIdSet);
            SaveServiceHelper.update((DynamicObject[])letterCreditLists.toArray(new DynamicObject[0]));
        }
    }

    private void copyValue(DynamicObject oldLetterCredit, DynamicObject nowLetterCredit) {
        DataEntityPropertyCollection applyProperties = oldLetterCredit.getDataEntityType().getProperties();
        for (IDataEntityProperty property : applyProperties) {
            String prop = property.getName();
            DataEntityPropertyCollection properties = nowLetterCredit.getDataEntityType().getProperties();
            if (!properties.containsKey((Object)prop) || Arrays.asList(NO_SAVE_PROPERTYS).contains(prop) || prop.endsWith("_id")) continue;
            nowLetterCredit.set(prop, oldLetterCredit.get(prop));
        }
        this.clearEntryInfo("entrys", oldLetterCredit, nowLetterCredit);
        this.clearEntryInfo("entry_gcontract", oldLetterCredit, nowLetterCredit);
    }

    private void clearEntryInfo(String entryName, DynamicObject oldLetterCredit, DynamicObject nowLetterCredit) {
        nowLetterCredit.getDynamicObjectCollection(entryName).clear();
        for (DynamicObject entry_a : oldLetterCredit.getDynamicObjectCollection(entryName)) {
            DynamicObject entry_l = nowLetterCredit.getDynamicObjectCollection(entryName).addNew();
            for (IDataEntityProperty property : entry_a.getDataEntityType().getProperties()) {
                if (!entry_l.getDataEntityType().getProperties().containsKey((Object)property.getName())) continue;
                entry_l.set(property, entry_a.get(property));
            }
            entry_l.set("id", entry_a.get("id"));
        }
    }

    private void setSelectorByEntity(List<String> sic) {
        DynamicObject entityObj = TmcDataServiceHelper.newDynamicObject((String)"lc_bizapply");
        for (IDataEntityProperty property : entityObj.getDataEntityType().getProperties()) {
            if (Arrays.asList(NO_SAVE_PROPERTYS).contains(property.getName()) || property.getName().endsWith("_id")) continue;
            sic.add(property.getName());
        }
    }
}

