/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.opservice.arrival;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.lc.common.enums.ArrivalStatusEnum;
import kd.tmc.lc.common.enums.ArrivalWayEnum;
import kd.tmc.lc.common.helper.LetterCreditHelper;

public class ArrivalBillAutoConfirmService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("arrivalway");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        HashMap<Long, BigDecimal> letterArrMap = new HashMap<Long, BigDecimal>(dataEntities.length);
        HashMap<Long, Date> letterDateArrMap = new HashMap<Long, Date>(dataEntities.length);
        for (DynamicObject arrivalBill : dataEntities) {
            arrivalBill.set("arrivalstatus", (Object)ArrivalStatusEnum.ARRIVAL_CONFIRM.getValue());
            arrivalBill.set("configtime", (Object)DateUtils.getCurrentTime());
            DynamicObject letterCredit = arrivalBill.getDynamicObject("lettercredit");
            if (!EmptyUtil.isNoEmpty((DynamicObject)letterCredit)) continue;
            BigDecimal arrAmt = letterArrMap.getOrDefault(letterCredit.getLong("id"), BigDecimal.ZERO);
            letterArrMap.put(letterCredit.getLong("id"), arrAmt.add(arrivalBill.getBigDecimal("arrivalamount")));
            if (letterCredit.getBoolean("isnegotiating")) {
                letterDateArrMap.put(letterCredit.getLong("id"), arrivalBill.getDate("endpaydate"));
            }
            if (!ArrivalWayEnum.PROTEST.getValue().equals(arrivalBill.getString("arrivalway"))) continue;
            LetterCreditHelper.updateLetterCreditLimit((String)"lc_lettercredit", (Long)letterCredit.getLong("id"), (DynamicObject)arrivalBill, (boolean)Boolean.TRUE);
        }
        SaveServiceHelper.update((DynamicObject[])dataEntities);
        LetterCreditHelper.updateLetterArr((String)"lc_lettercredit", letterArrMap, letterDateArrMap);
    }
}

