/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.opservice.arrival;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.lc.common.enums.ArrivalStatusEnum;
import kd.tmc.lc.common.helper.LetterCreditHelper;

public class ArrivalBillIscSaveService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("arrivalstatus");
        sic.add("lettercredit");
        sic.add("arrivalamount");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
    }

    public void beforeCommit(DynamicObject[] dataEntities) throws KDException {
        super.beforeCommit(dataEntities);
        HashSet<Long> lcIds = new HashSet<Long>(16);
        for (DynamicObject arrivalBill : dataEntities) {
            DynamicObject letterCredit = arrivalBill.getDynamicObject("lettercredit");
            lcIds.add(letterCredit.getLong("id"));
            LetterCreditHelper.deleteBotpRation((String)"lc_arrival", (Long)arrivalBill.getLong("id"), (String)"lc_lettercredit", (Long)(EmptyUtil.isEmpty((DynamicObject)letterCredit) ? 0L : letterCredit.getLong("id")));
            TmcBotpHelper.saveRelation((String)"lc_lettercredit", (Long)((Long)letterCredit.getPkValue()), (String)"lc_arrival", (Long)((Long)arrivalBill.getPkValue()));
        }
        this.updateLetterArr(lcIds);
    }

    private void updateLetterArr(Set<Long> lcIds) {
        DynamicObject[] letterBills;
        if (lcIds.size() == 0) {
            return;
        }
        QFilter qf = new QFilter("lettercredit", "in", lcIds);
        qf.and("arrivalstatus", "in", (Object)new String[]{ArrivalStatusEnum.ARRIVAL_CONFIRM.getValue(), ArrivalStatusEnum.ARRIVAL_PAY.getValue()});
        DynamicObjectCollection arrs = QueryServiceHelper.query((String)"lc_arrival", (String)String.join((CharSequence)",", "lettercredit", "arrivalamount"), (QFilter[])qf.toArray());
        HashMap<Long, BigDecimal> lc2ArrAmt = new HashMap<Long, BigDecimal>(16);
        for (DynamicObject o : arrs) {
            Long lcId = o.getLong("lettercredit");
            BigDecimal arrAmt = o.getBigDecimal("arrivalamount");
            BigDecimal amt = lc2ArrAmt.getOrDefault(lcId, BigDecimal.ZERO);
            lc2ArrAmt.put(lcId, amt.add(arrAmt));
        }
        DynamicObject[] dynamicObjectArray = letterBills = TmcDataServiceHelper.load((String)"lc_lettercredit", (String)"amount,amountscaleupper,totalarramount,notarramount", (QFilter[])new QFilter[]{new QFilter("id", "in", lcIds)});
        int n = dynamicObjectArray.length;
        for (int i = 0; i < n; ++i) {
            DynamicObject letterBill;
            BigDecimal totalArrAmount = lc2ArrAmt.getOrDefault((letterBill = dynamicObjectArray[i]).getLong("id"), BigDecimal.ZERO);
            letterBill.set("totalarramount", (Object)(totalArrAmount.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : totalArrAmount));
            BigDecimal notArrAmount = LetterCreditHelper.getAmount((DynamicObject)letterBill);
            notArrAmount = notArrAmount.subtract(totalArrAmount);
            letterBill.set("notarramount", (Object)(notArrAmount.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : notArrAmount));
        }
        SaveServiceHelper.update((DynamicObject[])letterBills);
    }
}

