/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.opservice.arrival;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.lc.common.enums.ArrivalStatusEnum;
import kd.tmc.lc.common.enums.ArrivalWayEnum;
import kd.tmc.lc.common.helper.LcFeeDetailHelper;
import kd.tmc.lc.common.helper.LetterCreditHelper;

public class ArrivalBillUnArrConfirmService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(ArrivalBillUnArrConfirmService.class);
    private static final String[] NO_SAVE_PROPERTYS = new String[]{"feedetail", "entrys", "id", "seq", "billno", "billstatus", "billhead_lk", "creator", "creatortime", "modifier", "modifytime", "auditor", "auditdate", "multilanguagetext", "commitentry"};

    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("arrivalway");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        HashMap<Long, BigDecimal> letterArrMap = new HashMap<Long, BigDecimal>(dataEntities.length);
        for (DynamicObject arrivalBill : dataEntities) {
            String billNo = arrivalBill.getString("billno");
            QFilter filter = new QFilter("billno", "=", (Object)billNo);
            DynamicObject history = TmcDataServiceHelper.loadSingle((String)"lc_arrival_h", (String)"id", (QFilter[])filter.toArray());
            DynamicObject arrival = TmcDataServiceHelper.loadSingle((Object)arrivalBill.getLong("id"), (String)"lc_arrival");
            logger.info("history=======================" + EmptyUtil.isNoEmpty((DynamicObject)history));
            if (EmptyUtil.isNoEmpty((DynamicObject)history)) {
                history = TmcDataServiceHelper.loadSingle((Object)history.getPkValue(), (String)history.getDynamicObjectType().getName());
                LcFeeDetailHelper.updateFeeDetailBill((DynamicObject)history, (DynamicObject)arrival, (ProductTypeEnum)ProductTypeEnum.LC_ARRIVAL);
                for (IDataEntityProperty property : arrival.getDataEntityType().getProperties()) {
                    String prop = property.getName();
                    if (!history.getDataEntityType().getProperties().containsKey((Object)prop) || Arrays.asList(NO_SAVE_PROPERTYS).contains(prop) || prop.endsWith("_id")) continue;
                    arrival.set(prop, history.get(prop));
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{arrival});
                DeleteServiceHelper.delete((String)"lc_arrival_h", (QFilter[])filter.toArray());
            } else {
                logger.info("update=======================");
                arrival.set("arrivalstatus", (Object)ArrivalStatusEnum.ARRIVAL_REGISTER.getValue());
                arrival.set("configtime", null);
                logger.info("status=======================" + arrival.getString("arrivalstatus"));
                SaveServiceHelper.update((DynamicObject)arrival);
            }
            DynamicObject letterCredit = arrivalBill.getDynamicObject("lettercredit");
            if (!EmptyUtil.isNoEmpty((DynamicObject)letterCredit)) continue;
            BigDecimal arrAmt = letterArrMap.getOrDefault(letterCredit.getLong("id"), BigDecimal.ZERO);
            letterArrMap.put(letterCredit.getLong("id"), arrAmt.subtract(arrivalBill.getBigDecimal("arrivalamount")));
            if (!ArrivalWayEnum.PROTEST.getValue().equals(arrivalBill.getString("arrivalway"))) continue;
            LetterCreditHelper.updateLetterCreditLimit((String)"lc_lettercredit", (Long)letterCredit.getLong("id"), (DynamicObject)arrivalBill, (boolean)Boolean.FALSE);
        }
        LetterCreditHelper.updateLetterArr((String)"lc_lettercredit", letterArrMap);
    }
}

