/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.opservice.arrival;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.service.ebservice.bean.SyncStatusResult;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;
import kd.tmc.lc.business.opservice.ebservice.api.EBServiceFacadeImpl;
import kd.tmc.lc.common.enums.ArrivalWayEnum;

public class ArrivalRecommitBeService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("opetype");
        selector.add("commitentry");
        selector.add("batchseqid");
        selector.add("committime");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject arrival : dataEntities) {
            String sql = ArrivalWayEnum.isAccept((String)arrival.getString("opetype")) ? "update t_lc_arrival_e set fisresubmit='1', facceptbebankstatus = 'OS', facceptsubmittime = ?,facceptreturnmsg=' ' where fid = ? and ftradechannel ='online' and facceptbebankstatus = 'TF'" : "update t_lc_arrival_e set fisresubmit='1', fbebankstatus = 'OS', fsubmittime = ?,freturnmsg=' ' where fid = ? and ftradechannel ='online'  and fbebankstatus = 'TF'";
            int[] result = DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)sql, Collections.singletonList(new Object[]{new Date(), arrival.getPkValue()}));
            if (result.length == 1) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u6709\u672a\u5b8c\u6210\u7684\u5230\u5355\u4e1a\u52a1\u5355\u636e, \u4e0d\u5141\u8bb8\u518d\u6b21\u63d0\u4ea4\u94f6\u4f01\u3002", (String)"AbstractArrivalCommitBeService_0", (String)"tmc-lc-business", (Object[])new Object[0]));
        }
        for (DynamicObject arrival : dataEntities) {
            DynamicObjectCollection entry = arrival.getDynamicObjectCollection("commitentry");
            DynamicObject row = entry.addNew();
            row.set("batchseqid", (Object)DBServiceHelper.genGlobalLongId());
            row.set("committime", (Object)new Date());
        }
        SaveServiceHelper.save((DynamicObject[])dataEntities);
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject arrival : dataEntities) {
            List<SyncStatusResult> result = new EBServiceFacadeImpl().commit(this.getCommitBeType(arrival.getString("opetype")), dataEntities[0].getDataEntityType().getName(), Collections.singletonList(arrival.getLong("id")));
            List errList = result.stream().filter(o -> o.getStatusCode() == EBResultStatusCode.ERROR || o.getStatusCode() == EBResultStatusCode.ROLLBACK).collect(Collectors.toList());
            StringBuilder errMsg = new StringBuilder();
            for (SyncStatusResult errResult : errList) {
                errMsg.append(errResult.getErrMsg()).append(' ');
            }
            if (errMsg.length() <= 0) continue;
            throw new KDBizException(errMsg.toString());
        }
    }

    private String getCommitBeType(String opeType) {
        String result = "";
        switch (opeType) {
            case "accept": {
                result = "aceptCredit";
                break;
            }
            case "payment": {
                result = "paymentCredit";
                break;
            }
            case "protest": {
                result = "refuseCredit";
                break;
            }
        }
        return result;
    }
}

