/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.opservice.config;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.log.api.AppLogInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.CreditLimitServiceHelper;
import kd.tmc.fbp.common.helper.GuaranteeUseHelper;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.guaranteeuse.GuaranteeUseBean;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.lc.common.enums.LetterCreditStatusEnum;
import kd.tmc.lc.common.helper.LetterCreditHelper;
import kd.tmc.lc.common.property.LetterCreditProp;

public class BizConfigConfirmService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("id");
        sic.add("creditstatus");
        sic.add(LetterCreditProp.SURPLUSAMOUNT);
        sic.add(LetterCreditProp.SRCCREDITLIMIT);
        sic.add("amountscaleupper");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject data : dataEntities) {
            String entity = (String)this.operationVariable.get(LetterCreditProp.ENTITY);
            DynamicObject creditBill = TmcDataServiceHelper.loadSingle((Object)data.getLong("id"), (String)entity);
            String operate = data.getString("operate");
            String creditStatus = "";
            switch (operate) {
                case "close": {
                    creditStatus = LetterCreditStatusEnum.DONE_CLOSE.getValue();
                    this.bizConfigConfirmClose(creditBill, data, entity);
                    LetterCreditHelper.updateSuretyStatus((DynamicObject)creditBill, (String)creditStatus);
                    break;
                }
                case "activate": {
                    creditStatus = LetterCreditStatusEnum.DONE_REGISTER.getValue();
                    this.bizConfigConfirmActivate(creditBill, data, entity);
                    LetterCreditHelper.updateSuretyStatus((DynamicObject)creditBill, (String)creditStatus);
                    break;
                }
                case "repeal": {
                    creditStatus = LetterCreditStatusEnum.DONE_REPEAL.getValue();
                    this.bizConfigConfirmRepeal(creditBill, data);
                    break;
                }
                case "creditchange": {
                    creditStatus = LetterCreditStatusEnum.DONE_REGISTER.getValue();
                    this.bizConfigConfirmCreditchange(creditBill, data);
                }
            }
            creditBill.set("creditstatus", (Object)creditStatus);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{creditBill});
            AppLogInfo info = new AppLogInfo();
            info.setBizAppID(TmcAppEnum.LC.getValue());
            info.setBizObjID("lc_lettercredit");
            info.setOpName(operate);
            info.setOpDescription(operate + " description");
            RequestContext context = RequestContext.get();
            info.setUserID(Long.valueOf(context.getCurrUserId()));
            info.setOrgID(Long.valueOf(context.getOrgId()));
            info.setClientType(context.getClient());
            info.setClientIP(context.getLoginIP());
            info.setOpTime(new Date());
            info.setAccountId(context.getAccountId());
            LogServiceHelper.addLog((AppLogInfo)info);
        }
    }

    private void bizConfigConfirmClose(DynamicObject creditBill, DynamicObject data, String entity) {
        if ("lc_lettercredit".equals(entity)) {
            BigDecimal amount = data.getBigDecimal(LetterCreditProp.SURPLUSAMOUNT);
            creditBill.set("isclosed", (Object)true);
            this.returnCreditLimit(creditBill, amount);
            creditBill.set("closecarddate", (Object)DateUtils.getCurrentDate());
            creditBill.set("repealdate", null);
        }
    }

    private void bizConfigConfirmActivate(DynamicObject creditBill, DynamicObject data, String entity) {
        DynamicObject changeCredit = data.getDynamicObject(LetterCreditProp.CHANGECREDITLIMIT);
        if ("lc_lettercredit".equals(entity)) {
            if (EmptyUtil.isNoEmpty((DynamicObject)changeCredit)) {
                creditBill.set("creditlimit", (Object)changeCredit);
                LetterCreditHelper.autoUseCreditLimit((DynamicObject)creditBill, (boolean)false, (boolean)false, null);
                CreditLimitServiceHelper.confirmCreditLimit((DynamicObject)creditBill, null, (boolean)false, (Date)new Date());
            } else {
                creditBill.set("creditlimit", null);
                creditBill.set("isclosed", (Object)false);
            }
            creditBill.set("closecarddate", null);
        }
    }

    private void bizConfigConfirmRepeal(DynamicObject creditBill, DynamicObject data) {
        BigDecimal amount = LetterCreditHelper.getAmount((DynamicObject)data);
        BigDecimal amt = amount.subtract(data.getBigDecimal(LetterCreditProp.ARRIVEAMOUNT));
        if (BigDecimal.ZERO.compareTo(amt) > 0) {
            amt = amt.add(data.getBigDecimal(LetterCreditProp.ARRIVEAMOUNT));
        }
        this.returnCreditLimit(creditBill, amt);
        creditBill.set("closecarddate", null);
        creditBill.set("repealdate", (Object)DateUtils.getCurrentDate());
    }

    private void bizConfigConfirmCreditchange(DynamicObject creditbill, DynamicObject data) {
        DynamicObject changeCredit = data.getDynamicObject(LetterCreditProp.CHANGECREDITLIMIT);
        creditbill.set("credittype", data.get(LetterCreditProp.CHANGECREDITTYPE));
        creditbill.set("isclosed", (Object)false);
        if (EmptyUtil.isNoEmpty((DynamicObject)changeCredit)) {
            DynamicObject secCredit = data.getDynamicObject(LetterCreditProp.SRCCREDITLIMIT);
            if (EmptyUtil.isNoEmpty((DynamicObject)secCredit)) {
                CreditLimitServiceHelper.cancelCreditLimit((DynamicObject)creditbill, null, (boolean)false);
                GuaranteeUseHelper.deleteGuaranteeUse((DynamicObject[])new DynamicObject[]{creditbill});
            }
            creditbill.set("creditlimit", (Object)changeCredit);
            LetterCreditHelper.autoUseCreditLimit((DynamicObject)creditbill, (boolean)false, (boolean)false, null);
            CreditLimitServiceHelper.confirmCreditLimit((DynamicObject)creditbill, null, (boolean)false, (Date)new Date());
            this.saveGuaranteeUse(changeCredit, creditbill);
        } else {
            DynamicObject secCredit = data.getDynamicObject(LetterCreditProp.SRCCREDITLIMIT);
            if (EmptyUtil.isNoEmpty((DynamicObject)secCredit)) {
                CreditLimitServiceHelper.cancelCreditLimit((DynamicObject)creditbill, null, (boolean)false);
                creditbill.set("creditlimit", null);
                GuaranteeUseHelper.deleteGuaranteeUse((DynamicObject[])new DynamicObject[]{creditbill});
            }
        }
        creditbill.set("remark", data.get("remark"));
    }

    private void saveGuaranteeUse(DynamicObject changeCredit, DynamicObject creditBill) {
        DynamicObjectCollection guaranteeUseBills = QueryServiceHelper.query((String)"gm_guaranteeuse", (String)String.join((CharSequence)",", "gcomment", "gcontract", "gamount", "gcontract.amount", "gcontract.currency", "gratio", "gexchrate"), (QFilter[])new QFilter[]{new QFilter("gsrcbillid", "=", changeCredit.getPkValue())}, (String)"id");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)guaranteeUseBills)) {
            return;
        }
        DynamicObject creditUseBill = CreditLimitServiceHelper.getCreditUseBill((Long)creditBill.getLong("id"), (String)creditBill.getDataEntityType().getName());
        ArrayList<GuaranteeUseBean> gUseBeanList = new ArrayList<GuaranteeUseBean>(guaranteeUseBills.size());
        for (DynamicObject guaranteeUseBill : guaranteeUseBills) {
            GuaranteeUseBean gUse = new GuaranteeUseBean();
            gUse.setSrcBillId(Long.valueOf(creditBill.getLong("id")));
            gUse.setSrcBillType(creditBill.getDataEntityType().getName());
            gUse.setSrcBillNo(creditBill.getString("billno"));
            gUse.setgContractId(Long.valueOf(guaranteeUseBill.getLong("gcontract")));
            BigDecimal amount = guaranteeUseBill.getBigDecimal("gamount");
            BigDecimal gRatio = guaranteeUseBill.getBigDecimal("gratio");
            if (EmptyUtil.isNoEmpty((DynamicObject)creditUseBill)) {
                gRatio = guaranteeUseBill.getBigDecimal("gratio").multiply(creditUseBill.getBigDecimal("creditratio")).divide(Constants.ONE_HUNDRED);
            }
            gUse.setgRatio(gRatio);
            gUse.setBizAmount(creditBill.getBigDecimal("amount"));
            gUse.setgAmount(amount.multiply(gRatio).divide(Constants.ONE_HUNDRED));
            gUse.setComment(guaranteeUseBill.getString("gcomment"));
            Long gCcyId = guaranteeUseBill.getLong("gcontract.currency");
            Long bizOrgId = creditBill.getDynamicObject("org").getLong("id");
            String bizOrgText = creditBill.getDynamicObject("org").getString("name");
            Long bizCcyId = creditBill.getDynamicObject("currency").getLong("id");
            BigDecimal rate = BigDecimal.ONE;
            if (!gCcyId.equals(bizCcyId)) {
                Long orgId = creditBill.getDynamicObject("org").getLong("id");
                rate = TmcBusinessBaseHelper.getExchangeRate((long)bizCcyId, (long)gCcyId, (long)orgId, (Date)DateUtils.getCurrentDate());
            }
            gUse.setExchrate(rate);
            gUse.setDebtOrgId(bizOrgId);
            gUse.setDebtOrgText(bizOrgText);
            gUse.setDebtCurrencyId(bizCcyId);
            gUseBeanList.add(gUse);
        }
        GuaranteeUseHelper.saveGuaranteeUse(gUseBeanList);
    }

    private void returnCreditLimit(DynamicObject creditBill, BigDecimal amount) {
        if (EmptyUtil.isNoEmpty((DynamicObject)creditBill.getDynamicObject("creditlimit")) && BigDecimal.ZERO.compareTo(amount) != 0) {
            CreditLimitServiceHelper.returnCreditLimit((DynamicObject)creditBill, (DynamicObject)creditBill, (boolean)false, (BigDecimal)amount, (Long)((Long)creditBill.getPkValue()), (boolean)true, (Date)new Date());
        }
    }
}

