/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.opservice.ebservice.request;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.tmc.fbp.webapi.ebentity.EBHeader;
import kd.tmc.fbp.webapi.ebentity.EBRequest;
import kd.tmc.fbp.webapi.ebentity.biz.lettercredit.OpenCreditRequest;
import kd.tmc.fbp.webapi.ebentity.biz.lettercredit.OpenCreditRequestBody;
import kd.tmc.lc.business.opservice.ebservice.request.AbstractRequestBuilder;
import kd.tmc.lc.business.opservice.ebservice.request.datasource.IEBRequestDataSource;

public class OpenCreditRequestBuilder
extends AbstractRequestBuilder {
    private final String bizType;
    private final String subBizType;

    public OpenCreditRequestBuilder(IEBRequestDataSource dataSource, String bizType, String subBizType) {
        super(dataSource);
        this.bizType = bizType;
        this.subBizType = subBizType;
    }

    public EBRequest buildRequest() {
        OpenCreditRequest letterCreditRequest = new OpenCreditRequest();
        letterCreditRequest.setHeader(this.buildHeader());
        letterCreditRequest.setBody(this.buildBody());
        return letterCreditRequest;
    }

    @Override
    protected EBHeader buildHeader() {
        EBHeader header = super.buildHeader();
        header.setBizType(this.bizType);
        header.setSubBizType(this.subBizType);
        header.setOperatorId(RequestContext.get().getUserId());
        return header;
    }

    protected OpenCreditRequestBody buildBody() {
        OpenCreditRequestBody body = new OpenCreditRequestBody();
        IEBRequestDataSource dataSource = this.getDataSource();
        body.setBatchSeqID(dataSource.getBatchSeqId());
        body.setBatchBizNo(dataSource.getBatchBizNo());
        List detailList = dataSource.getDetail();
        body.setTotalCount(detailList.size());
        BigDecimal totalAmt = detailList.stream().map(r -> new BigDecimal(r.getAmount())).reduce(BigDecimal.ZERO, BigDecimal::add);
        body.setTotalAmount(totalAmt.setScale(2, 1).toString());
        body.setDetails(detailList);
        return body;
    }
}

