/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.opservice.ebservice.request.datasource.arrival;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.DBServiceHelper;
import kd.tmc.fbp.common.helper.TmcAttachmentHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.webapi.ebentity.biz.lettercredit.OpenCreditRequestDetail;
import kd.tmc.fbp.webapi.ebentity.biz.paystatus.PayStatusBody;
import kd.tmc.lc.business.opservice.ebservice.request.datasource.IEBRequestDataSource;
import kd.tmc.lc.common.helper.OnlineServiceHelper;

public class ArrivalCommitDataSource
implements IEBRequestDataSource {
    private final DynamicObject arrival;
    private String subBizType;

    public ArrivalCommitDataSource(DynamicObject arrival, String subBizType) {
        this.arrival = arrival;
        this.subBizType = subBizType;
    }

    public List<OpenCreditRequestDetail> getDetail() {
        List attList;
        ArrayList<OpenCreditRequestDetail> details = new ArrayList<OpenCreditRequestDetail>();
        OpenCreditRequestDetail detail = new OpenCreditRequestDetail();
        detail.setDetailSeqID(this.arrival.getString("id"));
        detail.setDetailBizNo(String.valueOf(DBServiceHelper.genGlobalLongId()));
        detail.setApplicantCreditNum(this.arrival.getDynamicObject("org").getString("uniformsocialcreditcode"));
        detail.setAcptDate(DateUtils.formatString((Date)DateUtils.getCurrentDate(), (String)"yyyyMMdd"));
        DynamicObject letterCredit = this.arrival.getDynamicObject("lettercredit");
        String creditNo = Optional.ofNullable(letterCredit).map(r -> r.getString("number")).orElse("");
        detail.setCreditNo(creditNo);
        detail.setReceivedNo(this.arrival.getString("arrivalno"));
        detail.setBusAmt(this.exchangeAmountScale(this.arrival.getBigDecimal("arrivalamount")));
        String busCurrecnyNo = Optional.ofNullable(this.arrival.getDynamicObject("arrivalcurrency")).map(r -> r.getString("number")).orElse("");
        detail.setBusCurrency(busCurrecnyNo);
        String contactor = Optional.ofNullable(letterCredit).map(r -> r.getString("bizcontactor.name")).orElse("");
        detail.setOprNm(contactor);
        String contactInfo = Optional.ofNullable(letterCredit).map(r -> r.getString("bizcontactinfo")).orElse("");
        detail.setOprTel(contactInfo);
        detail.setTxnPscpt("remark");
        BigDecimal lcAmt = Optional.ofNullable(letterCredit).map(r -> r.getBigDecimal("amount")).map(r -> r.setScale(2, 4)).orElse(BigDecimal.ZERO);
        detail.setAmount(lcAmt.toString());
        String currency = Optional.ofNullable(letterCredit).map(r -> r.getDynamicObject("currency")).map(r -> r.getString("number")).orElse("");
        detail.setCurrency(currency);
        Map attachmentMap = TmcAttachmentHelper.getAttachments((String)"lc_arrival", (Long[])new Long[]{this.arrival.getLong("id")});
        String fileList = "";
        if (EmptyUtil.isNoEmpty((Object)attachmentMap) && attachmentMap.size() >= 1 && EmptyUtil.isNoEmpty((Object)(attList = (List)attachmentMap.get(this.arrival.getPkValue().toString())))) {
            List urls = attList.stream().map(r -> (String)r.get("url")).collect(Collectors.toList());
            fileList = String.join((CharSequence)";", urls);
        }
        detail.setFileList(fileList);
        switch (this.subBizType) {
            case "paymentCredit": {
                detail.setPayAccno(this.arrival.getString("payaccno.number"));
                detail.setPayAccCurrency(busCurrecnyNo);
                detail.setPayAmt(this.exchangeAmountScale(this.arrival.getBigDecimal("payamt")));
                String payAcctNo2 = Optional.ofNullable(this.arrival.getDynamicObject("payaccno2")).map(r -> r.getString("number")).orElse("");
                detail.setPayAccno2(payAcctNo2);
                detail.setPayAccCurrency2(EmptyUtil.isNoEmpty((String)payAcctNo2) ? busCurrecnyNo : "");
                detail.setPayAmt2(EmptyUtil.isNoEmpty((String)payAcctNo2) ? this.exchangeAmountScale(this.arrival.getBigDecimal("payamt2")) : "");
                detail.setPayeeCountry("");
                detail.setPayNature(this.arrival.getString("paynature"));
                detail.setIbpIsref(this.arrival.getBoolean("ibpisref") ? "Y" : "N");
                detail.setIbpPaytype(this.arrival.getBoolean("ibppaytype") ? "A" : "O");
                detail.setTranCode(this.arrival.getString("trancode"));
                BigDecimal payAmt1 = Optional.ofNullable(this.arrival.getBigDecimal("payamt")).orElse(BigDecimal.ZERO);
                BigDecimal payAmt2 = Optional.ofNullable(this.arrival.getBigDecimal("payamt2")).orElse(BigDecimal.ZERO);
                BigDecimal corrAmt = payAmt1.add(payAmt2);
                detail.setCorrAmt(this.exchangeAmountScale(corrAmt));
                detail.setIbpRegno("N/A");
                break;
            }
            case "refuseCredit": {
                detail.setCostBearParty(this.arrival.getString("costbearparty"));
                detail.setFeeMode(this.arrival.getString("feemode"));
                detail.setDocPcsMode(this.arrival.getString("docpcsmode"));
                detail.setReject(this.arrival.getString("rejectinfo"));
                break;
            }
            case "aceptCredit": {
                Date endPayDate = this.arrival.getDate("endpaydate");
                if (!EmptyUtil.isNoEmpty((Object)endPayDate)) break;
                detail.setDueDate(DateUtils.formatString((Date)endPayDate, (String)"yyyyMMdd"));
                break;
            }
        }
        details.add(detail);
        return details;
    }

    @Override
    public PayStatusBody getUpdateBody() {
        return null;
    }

    @Override
    public String getAcctNo() {
        DynamicObject directConnSet = OnlineServiceHelper.getDirectConnSetForArrival((DynamicObject)this.arrival);
        return Optional.ofNullable(directConnSet).map(r -> r.getDynamicObject("defaultaccount")).map(r -> r.getString("number")).orElse("");
    }

    @Override
    public String getCurrency() {
        return Optional.ofNullable(this.arrival.getDynamicObject("arrivalcurrency")).map(r -> r.getString("number")).orElse("");
    }

    @Override
    public String getBatchSeqId() {
        return OnlineServiceHelper.getCommitBatchSeqId((DynamicObject)this.arrival);
    }

    @Override
    public String getBatchBizNo() {
        return String.valueOf(DBServiceHelper.genGlobalLongId());
    }

    @Override
    public String getExtData() {
        return null;
    }

    private String exchangeAmountScale(BigDecimal amount) {
        return this.exchangeAmountScale(amount, 2);
    }

    private String exchangeAmountScale(BigDecimal amount, int scale) {
        return amount.setScale(scale, 1).toString();
    }
}

