/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.opservice.ebservice.request.datasource.lettercredit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcAttachmentHelper;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.webapi.ebentity.biz.lettercredit.OpenCreditRequestDetail;
import kd.tmc.fbp.webapi.ebentity.biz.paystatus.PayStatusBody;
import kd.tmc.lc.business.opservice.ebservice.request.datasource.IEBRequestDataSource;
import kd.tmc.lc.common.enums.PaymentTypeEnum;
import kd.tmc.lc.common.helper.OnlineServiceHelper;
import org.apache.commons.lang3.tuple.Pair;

public class OpenCreditDataSource
implements IEBRequestDataSource {
    private final DynamicObject letterCredit;

    public OpenCreditDataSource(DynamicObject letterCredit) {
        this.letterCredit = letterCredit;
    }

    @Override
    public PayStatusBody getUpdateBody() {
        return null;
    }

    @Override
    public String getAcctNo() {
        DynamicObject directConnSet = OnlineServiceHelper.getDirectConnSet((DynamicObject)this.letterCredit);
        return Optional.ofNullable(directConnSet).map(r -> r.getDynamicObject("defaultaccount")).map(r -> r.getString("number")).orElse("");
    }

    @Override
    public String getCurrency() {
        return Optional.ofNullable(this.letterCredit.getDynamicObject("currency")).map(r -> r.getString("number")).orElse("");
    }

    @Override
    public String getBatchSeqId() {
        return this.letterCredit.getPkValue().toString();
    }

    @Override
    public String getBatchBizNo() {
        return this.letterCredit.getString("billno");
    }

    @Override
    public String getExtData() {
        return null;
    }

    public List<OpenCreditRequestDetail> getDetail() {
        ArrayList<OpenCreditRequestDetail> details = new ArrayList<OpenCreditRequestDetail>();
        OpenCreditRequestDetail detail = new OpenCreditRequestDetail();
        String customBizNo = this.letterCredit.getString("billno");
        detail.setDetailSeqID(this.letterCredit.getPkValue().toString());
        detail.setDetailBizNo(customBizNo);
        detail.setApplicantCreditNum(this.letterCredit.getDynamicObject("org").getString("uniformsocialcreditcode"));
        detail.setCreditNo(this.letterCredit.getString("creditno"));
        String currencyNum = Optional.ofNullable(this.letterCredit.getDynamicObject("currency")).map(r -> r.getString("number")).orElse("");
        detail.setCurrency(currencyNum);
        detail.setAmount(this.exchangeAmountScale(this.letterCredit.getBigDecimal("amount")));
        DynamicObjectCollection contractEntry = this.letterCredit.getDynamicObjectCollection("entrys");
        String contractNo = "";
        String contractCurrency = "";
        BigDecimal contractAmt = this.letterCredit.getBigDecimal("amount");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)contractEntry)) {
            DynamicObject row = (DynamicObject)contractEntry.get(0);
            contractNo = row.getString("contractnum");
            contractAmt = row.getBigDecimal("contractamount");
            contractCurrency = row.getString("contractcurrency.number");
        }
        detail.setContractNo(contractNo);
        detail.setContractAmount(this.exchangeAmountScale(contractAmt));
        detail.setCreditType(this.letterCredit.getBoolean("isforward") ? "2" : "1");
        detail.setCreditMode("1");
        detail.setCreditForm("1");
        detail.setOpenDate(DateUtils.formatString((Date)this.letterCredit.getDate("bizdate"), (String)"yyyyMMdd"));
        BigDecimal moreRate = Optional.ofNullable(this.letterCredit.getBigDecimal("amountscaleupper")).orElse(BigDecimal.ZERO);
        detail.setMoreProportion(this.exchangeAmountScale(moreRate, 0));
        BigDecimal lessRate = Optional.ofNullable(this.letterCredit.getBigDecimal("amountscalelow")).orElse(BigDecimal.ZERO);
        detail.setLessProportion(this.exchangeAmountScale(lessRate, 0));
        String dueDateStr = "";
        Date dueDate = this.letterCredit.getDate("validdate");
        if (EmptyUtil.isNoEmpty((Object)dueDate)) {
            dueDateStr = DateUtils.formatString((Date)dueDate, (String)"yyyyMMdd");
        }
        detail.setDueDate(dueDateStr);
        detail.setDueAddress(this.letterCredit.getString("validaddress"));
        detail.setApplicantAddressEN(this.letterCredit.getString("applyaddress"));
        detail.setCounterAddress(this.letterCredit.getString("benefitaddress"));
        detail.setMrgnProportion("0");
        detail.setMrgnAcc1Type("");
        detail.setMrgnAccno("");
        detail.setMrgnCurrency("");
        String feeAcctNo = Optional.ofNullable(this.letterCredit.getDynamicObject("lfeeacctbank")).map(r -> r.getString("number")).orElse("");
        detail.setCharAccNo(feeAcctNo);
        String charCurrency = "";
        if (EmptyUtil.isNoEmpty((String)feeAcctNo)) {
            charCurrency = currencyNum;
        }
        detail.setCharCurrency(charCurrency);
        String costBear = Optional.ofNullable(this.letterCredit.getDynamicObject("feepayer")).map(r -> r.getString("number")).orElse("");
        detail.setCostBear(costBear);
        String oprName = Optional.ofNullable(this.letterCredit.getDynamicObject("bizcontactor")).map(r -> r.getString("name")).orElse("");
        if (OnlineServiceHelper.CCB_BANKTYPE.equals(this.getBankTypeId())) {
            oprName = Optional.ofNullable(this.letterCredit.getDynamicObject("bizcontactor")).map(r -> r.getString("fullpinyin")).orElse("");
        }
        detail.setOprNm(oprName);
        detail.setOprTel(this.letterCredit.getString("bizcontactinfo"));
        String adVBicCode = this.letterCredit.getString("noticebank");
        if (this.letterCredit.getDynamicObjectType().getProperties().containsKey((Object)"basenoticebank") && EmptyUtil.isNoEmpty((DynamicObject)this.letterCredit.getDynamicObject("basenoticebank"))) {
            adVBicCode = Optional.ofNullable(this.letterCredit.getDynamicObject("basenoticebank")).map(r -> r.getString("swift_code")).orElse("");
        }
        detail.setAdviCnapsCode(adVBicCode);
        detail.setAdviAddress(this.letterCredit.getString("bankaddress"));
        detail.setForwardCnapsCode("");
        detail.setForwardAddress("");
        String avWtBank = "1";
        if (OnlineServiceHelper.CCB_BANKTYPE.equals(this.getBankTypeId())) {
            avWtBank = "6";
        }
        detail.setAvWtBank(avWtBank);
        detail.setAvWtBankBic("");
        detail.setAvWtBankNmAdd("");
        detail.setDraftCustFlg("1");
        detail.setPayType(PaymentTypeEnum.turnValToBankVal((String)this.letterCredit.getString("paymenttype")));
        int forwardDays = this.letterCredit.getInt("forwarddays");
        detail.setPayDays(String.valueOf(forwardDays));
        String conInstrction = "3";
        if (OnlineServiceHelper.CCB_BANKTYPE.equals(this.getBankTypeId())) {
            conInstrction = "1";
        }
        detail.setConInstructions(conInstrction);
        detail.setAcceptorCnapsCode("");
        detail.setAcceptorAddress("");
        detail.setCashWay("3");
        detail.setDraftProportion("100");
        detail.setDraftAmt("");
        detail.setMixDraftInvProportion("");
        detail.setMixDraftInvAmt("");
        detail.setMixTenorType("");
        detail.setMixTenorDays("");
        detail.setExplain(this.letterCredit.getString("validaddress"));
        String openBankBic = Optional.ofNullable(this.letterCredit.getDynamicObject("bank")).map(r -> r.getString("swift_code")).orElse("");
        detail.setDraweeCnapsCode(openBankBic);
        detail.setDraweeAddress("");
        detail.setIsPartShip(this.exchangeBooleanToStr(this.letterCredit.getBoolean("isbatch")));
        detail.setIsTranShip(this.exchangeBooleanToStr(this.letterCredit.getBoolean("istransfer")));
        String shipDateStr = "";
        Date lastDate = this.letterCredit.getDate("lastdate");
        if (EmptyUtil.isNoEmpty((Object)lastDate)) {
            shipDateStr = DateUtils.formatString((Date)lastDate, (String)"yyyyMMdd");
        }
        detail.setShipDate(shipDateStr);
        detail.setLastShipDate(shipDateStr);
        detail.setPresentPeriod(this.letterCredit.getString("days"));
        detail.setPresentDay(String.valueOf(this.letterCredit.getInt("days")));
        detail.setDeliveryPort(this.letterCredit.getString("destination"));
        detail.setStartAir(this.letterCredit.getString("startplace"));
        detail.setTerminiAir(this.letterCredit.getString("unloadplace"));
        detail.setTermini(this.letterCredit.getString("destination"));
        detail.setGasDescription(this.letterCredit.getString("cargodesc"));
        detail.setDocClause(this.letterCredit.getString("billterm_tag"));
        detail.setAddClause(this.letterCredit.getString("addterm_tag"));
        detail.setRemark(this.letterCredit.getString("remark"));
        detail.setBankRefDate("");
        detail.setBankRefKey("");
        String fileUrl = TmcParameterHelper.getAppStringParameter((String)TmcAppEnum.LC.getId(), (long)this.letterCredit.getLong("org_id"), (String)"sftpurl");
        detail.setFileUrl(fileUrl);
        Pair<String, String> pair = this.buildFileName(customBizNo, this.letterCredit.getLong("id"));
        detail.setFileName((String)pair.getLeft());
        detail.setFileList((String)pair.getRight());
        String applicantName = Optional.ofNullable(this.letterCredit.getDynamicObject("org")).map(r -> r.getString("name")).orElse("");
        if (OnlineServiceHelper.CCB_BANKTYPE.equals(this.getBankTypeId())) {
            DynamicObject directConnSet = OnlineServiceHelper.getDirectConnSet((DynamicObject)this.letterCredit);
            applicantName = Optional.ofNullable(directConnSet).map(r -> r.getDynamicObject("defaultaccount")).map(r -> r.getString("englishname")).orElse("");
        }
        detail.setApplicantName(applicantName);
        String benefiterName = Optional.ofNullable(this.letterCredit.getDynamicObject("benefiter")).map(r -> r.getLocaleString("name")).map(r -> r.getLocaleValue_en()).orElseGet(() -> this.letterCredit.getString("benefiterother"));
        detail.setCounterName(benefiterName);
        String twoCountryCode = Optional.ofNullable(this.letterCredit.getDynamicObject("benefitcountry")).map(r -> r.getString("twocountrycode")).orElse("");
        detail.setCounterCountry(twoCountryCode);
        String transFlag = this.letterCredit.getBoolean("ismakeover") ? "1" : "0";
        detail.setTransFlag(transFlag);
        detail.setContractCurrency(contractCurrency);
        detail.setAfterFrom("2");
        String paymentType = this.exchangePaymentType();
        detail.setDocs(paymentType);
        detail.setDrawOn("1");
        detail.setReceiptPlace(this.letterCredit.getString("unloadplace"));
        String mixTenor = forwardDays + " AFTER " + this.getPaymentTypeName(paymentType);
        detail.setMixTenor(mixTenor);
        String charges = Optional.ofNullable(this.letterCredit.getDynamicObject("feepayer")).map(r -> r.getString("name")).orElse("LAC-CUSTOMER");
        detail.setCharges(charges);
        details.add(detail);
        return details;
    }

    private Long getBankTypeId() {
        return Optional.ofNullable(this.letterCredit.getDynamicObject("bank")).map(r -> r.getLong("bank_cate.id")).orElse(0L);
    }

    private String exchangeBooleanToStr(boolean flag) {
        return flag ? "1" : "2";
    }

    private String exchangeAmountScale(BigDecimal amount) {
        return this.exchangeAmountScale(amount, 2);
    }

    private String exchangeAmountScale(BigDecimal amount, int scale) {
        return amount.setScale(scale, 1).toString();
    }

    private Pair<String, String> buildFileName(String customBizNo, long billId) {
        StringBuilder sb = new StringBuilder("XMGM_");
        sb.append(customBizNo);
        sb.append("_01-");
        Map attachmentMap = TmcAttachmentHelper.getAttachments((String)"lc_lettercredit", (Long[])new Long[]{billId});
        int fileNum = 0;
        String fileList = "";
        if (EmptyUtil.isNoEmpty((Object)attachmentMap) && attachmentMap.size() >= 1) {
            fileNum = attachmentMap.values().stream().map(r -> r.size()).reduce((a, b) -> a + b).orElse(0);
            List attList = (List)attachmentMap.get(String.valueOf(billId));
            if (EmptyUtil.isNoEmpty((Object)attList)) {
                List urls = attList.stream().map(r -> (String)r.get("url")).collect(Collectors.toList());
                fileList = String.join((CharSequence)";", urls);
            }
        }
        sb.append(fileNum);
        sb.append("_V01.zip");
        return Pair.of((Object)sb.toString(), (Object)fileList);
    }

    private String exchangePaymentType() {
        String docs;
        String paymentType;
        switch (paymentType = Optional.ofNullable(this.letterCredit.getString("paymenttype")).orElse("")) {
            case "invoiceforward": {
                docs = "02";
                break;
            }
            case "preinstforward": {
                docs = "01";
                break;
            }
            case "presentforward": {
                docs = "03";
                break;
            }
            case "sailingforward": {
                docs = "06";
                break;
            }
            default: {
                docs = "08";
            }
        }
        return docs;
    }

    private String getPaymentTypeName(String number) {
        String name;
        switch (number) {
            case "02": {
                name = "DATE OF INVOICE";
                break;
            }
            case "01": {
                name = "B/L DATE";
                break;
            }
            case "03": {
                name = "DRAFT DATE";
                break;
            }
            case "06": {
                name = "DATE OF SHIPMENT";
                break;
            }
            default: {
                name = "SIGHT";
            }
        }
        return name;
    }
}

