/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.business.opservice.ebservice.service;

import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.service.ebservice.service.IEBServiceExecutor;
import kd.tmc.fbp.service.ebservice.service.executor.EBServiceExecutor;

public class EBServiceExecutorFactory {
    public static IEBServiceExecutor getEBServiceExecutor() {
        if (EBServiceExecutorFactory.isTestEvn()) {
            String mockClzName = "kd.tmc.bei.unittest.mock.EBServiceMockExecutor";
            try {
                return (IEBServiceExecutor)Class.forName(mockClzName).newInstance();
            }
            catch (Exception e) {
                throw new KDBizException("Mock Executor not found: " + mockClzName);
            }
        }
        return new EBServiceExecutor();
    }

    private static boolean isTestEvn() {
        boolean existInterfaceInfo = DB.exitsTable((DBRoute)DBRouteConst.TMC, (String)"t_bei_interfaceinfomock");
        String tenantId = RequestContext.get().getTenantId();
        String accountId = RequestContext.get().getAccountId();
        boolean isLocalEvn = "tenant_devfi_dev".equals(tenantId) && "1150100171577623552".equals(accountId);
        boolean isPatchSmokeEvn = "tenant_patchfi_smoke".equals(tenantId) && "201912162149311205".equals(accountId);
        boolean isBaselineSmokeEvn = "baseline_smoke".equals(tenantId) && ("1562834230588".equals(accountId) || "1113059203489991680".equals(accountId));
        return existInterfaceInfo && (isLocalEvn || isPatchSmokeEvn || isBaselineSmokeEvn);
    }
}

